<?
header('Content-type: application/x-javascript; charset=UTF-8');
include_once '../includes/globals.php';
// Output JavaScript Translator object, using heredoc notation
echo <<< JavaScript
window.Translator = new function()
{
  this.translationArray = new Object();
  this.translate = function(msg)
  {
    var returnVal = msg;
    if (this.translationArray[msg])
    {
      returnVal = this.translationArray[msg];
    }
    return returnVal;
  }
  window.translate = function(msg)
  {
    return Translator.translate(msg);
  }
}

JavaScript;
// End of heredoc notation

// Output translation entries
$translationArray = buildTranslationArray(LANG);

echo "Translator.translationArray =\n{\n";
$first = true;
foreach ($translationArray as $key => $value)
{
  if (!$first)
    echo ",\n";
  else
    $first = false;
  printf('"%s" : "%s"', $key, convertValue($value));
}
echo "\n}";

function convertValue($value)
{
  $value = str_replace("\r\n", '<br />', $value);
  $value = str_replace("\n", '<br />', $value);
  return addslashes($value);
}
//*/
?>
