function BufferedViewController(frameARef, frameBRef)
{
  this.dummyURL = 'utils/dummy.html';
  this.hiddenClass = 'hiddenFrame';
  this.parameters = {};

  if (typeof frameARef == 'string')
    this.frameA = getElement(frameARef);
  else
    this.frameA = frameARef;

  if (typeof frameBRef == 'string')
    this.frameB = getElement(frameBRef);
  else
    this.frameB = frameBRef;

  this.currentFrame = this.frameA;
  this.hiddenFrame = this.frameB;

  this.queue = [];
  this.loading = false;
  
  var that = this;
  function loaded()
  {
    that.loading = false;
    if (that.queue.length > 0)
    {
      var url = that.queue[0];
      that.queue.splice(0,1);
      that.setURL(url);
    }
  }
  addEvent(this.frameA, "load", loaded);
  addEvent(this.frameB, "load", loaded);
}

BufferedViewController.prototype.getContentWindow = function getContentWindow()
{
  if (this.currentFrame.contentWindow)
    return this.currentFrame.contentWindow;
  else
    return null;
}

BufferedViewController.prototype.getContentDocument = function getContentDocument()
{
  if (this.currentFrame.contentDocument)
    return this.currentFrame.contentDocument;
  else if (this.getContentWindow().document)
    return this.getContentWindow().document;
  else
    return null;
}

BufferedViewController.prototype.hide = function hide(frame)
{
  frame.style.height = 0;
  frame.style.width = 0;
}

BufferedViewController.prototype.show = function show(frame)
{
  frame.style.width = '100%';
  Body.adjustToViewport(frame);
}

BufferedViewController.prototype.setURL = function setURL(newURL, targetCurrent)
{
  targetCurrent = targetCurrent || false;
  if (this.shouldSetURL(newURL))
  {
    this.willSetURL();
    if (targetCurrent)
      var frame = this.currentFrame;
    else
      var frame = this.hiddenFrame;
    var url = '';
    if (CONFIG != undefined && CONFIG.BASE_URI != undefined)
      url += CONFIG.BASE_URI;
    url += newURL;
    url = this.appendQueryString(url);
    Frontend.heartbeat(function ()
    {
      frame.src = url;
    });
    this.url = newURL;
    this.didSetURL();
  }
}

BufferedViewController.prototype.switchFrames = function switchFrames()
{
  var scrollPosition = this.getScrollPosition();
  if (this.currentFrame == this.frameA)
  {
    this.hide(this.frameA);
    this.show(this.frameB);
    this.currentFrame = this.frameB;
    this.hiddenFrame = this.frameA;
  }
  else
  {
    this.hide(this.frameB);
    this.show(this.frameA);
    this.currentFrame = this.frameA;
    this.hiddenFrame = this.frameB;
  }
  this.setScrollPosition(scrollPosition);
}

BufferedViewController.prototype.refresh = function refresh()
{
  this.setURL(this.url);
}

BufferedViewController.prototype.shouldSetURL = function shouldSetURL(url)
{
  if (this.loading === false)
  {
    return true;
  }
  else
  {
    this.queue.push(url);
    return false;
  }
}

BufferedViewController.prototype.willSetURL = function willSetURL()
{
  this.loading = true;
  if (CONFIG != undefined && CONFIG.DEBUG_MODE == true)
    this.setParameter('debugMode', 'on');
  //this.setParameter('r', Math.random());
  return true;
}

BufferedViewController.prototype.didSetURL = function didSetURL()
{
  return true;
}

BufferedViewController.prototype.appendQueryString = function appendQueryString(url)
{
  var queryBits = [];
  var parameters = this.parameters;
  for (var key in parameters)
  {
    var value = parameters[key];
    if (value != null)
    {
      if (value.classid && value.classid == 'array')
      {
        var count = value.length;
        for (var i=0; i<count; i++)
        {
          queryBits.push(key + '=' + value[i]);
        }
      }
      else
      {
        queryBits.push(key + '=' + value);
      }
    }
  }
  if (queryBits.length > 0)
    url += ('?' + queryBits.join('&'));
  return url;
}

BufferedViewController.prototype.setParameter = function addParameter(key, value)
{
  var parameters = this.parameters;
  if (key.substr(-2,2) == '[]')
  {
    if (parameters[key] == undefined)
      parameters[key] = [value];
    else
      parameters[key].push(value);
  }
  else
  {
    parameters[key] = value;
  }
}

BufferedViewController.prototype.unsetParameter = function removeParameter(key)
{
  var parameters = this.parameters;
  if (parameters[key] != undefined)
    parameters[key] = undefined;
}

BufferedViewController.prototype.clearParameters = function clearParameters()
{
  this.parameters = {};
}

BufferedViewController.prototype.getScrollPosition = function getScrollPosition()
{
  return this.getContentDocument().documentElement.scrollTop;
}

BufferedViewController.prototype.setScrollPosition = function setScrollPosition(position)
{
  this.getContentDocument().documentElement.scrollTop = position;
  return this.getScrollPosition();
}
