/********************************************************************
//        NAME- CollapsableListItem
// DESCRIPTION- A list item that contains a controller widget that
//              allows the item to 'collapse', rendering any sublists
//              hidden, or to 'expand', displaying any sublists
********************************************************************/

/********************************************************************
// CollapsableListItem(element) : constructor
//   element : Element
// Creates a new CollapsableListItem and adds the controller widget
//   to the element
********************************************************************/
function CollapsableListItem(element)
{
  this.children = []; // an array of sublists
  this.state    = 'empty'; // current state of the widget ('empty', 'expanded', 'collapsed')
  this.widget   = new CollapsingWidget(this); // a new CollapsingWidget object

  // get the valid representation of the element
  if (isElement(element))
    this.element = element;
  else if (typeof element == 'string')
    this.element = getElement(element);
  else
    throw('CollapsableListItem: invalid element - ' + element);

  this.init(); // initialize this object
}

/********************************************************************
// CollapsableListItem.init : function
// Initializes the object by appending the widget's element
********************************************************************/
CollapsableListItem.prototype.init = function init()
{
  if (this.element.hasChildNodes())
    this.element.insertBefore(this.widget.element, this.element.firstChild);
  else
    this.element.appendChild(this.widget.element);
}

/********************************************************************
// CollapsableListItem.expand : function
// Expands the list item, displaying its sublists
********************************************************************/
CollapsableListItem.prototype.expand = function expand()
{
  var children = this.children; // local scope this.children
  var numberOfChildren = children.length; 
  for (var i=0; i<numberOfChildren; i++)
  {
    // extend each child if needed
    if (children[i].extended == undefined)
      extendElement(children[i]);
    children[i].show(); // display the given child
  }
  this.widget.setState('expanded'); // update the state of the widget
}

/********************************************************************
// CollapsableListItem.collapse : function
// Collapses the list item, hiding its sublists
********************************************************************/
CollapsableListItem.prototype.collapse = function collapse()
{
  var children = this.children; // local scope this.children
  var numberOfChildren = children.length;
  for (var i=0; i<numberOfChildren; i++)
  {
    // extend each child if needed
    if (children[i].extended == undefined)
      extendElement(children[i]);
    children[i].hide(); // hide the given child
  }
  this.widget.setState('collapsed'); // update the state of the widget
}

/********************************************************************
// CollapsableListItem.addChild(child) : function
//   child : Element
// Adds a child to the object's children array
********************************************************************/
CollapsableListItem.prototype.addChild = function addChild(child)
{
  // only add the child if we don't already have it in the array
  if (!this.children.contains(child))
    this.children.push(child);

  // if the object now has more than 0 children, switch to the collapsed state
  if (this.children.length > 0)
    this.collapse();
  // if there are 0 children, set the widget state to empty
  else
    this.widget.setState('empty');
}

/********************************************************************
// CollapsableListItem.removeChild : function
//   child : Element
// Removes a child from the object's children array
********************************************************************/
CollapsableListItem.prototype.removeChild = function removeChild(child)
{
  // only try to remove the child if we contain the child
  if (this.children.contains(child))
    this.children.remove(row);

  // set the widget's state to empty if there are 0 children
  if (this.children.length <= 0)
    this.widget.setState('empty');
}
