function ModalDialog(id)
{
  this.element = newElement('div', {'class':'dialog'});
  if (id != undefined)
    this.element.id = id;

  inherit(this, new ModalElement(this.element));

  this.header    = this.element.appendChild(newElement('div', {'class':'header'}));
  this.body      = this.element.appendChild(newElement('div', {'class':'body'}));
  this.badge     = this.body.appendChild(newElement('img', {'class':'badge'}));
  this.content   = this.body.appendChild(newElement('div', {'class':'content'}));
  this.buttonBar = this.body.appendChild(newElement('div', {'class':'buttonBar'}));

  this.buttons = [];
  this.areButtonsVisibile = true;
}

ModalDialog.prototype.setContent = function setContent(contentHTML)
{
  this.content.innerHTML = contentHTML;
}

ModalDialog.prototype.setBadge = function setBadge(src)
{
  this.badge.src = src;
}

ModalDialog.prototype.setHeader = function setHeader(headerHTML)
{
  this.header.innerHTML = headerHTML;
}

ModalDialog.prototype.toggleContent = function toggleContent(show)
{
  if (show)
    this.content.show();
  else
    this.content.hide();
}

ModalDialog.prototype.toggleHeader = function toggleHeader(show)
{
  if (show)
    this.header.show();
  else
    this.header.hide();
}

ModalDialog.prototype.toggleBadge = function toggleBadge(show)
{
  if (show)
    this.badge.show();
  else
    this.badge.hide();
}

ModalDialog.prototype.toggleButtons = function toggleButtons(show)
{
  if (show)
  {
    this.buttonBar.show();
    this.areButtonsVisible = true;
  }
  else
  {
    this.buttonBar.hide();
    this.areButtonsVisible = false;
  }
}

ModalDialog.prototype.addButton = function addButton(caption, customID, onclick)
{
  caption  = caption  || translate('MSG_OK');
  customID = (customID != null) ? customID : caption;
  onclick  = onclick  || function ()
  {
    this.controller.hide();
  };
  var input = newElement('input', {'type':'button','value':caption,'onclick':onclick,'controller':this,'customID':customID});
  this.buttonBar.appendChild(input);
  return input;
}

ModalDialog.prototype.removeButton = function removeButton(input)
{
  if (input.parentNode == this.buttonBar)
    this.buttonBar.removeChild(input);
  return this;
}

ModalDialog.prototype.clearButtons = function clearButtons()
{
  clearChildren(this.buttonBar);
}

ModalDialog.prototype.didShow = function didShow()
{
  if (this.areButtonsVisibile = true)
  {
    var buttons = this.buttonBar.getElementsByTagName('input');
    if (buttons.length > 0)
      buttons[0].focus();
  }
}

ModalDialog.prototype.didHide = function didHide()
{
  var buttons = this.buttonBar.getElementsByTagName('input');
  var count = buttons.length;
  for (var i=0; i<count; i++)
    buttons[i].blur();
}
