function ModalElement(elementID)
{
  if (isElement(elementID))
    this.element = elementID;
  else if (typeof elementID == 'string')
    this.element = getElement(elementID);
  else
    throw('ModalElement: invalid elementID - ' + elementID);

  this.curtain = new ModalCurtain();
  //if (this.curtain == undefined)
    //ModalElement.prototype.curtain = new ModalCurtain(); // create global curtain

  this.init();
}

ModalElement.prototype.init = function init()
{
  this.element.controller = this;
  extendElement(this.element);
  this.element.style.position = 'absolute';
  this.element.style.zIndex = 1001;
  this.element.setTop(0);
  this.element.setLeft(0);
  this.element.cloak();
  this.element.show();
  Body.appendChild(this.element);
}

ModalElement.prototype.show = function show()
{
  if (this.shouldShow())
  {
    this.willShow();
    this.curtain.show();
    this.sizeAndPositionElement();
//    this.element.center();
    this.element.uncloak();
    this.didShow();
  }
}

ModalElement.prototype.sizeAndPositionElement = function sizeAndPositionElement()
{
  this.element.clearHeight();
  var height = this.element.getHeight();
  var bodyHeight = Body.getHeight();
  if (height > bodyHeight)
  {
    this.element.setHeight(height - (height - bodyHeight) - 20);
    this.element.style.overflow = "auto";
  }
  else
  {
    this.element.style.overflow = "";
  }
  this.element.center();
}

ModalElement.prototype.hide = function hide()
{
  if (this.shouldHide())
  {
    this.willHide();
    this.element.cloak();
    this.curtain.hide();
    this.didHide();
  }
}

ModalElement.prototype.shouldShow = function shouldShow()
{
  return true;
}

ModalElement.prototype.willShow = function willShow()
{
  return true;
}

ModalElement.prototype.didShow = function didShow()
{
  return true;
}

ModalElement.prototype.shouldHide = function shouldHide()
{
  return true;
}

ModalElement.prototype.willHide = function willHide()
{
  return true;
}

ModalElement.prototype.didHide = function didHide()
{
  return true;
}
