function SMHSessionRefresher()
{
  this.container = extendElement(getElement('smhRefreshFrameDiv'));
  this.frame = extendElement(getElement('smhRefreshFrame'));

  this.curtain = new ModalCurtain();

  this.target = 'utils/dummy.html';
  this.redirect = 'cpqlogin.htm';
  this.error = 'message.php';

  this.nullFunction = function () {};
  this.callback = this.nullFunction;
  this.queue = [];
  this.loading = false;
}

SMHSessionRefresher.prototype.heartbeat = function heartbeat(callback)
{
  callback = callback || this.nullFunction;
  if (this.loading == true)
  {
    this.queue.push(callback);
  }
  else
  {
    this.callback = callback;
    this.setURL(this.target);
  }
}

SMHSessionRefresher.prototype.frameLoaded = function frameLoaded()
{
  var location = new String(this.frame.contentWindow.location);
  if (location.indexOf(this.redirect) > -1)
  {
    this.showFrame();
    if (this.secondRefresh == undefined || this.secondRefresh == false)
    {
      this.setURL(this.target);
      this.secondRefresh = true;
    }
  }
  else if (location.indexOf(this.error) > -1)
  {
    this.setURL(this.target);
  }
  else if (location.indexOf(this.target) > -1)
  {
    this.hideFrame();
    this.secondRefresh = false;
    this.callback();
    this.callback = this.nullFunction;
    this.loading = false;
    if (this.queue.length > 0)
    {
      this.heartbeat(this.queue.shift());
    }
  }
}

SMHSessionRefresher.prototype.setURL = function setURL(url)
{
  this.loading = true;
  this.frame.src = (url + '?r=' + Math.random());
}

SMHSessionRefresher.prototype.showFrame = function showFrame()
{
  this.frame.setHeight(Body.getHeight() * 0.9);
  this.frame.setWidth(Body.getWidth() * 0.9);
  this.container.style.border = '3px solid #003366';
  this.curtain.show();
  this.container.centerTo(Body.element());
}

SMHSessionRefresher.prototype.hideFrame = function hideFrame()
{
  this.frame.setHeight(0);
  this.frame.setWidth(0);
  this.container.style.border = 'none';
  this.container.style.top = 0;
  this.container.style.left = 0;
  this.curtain.hide();
}
//*/
