/********************************************************************
//        NAME- ShadowBox
// DESCRIPTION- Constructor of the ShadowBox object
//      PASSED- controller (Object): the controller of the ShadowBox
//              parent (HTMLElement): the element that will contain
//                  the ShadowBox. Defaults to Body
//     RETURNS- 
//       NOTES- The ShadowBox creates a semi-transparent veil over
//              its parent element and displays a 'Loading' box. This
//              renders the element un-clickable and signifies an
//              element-level modal operation
********************************************************************/
function ShadowBox(controller, parent)
{
  this.controller = controller;
  this.parent = parent || Body.element();
  this.element = newElement('div', {'class':'shadowBox invisible'});
  this.messageBox = newElement('div', {'class':'shadowBoxMessage invisible', 'text':translate('MSG_LOADING')});

  this.init();
}

/********************************************************************
//        NAME- ShadowBox.prototype.init
// DESCRIPTION- Attaches the element and messageBox to the parent
//      PASSED- 
//     RETURNS- 
//       NOTES- 
********************************************************************/
ShadowBox.prototype.init = function init()
{
  this.parent.appendChild(this.element);
  this.parent.appendChild(this.messageBox);
  
}

/********************************************************************
//        NAME- ShadowBox.prototype.show
// DESCRIPTION- Makes the ShadowBox visible
//      PASSED- 
//     RETURNS- 
//       NOTES- Conforms the element to the size of its parentNode
//              and centers the messageBox to the element
********************************************************************/
ShadowBox.prototype.show = function show()
{
  this.parent.appendChild(this.element);
  this.parent.appendChild(this.messageBox);
  this.element.conformTo(this.element.parentNode);
  this.messageBox.centerTo(this.element);
  this.element.uncloak();
  this.messageBox.uncloak();
}

/********************************************************************
//        NAME- ShadowBox.prototype.hide
// DESCRIPTION- Makes the ShadowBox invisible
//      PASSED- 
//     RETURNS- 
//       NOTES- Uses cloak() instead of hide() on elements in order
//              to retain their sizes between show()'s
********************************************************************/
ShadowBox.prototype.hide = function hide()
{
  this.messageBox.cloak();
  this.element.cloak();
}
