function TabController()
{
  this.tabs       = {};
  this.currentTab = null;
}

TabController.prototype.addTab = function addTab(tabName, tabID, contentIDs, viewIDs, resizer)
{
  contentIDs  = contentIDs  || [];
  var newTab = new Tab(tabName, tabID, contentIDs, viewIDs, resizer, this);
  this.tabs[tabName] = newTab;
  return this;
}

/********************************************************************
//        NAME- TabController.prototype.removeTab
// DESCRIPTION- Removes the tab that corresponds to the given tabName
//      PASSED- tabName (string): the name of the tab to be removed
//     RETURNS- 
//       NOTES- 
********************************************************************/
TabController.prototype.removeTab = function removeTab(tabName)
{
  if (this.tabs[tabName] != undefined)
    this.tabs[tabName] = null;
  return this;
}

/********************************************************************
//        NAME- TabController.prototype.selectTab
// DESCRIPTION- Causes the tab specified by tabName to become active
//      PASSED- tabName (string): the name of the tab to activate
//     RETURNS- 
//       NOTES- This calls tabController.deselectTabs first, then
//              calls tab.makeActive() on the selected tab
********************************************************************/
TabController.prototype.selectTab = function selectTab(tabName, doActions)
{
  doActions = (doActions != undefined) ? doActions : true;
  // make sure the tab exists
  if (this.tabs[tabName] != undefined)
  {
    var tab = this.tabs[tabName];
    // make sure the tab is not disabled
    if (tab.isDisabled === false)
    {
      // deselect all tabs so only the selected tab is active
      this.deselectTabs();
      // make sure tab was successfully made active before reassigning currentTab
      var success = tab.makeActive(doActions);
      if (success === true)
        this.currentTab = tab;
    }
  }
  return this;
}

/********************************************************************
//        NAME- TabController.prototype.reselectTab
// DESCRIPTION- Calls tab.makeActive on the currentTab, used to force
//              the tab's actions to reoccur
//      PASSED- 
//     RETURNS- 
//       NOTES- 
********************************************************************/
TabController.prototype.reselectTab = function reselectTab()
{
  // make sure this.currentTab is defined first
  if (this.currentTab != undefined &&
      this.currentTab.name != undefined)
    this.selectTab(this.currentTab.name);
  return this;
}

/********************************************************************
//        NAME- TabController.prototype.deselectTabs
// DESCRIPTION- Calls tab.makeInactive() on all controlled tabs
//      PASSED- 
//     RETURNS- 
//       NOTES- 
********************************************************************/
TabController.prototype.deselectTabs = function deselectTabs()
{
  // parse through every property of tabs
  for (var key in this.tabs)
  {
    this.tabs[key].makeInactive();
  }
  return this;
}

/********************************************************************
//        NAME- TabController.prototype.disableTab
// DESCRIPTION- Disables a tab, rendering it unselectable
//      PASSED- tabName (string): the name of the tab to disable
//     RETURNS- 
//       NOTES- Calls tab.makeDisabled()
********************************************************************/
TabController.prototype.disableTab = function disableTab(tabName)
{
  if (this.tabs[tabName] != undefined)
    this.tabs[tabName].makeDisabled();
  return this;
}

/********************************************************************
//        NAME- TabController.prototype.enableTab
// DESCRIPTION- Enables a tab, making it selectable again
//      PASSED- tabName (string): the name of the tab to enable
//     RETURNS- 
//       NOTES- Calls tab.makeEnabled()
********************************************************************/
TabController.prototype.enableTab = function enableTab(tabName)
{
  if (this.tabs[tabName] != undefined)
    this.tabs[tabName].makeEnabled();
  return this;
}
