function TestComponentController()
{
  this.startRequest = new ServerRequest('commands/startCatalog.php', 'POST');

  this.statusURL = 'views/catalogStatus.php';
  this.resultURL = 'views/catalogResult.php';

  this.button = getElement('testComponentContinueButton');
  this.continuePanel = extendElement(getElement('testComponentContinuePanel'));

  this.viewController = new BufferedViewController('testComponentFrameA', 'testComponentFrameB');

  this.isRunning = false;
  this.hasCrashedChildren = false;
  this.processID = 0;

  this.init();
}

TestComponentController.prototype.init = function init()
{
  this.button.controller = this;
  this.button.action = function ()
  {
    this.controller.getResult();
    this.disable();
  }

  this.startRequest.controller = this;
  this.startRequest.callback = function (data)
  {
    this.controller.catalogBegan(data);
  }

  this.continuePanel.hide();

  return this;
}

TestComponentController.prototype.resize = function resize()
{
  Body.adjustToViewport(this.viewController.currentFrame);
}

TestComponentController.prototype.runCatalog = function runCatalog()
{
  Frontend.tabs.disableTab('test');
  this.startRequest.send();
}

TestComponentController.prototype.catalogBegan = function catalogBegan(data)
{
  if (data.name && data.name.indexOf('Error') >= 0)
  {
    alert(data.name + ': ' + data.value);
  }
  else
  {
    this.processID = data.processID;
    this.isRunning = true;
    this.refreshFrame();
  }
}

TestComponentController.prototype.refreshFrame = function refreshFrame()
{
  this.viewController.clearParameters();
  this.viewController.setParameter('processID', this.processID);
  this.viewController.setURL(this.statusURL);
}

TestComponentController.prototype.getResult = function getResult()
{
  this.viewController.clearParameters();
  this.viewController.setParameter('processID', this.processID);
  this.viewController.setURL(this.resultURL);
}

TestComponentController.prototype.displayResult = function displayResult()
{
  this.continuePanel.hide();
  this.resize();
  this.viewController.switchFrames();
  // these two lines force the frame to readjust its width in IE
  this.viewController.currentFrame.hide();
  this.viewController.currentFrame.show();
}

TestComponentController.prototype.update = function ()
{
  if (this.isRunning === true)
  {
    setTimeout(function ()
    {
      Frontend.testComponents.refreshFrame();
    }, 500);
  }
  else
  {
    Frontend.tabs.enableTab('test');
    if (this.hasCrashedChildren === true)
    {
      this.continuePanel.show();
      this.resize();
    }
    else
    {
      this.getResult();
    }
  }
}
//*/
