function TestLogController()
{
  this.saveCommand   = 'commands/saveTestLog.php';

  this.viewController = new ViewController('testLogFrame');
  this.viewURL = 'views/testLog.php';
  this.clearRequest = new ServerRequest('commands/clearTestLog.php');

  this.saveButton = getElement('saveTestLog');
  this.clearButton = getElement('clearTestLog');
  
  this.shadowBox = this.viewController.shadowBox;
  
  this.init();
}

TestLogController.prototype.init = function init()
{
  this.clearButton.controller = this;
  this.clearButton.action = function ()
  {
    this.controller.promptToClearLog(translate('MSG_ERROR_LOG'), this.controller);
  }
  this.clearButton.disable();

  this.saveButton.controller = this;
  this.saveButton.action = function ()
  {
    //Frontend.saveDialog.openDialog((translate('MSG_SAVE') + ' ' + translate('MSG_TEST_LOG')), 'testlog', this.controller);
    this.controller.save();
  }
  this.saveButton.disable();
  
  this.clearRequest.controller = this;
  this.clearRequest.callback = function ()
  {
    this.controller.refreshFrame();
  }
}

TestLogController.prototype.refreshFrame = function refreshFrame()
{
  this.viewController.setURL(this.viewURL);
  this.clearButton.disable();
  this.saveButton.disable();
}

TestLogController.prototype.promptToClearLog = function promptToClearLog(title)
{
  var controller = this;
  var dialog = Frontend.dialog;
  dialog.toggleBadge(false);
  dialog.setHeader(title);
  dialog.toggleHeader(true);
  dialog.setContent(translate('MSG_CLEAR_LOG_CONFIRMATION'));
  dialog.toggleContent(true);
  dialog.clearButtons();
  dialog.addButton(translate('MSG_OK'), null, function ()
  {
    dialog.hide();
    controller.clearLog();
  });
  dialog.addButton(translate('MSG_CANCEL'), null, function ()
  {
    dialog.hide();
  });
  dialog.toggleButtons(true);
  dialog.show();
}

TestLogController.prototype.clearLog = function clearLog()
{
  this.clearRequest.send();
}

TestLogController.prototype.appendSaveInfo = function appendSaveInfo(request)
{
  return false;
}

TestLogController.prototype.save = function save()
{
  var header = (translate('MSG_SAVE') + ' ' + translate('MSG_TEST_LOG'));
  if (CONFIG.IS_OFFLINE)
  {
    Frontend.saveDialog.openDialog(header, 'testlog', this);
  }
  else
  {
    var query = 
    {
      attachment : 1,
      filename   : 'testlog'
    }
    Frontend.clientSave(this.saveCommand, query, header);
  }
}