function TestPromptTextDialog(controller)
{
  this.controller = controller;
  this.element = newElement('div', {'class':'dialog testPrompt'});

  inherit(this, new ModalElement(this.element));

  this.promptID = '0-0';

  this.header = this.element.appendChild(newElement('div', {'class':'header'}));
  this.body = this.element.appendChild(newElement('div', {'class':'body'}));
  this.content = this.body.appendChild(newElement('div', {'class':'content'}));
  this.input = this.body.appendChild(newElement('input', {'type':'text', 'controller':this}));
  this.buttonBar = this.body.appendChild(newElement('div', {'class':'buttonBar'}));

  this.init();
}

TestPromptTextDialog.prototype.init = function init()
{
  this.input.onkeydown = function (event)
  {
    event = event || window.event;
    if (event.keyCode == 13)
    {
      this.controller.submitValue();
      if (event.stopPropagation)
        event.stopPropagation;
      else
        event.returnValue = false;
      return false;
    }
  }
  this.button = newElement('input', {'type':'button', 'value':translate('MSG_OK'), 'controller':this});
  this.button.onclick = function ()
  {
    this.controller.submitValue();
  }
  this.buttonBar.appendChild(this.button);
}

TestPromptTextDialog.prototype.setContent = function setContent(contentHTML)
{
  this.content.innerHTML = contentHTML;
}

TestPromptTextDialog.prototype.setHeader = function setHeader(headerHTML)
{
  this.header.innerHTML = headerHTML;
}

TestPromptTextDialog.prototype.submitValue = function submitValue()
{
  this.controller.replyToPrompt(this.promptID, this.input.value);
  this.hide();
}

TestPromptTextDialog.prototype.didShow = function didShow()
{
  this.input.focus();
}

TestPromptTextDialog.prototype.willHide = function didHide()
{
  this.input.value = '';
  this.input.blur();
  this.button.blur();
}
