<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  ini_set( "display_errors", 1 );
  ini_set( "error_reporting", E_ALL );
  
  include_once '../includes/globals.php';
  include_once '../includes/aibridge.class.php';
  include_once '../includes/rosetta.class.php';
  
  
  $result = AIBridge::getProcessResult($_GET['processID']);

  $xml = new XMLDocument($result);
  $xpath = xpath_new_context($xml->document_element());

  $diagOutput = @xpath_eval($xpath, '/diagOutput');
  if (count($diagOutput->nodeset) > 0)
  {
    $diagOutput = $diagOutput->nodeset[0];
    $numberOfFailures = $diagOutput->get_attribute('testsFailed');
    $numberOfWarnings = $diagOutput->get_attribute('testsPassedWithWarnings');
  }
  else
  {
    $numberOfFailures = 0;
    $numberOfWarnings = 0;
  }

  $stateEnum["passed"]             = 0;
  $stateEnum["passedWithWarnings"] = 1;
  $stateEnum["failed"]             = 2;
  
  $actions = array();
  $resultOutput = array('<div id="diagnoseResult">');
  $diagnosisResults = @xpath_eval($xpath, '/diagOutput/diagnosisResult');
  foreach ($diagnosisResults->nodeset as $diagnosisResult)
  {
    // Need to get the state of all nested results to determine the state of the parent result.
    // If the nested result's state is greater than the parent result's state (according to $stateEnum)
    // then assign the parent's state to be equal to that.
    $state = getResultState( $diagnosisResult );
    $nestedResults = $diagnosisResult->get_elements_by_tagname("diagnosisResult");
    foreach ($nestedResults as $nestedResult)
    {
      $nestedState = getResultState( $nestedResult );
      if ( $stateEnum[$nestedState] > $stateEnum[$state] )
        $state = $nestedState; 
    }

    // Use the state as the class name for visible components to be either shown or hidden
    // depending on the user's selection ( e.g. "all", "errorsAndWarnings", or "errorsOnly" )
    $caption = $diagnosisResult->get_attribute('caption');
    $resultOutput[] = ('<h2 class="' . $state . '">' . $caption . '</h2>');
    if (count($nestedResults) > 0)
    {
      foreach ($nestedResults as $nestedResult)
      {
        $state = getResultState( $nestedResult );
        $caption = $nestedResult->get_attribute('caption');
        $resultOutput[] = ('<h3 class="' . $state . '">' . $caption . '</h3>');
        parseLeaf($nestedResult, $resultOutput);
      }
    }
    else
    {
      parseLeaf($diagnosisResult, $resultOutput);
    }
  }
  $output = array();
  appendViewHeader($output);
  $output[] = '<script type="text/javascript" src="../js/lib.js"></script>';
  $output[] = '<script type="text/javascript" src="js/diagnoseResult.js"></script>';
  $output[] = '<script type="text/javascript">';
  $output[] = ('DEVICE_ACTIONS = ' . Rosetta::arrayToJSON($actions) . ";\n");
  $DIAGNOSE_STATUS = array();
  $DIAGNOSE_STATUS["failureCount"] = $numberOfFailures;
  $DIAGNOSE_STATUS["warningCount"] = $numberOfWarnings;
  $output[] = ('DIAGNOSE_STATUS = ' . Rosetta::arrayToJSON($DIAGNOSE_STATUS) . ";\n");
  $output[] = '</script>';
  $output[] = '</head>';
  $output[] = ('<body onload="init(' . ((DEBUG_MODE === true) ? 'true' : 'false') . ');">');

  // Add drop-down select box to choose which results to display.
  $output[] = '<select id="diagnoseResultViewSelectDropDown" size="1">';
  $output[] = ('  <option value="all" selected="selected">' . translate('MSG_SHOW_ALL_RESULTS') . '</option>');
  $output[] = ('  <option value="errorsAndWarnings">' . translate('MSG_SHOW_ERRORS_AND_WARNINGS') . '</option>');
  $output[] = ('  <option value="errorsOnly">' . translate('MSG_SHOW_ERRORS_ONLY') . '</option>');
  $output[] = '</select>';

  $output[] = implode('', $resultOutput);
  appendViewFooter($output);
  echo implode('', $output);

  function getResultState( $diagnosisResult )
  {
    $errors = $diagnosisResult->get_elements_by_tagname( 'error' );
    $warnings =  $diagnosisResult->get_elements_by_tagname( 'warning' );
    $resultState = 'passed';
    if ( count( $errors ) > 0 )
      $resultState = 'failed';
    else if ( count( $warnings ) > 0 )
      $resultState = 'passedWithWarnings';
    return $resultState;
  }
  
  function parseLeaf(&$result, &$resultOutput)
  {
    $component = $result->get_attribute('component');
    $state = getResultState( $result );
    $timestamp = $result->get_attribute('time');
    $resultOutput[] = '<div class="' . $state . '">';
    if ($timestamp != "")
      $resultOutput[] = ('<label class="timestamp">' . $timestamp . '</label>');
    $resultOutput[] = '<p class="result">';
    if ($state == 'passed')
    {
      $resultOutput[] = '<img class="icon" src="../images/status_passed.gif" />';
      $resultOutput[] = translate('MSG_PASSED');
    }
    else if ($state == 'passedWithWarnings')
    {
      $resultOutput[] = '<img class="icon" src="../images/status_warning.gif" />';
      $resultOutput[] = translate('MSG_PASSED_WITH_WARNINGS');
    }
    else if ($state == 'failed')
    {
      $resultOutput[] = '<img class="icon" src="../images/status_failed.gif" />';
      $resultOutput[] = translate('MSG_FAILED');
    }
    else
    {
      $resultOutput[] = '<img class="icon" src="../images/status_unknown.gif" />';
      $resultOutput[] = translate('MSG_UNKNOWN');
    }
    $warnings = $result->get_elements_by_tagname('warning');
    $errors = $result->get_elements_by_tagname('error');
    if (count($warnings) > 0 || count($errors) > 0)
    {
      $resultOutput[] = '<table class="errorsAndWarnings">';
      foreach ($errors as $error)
      {
        $caption = $error->get_attribute('caption');
        $code = $error->get_attribute('code');
        if ($code == "")
          $code = $error->get_attribute('errorCode');
        $resultOutput[] = '<tr class="error">';
        $resultOutput[] = ('<th>' . translate('MSG_ERROR') . ':</th>');
        if ($code != "")
        {
          $resultOutput[] = ('<td>' . $code . ':</td>');
          $resultOutput[] = ('<td>' . $caption . '</td>');
        }
        else
        {
          $resultOutput[] = ('<td colspan="2">' . $caption . '</td>');
        }
        $resultOutput[] = '</tr>';
      }
      foreach ($warnings as $warning)
      {
        $caption = $warning->get_attribute('caption');
        $resultOutput[] = '<tr class="warning">';
        $resultOutput[] = ('<th>' . translate('MSG_WARNING') . ':</th>');
        $resultOutput[] = ('<td colspan="2">' . $caption . '</td>');
        $resultOutput[] = '</tr>';
      }
      $resultOutput[] = '</table>';
    }
    $resultOutput[] = '</p>';
    $infos = $result->get_elements_by_tagname('info');
    foreach ($infos as $info)
    {
      $infoCaption = $info->get_attribute('caption');
      $infoContent = $info->get_content();
      $resultOutput[] = '<p class="infoCaption">';
      $resultOutput[] = '<img class="icon" src="../images/status_unknown.gif" />';
      $resultOutput[] = $infoCaption . " " . $infoContent;
      $resultOutput[] = '</p>';
    }
    $files = $result->get_elements_by_tagname('formattedTextFile');
    foreach ($files as $file)
    {
      $filepath = (DIAGS_DIRECTORY . LANG . '/' . $file->get_attribute('filename'));
      if (file_exists($filepath))
        $resultOutput[] = ('<div class="formattedText">' . file_get_contents($filepath) . '</div>');
      else
        $resultOutput[] = ('<div class="formattedText">' . $filepath . '</div>');
    }
    reset($infos);
    global $actions;
    $deviceActions = $result->get_elements_by_tagname('deviceAction');
    foreach ($deviceActions as $action)
    {
      $actionArray = array();
      $actionCaption = $action->get_attribute('caption');
      $actionArray['caption'] = $actionCaption;
      $actionArray['component'] = $action->get_attribute('component');
      $actionArray['device'] = $action->get_attribute('device');
      $actionArray['subDevice'] = $action->get_attribute('subDevice');
      $actionArray['tcLoadFilename'] = ($component . '.dat');
      $actionArray['call'] = extractActionCall($action);
      $actions[] = $actionArray;
      $actionID = (count($actions) - 1);
      $resultOutput[] = ('<div class="subbutton" onclick="performAction(' . $actionID . ');">' . $actionCaption . '</div><br class="clear" />');
    }
    $resultOutput[] = '<hr>';
    $resultOutput[] = '</div>';
  }
  
  // UTILITY FUNCTIONS

  function extractActionCall($action)
  {
    $returnVal = '';
    $actionCalls = $action->child_nodes();
    foreach ($actionCalls as $call)
    {
      if ($call->node_type() == XML_ELEMENT_NODE)
        $returnVal = $call->tagname;
    }
    return $returnVal;
  }

?>
