<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/globals.php';
  
  // get all error xml files
  chdir(DIAGS_DIRECTORY);
  $errorFiles = glob('*.err.xml');
  $errorCodes = array();
  foreach($errorFiles as $filename)
  {
    $filepath = (DIAGS_DIRECTORY . $filename);
    // Try to make file into a XMLDocument
    $xml = @ new XMLDocument(file_get_contents($filepath));
    if ($xml)
    {
      $document = $xml->document_element();
    }
    else
    {
      exit('ERROR - ' . $filepath . ': invalid xml');
    }

    $errorTranslationArray = getErrorCodeTranslationArray($filepath);

    $xpath = xpath_new_context($document);
    $devices = @ xpath_eval($xpath, '/device');
    foreach($devices->nodeset as $device)
    {
      $deviceName = $device->get_attribute('caption');
      $xpath = xpath_new_context($device);
      $tests = @ xpath_eval($xpath, '/test');
      foreach($tests->nodeset as $test)
      {
        $testName = $test->get_attribute('caption');
        $xpath = xpath_new_context($test);
        $errors = @ xpath_eval($xpath, '/error');
        foreach($errors->nodeset as $error)
        {
          $errorArray = array();
          $errorArray['device'] = $deviceName;
          $errorArray['test'] = $testName;
          $errorArray['code'] = $error->get_attribute('code');;
          $messageName = $error->get_attribute('message');
          $repairName = $error->get_attribute('repair');
          if ($filepath == 'sdl.err.xml')
            $messageValue = translate('MSG_NOT_APPLICABLE');
          else
            $messageValue = '';//translate('MSG_UNDEFINED');
          if (isset($errorTranslationArray[$messageName]))
          {
            $messageValue = $errorTranslationArray[$messageName];
          }
          else
          {
            $xpath = xpath_new_context($document);
            $messageElements = @ xpath_eval($xpath, ('/message[@name="' . $messageName . '"]'));
            if (count($messageElements->nodeset) > 0)
              $messageValue = $messageElements->nodeset[0]->get_content(); // if we found message elements, we only look at the first one
          }
          if (isset($errorTranslationArray[$repairName]))
          {
            $repairValue = $errorTranslationArray[$repairName];
          }
          else
          {
            $repairElements = @ xpath_eval($xpath, ('/repair[@name="' . $repairName . '"]'));
            if (count($repairElements->nodeset) > 0)
              $repairValue = $repairElements->nodeset[0]->get_content();
            else
              $repairValue = '';
          }
          $errorArray['message'] = $messageValue;
          $errorArray['repair'] = $repairValue;
          $errorCodes[$errorArray['code']] = $errorArray;
        }
      }
    }
  }
  ksort($errorCodes, SORT_STRING); // sort the array by key

  function getErrorCodeTranslationArray($filepath, $forceErrFile=false)
  {
    global $document;
    $target = basename($filepath, '.err.xml');
    $translationFile = sprintf('%s.%s.xml', $target, LANG);
    $translationFilepath = realpath($translationFile);
    $translationArray = array();
    
    if ($translationFilepath === false || $forceErrFile === true)
    {
      $xpath = xpath_new_context($document);
      $repairs = @ xpath_eval($xpath, '/repair');
      $messages = @ xpath_eval($xpath, '/message');
      foreach ($repairs->nodeset as $repair)
        $translationArray[$repair->get_attribute('name')] = $repair->get_content();
      foreach ($messages->nodeset as $message)
        $translationArray[$message->get_attribute('name')] = $message->get_content();
    }
    else
    {
      $translationXML = @ new XMLDocument(file_get_contents($translationFilepath));
      if ($translationXML)
        $translationDocument = $translationXML->document_element();
      else
        return getErrorCodeTranslationArray($filepath, true);
      $xpath = xpath_new_context($translationDocument);
      $strings = xpath_eval($xpath, '/string');
      foreach ($strings->nodeset as $string)
      {
        $xpath = xpath_new_context($string);
        $id = $string->get_attribute('id');
        $values = @ xpath_eval($xpath, '/value');
        if (count($values->nodeset) > 0)
        {
          $value = $values->nodeset[0]->get_content();
        }
        else
        {
          $keys = @ xpath_eval($xpath, '/key');
          if (count($keys->nodeset) > 0)
            $value = $keys->nodeset[0]->get_content();
        }
        if (isset($value))
          $translationArray[$id] = $value;
      }
    }
    return $translationArray;
  }
  
  outputViewHeader();
  echo '<script type="text/javascript" src="../js/lib.js"></script>';
  echo '<script type="text/javascript" src="js/errorCodes.js"></script>';
  echo '</head>';
  echo ('<body onload="init(' . ((DEBUG_MODE === true) ? 'true' : 'false') . ');">');
  echo '<table id="errorCodes">';
  
  if (count($errorCodes) <= 0)
  {
    echo '<tr class="message">';
    echo ('<td>' . translate('MSG_NO') . ' ' . translate('MSG_ERROR_CODES') . '</td>');
    echo '</tr>';
  }
  else
  {
    echo '<thead>';
    echo '<tr>';
    echo ('<th class="code">' . translate('MSG_CODE') . '</th>');
    echo ('<th class="device">' . translate('MSG_DEVICE') . ', ' . translate('MSG_TEST') . '</th>');
    echo ('<th class="message">' . translate('MSG_MESSAGE') . '</th>');
    echo ('<th class="repair">' . translate('MSG_REPAIR') . '</th>');
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';
    foreach ($errorCodes as $error)
    {
      echo ('<tr id="code' . $error['code'] . '">');
      echo ('<td class="code">' . $error['code'] . '</td>');
      echo ('<td class="device">' . $error['device'] . ',<br>' . $error['test'] . '</td>');
      echo ('<td class="message">' . $error['message'] . '</td>');
      echo ('<td class="repair">' . $error['repair'] . '</td>');
      echo '</tr>';
    }
    echo '</tbody>';
  }
  
  echo '</table>';
  outputViewFooter();
  //*/
?>
