<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/globals.php';
  include_once '../includes/aibridge.class.php';

  if (isset($_GET['sortField']))
    $sortField = $_GET['sortField'];
  else
    $sortField = '';

  $imlLog = AIBridge::getImlLog($sortField);

  $xml = new XMLDocument($imlLog);
  $xpath = xpath_new_context($xml->document_element());
  $structures = @ xpath_eval($xpath, '/structure');

  outputViewHeader($output);
  echo '<script type="text/javascript" src="../js/lib.js"></script>';
  echo '<script type="text/javascript" src="js/imlLog.js"></script>';
  echo '</head>';
  echo ('<body onload="init(' . ((DEBUG_MODE === true) ? 'true' : 'false') . ');">');
  echo '<table class="log" id="imlLog">';
  
  if (count($structures->nodeset) <= 0)
  {
    $root = $xml->document_element();
    if (strstr($root->get_attribute('caption'), translate('MSG_NOT_AVAILABLE')) === FALSE)
    {
      echo '<tr class="message">';
      echo ('<td>' . translate('MSG_INTEGRATED_MANAGEMENT_LOG') . ' ' . translate('MSG_IS_EMPTY') . '</td>');
      echo '</tr>';
    }
    else
    {
      echo '<tr class="message">';
      echo ('<td>' . translate('MSG_INTEGRATED_MANAGEMENT_LOG') . ': ' . translate('MSG_NOT_AVAILABLE') . '</td>');
      echo '</tr>';
    }
  }
  else
  {
    echo '<thead>';
    echo '<tr>';
    echo '<td class="checkbox"></td>';
    echo ('<th class="severity">' . translate('MSG_SEVERITY') . '</th>');
    echo ('<th class="class">' . translate('MSG_CLASS') . '</th>');
    echo ('<th class="lastUpdate">' . translate('MSG_LAST_UPDATE') . '</th>');
    echo ('<th class="initialUpdate">' . translate('MSG_INITIAL_UPDATE') . '</th>');
    echo ('<th class="count">' . translate('MSG_COUNT') . '</th>');
    echo ('<th class="description">' . translate('MSG_DESCRIPTION') . '</th>');
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';
    foreach ($structures->nodeset as $structure)
    {
      $structureXpath = xpath_new_context($structure);
      $properties = @ xpath_eval($structureXpath, '/property');

      $class = $structure->get_attribute('class');
      $code = $structure->get_attribute('code');
      $index = $structure->get_attribute('eventNumber');

      $description = $code;

      $individualRows = array('Severity', 'Count', 'lastUpdate', 'initialUpdate');
      $rowParameters = array();
      foreach ($properties->nodeset as $property)
      {
        $name = $property->get_attribute('name');
        $value = $property->get_attribute('value');
        if (in_array($name, $individualRows))
        {
          $rowParameters[$name] = $value;
        }
        else
        {
          $caption = $property->get_attribute("caption");
          $description .= (' - ' . $caption . ': ' . $value);
        }
      }
      
      echo '<tr>';
      echo ('<td class="checkbox"><input type="checkbox" value="' . $index . '" /></td>');
      echo ('<td class="severity">' . $rowParameters['Severity'] . '</td>');
      echo ('<td class="class">' . $class . '</td>');
      echo ('<td class="lastUpdate">' . $rowParameters['lastUpdate'] . '</td>');
      echo ('<td class="initialUpdate">' . $rowParameters['initialUpdate'] . '</td>');
      echo ('<td class="count">' . $rowParameters['Count'] . '</td>');
      echo ('<td class="description">' . $description . '</td>');
      echo '</tr>';
    }
    echo '</tbody>';
  }
  
  echo '</table>';
  outputViewFooter();
  //*/
?>
