/*
 * (c) Copyright Hewlett-Packard Company 2007.  All rights Reserved.
 * Reproduction, adaptation, or translation without prior written
 * permission is prohibited except as allowed under the copyright
 * permission.
 */

/**
 * Function that verify if browser is Internet Explorer 
 */
function isInternetExplorer() {
	var browser = navigator.appName;
	if (browser == "Microsoft Internet Explorer") {
		return true;
	}
	else {
		return false;
	}
};

/**
 * Function that returns a reasonably cross-browser reference to the 
 * originating object of the given event.
 * 
 * @param	{Object}	e	Event.
 */
function getEventOriginator(e) {
	return (document.all) ?  event.srcElement : e.target;
}

/**
 * Array convenience method to clear membership.
 */
Array.prototype.clear = function() {
	this.length = 0;
};

/**
 * Array convenience method to remove element.
 * 
 * @param	{Array}		element	Array.
 * @return	{Boolean}	If element was removed returns true, else returns false.
 */
Array.prototype.remove = function(element) {
	var result = false;
	var array = [];
	for (var i = 0; i < this.length; i++) {
		if (this[i] == element) {
			result = true;
		}
		else {
			array.push(this[i]);
		}
	}
	this.clear();
	for (var i = 0; i < array.length; i++) {
		this.push(array[i]);
	}
	array = null;
	return result;
}; 

/**
 * Array convenience method to search object inside it.
 * 
 * @param	{Object}	searchElement	Object that will be searched in array.
 * @param	{Number}	fromIndex		Index to start search.
 * @return	{Number}	The first index number at witch the specified 
 * 						element can be found in the array. Returns -1 if 
 * 						element is not present.
 */
Array.prototype.search = function(searchElement, fromIndex) {
	if (fromIndex == "undefined") {
		fromIndex = 0;
	}
	var result = -1;
	for (var i = fromIndex; i < this.length; i++) {
		if (this[i] == searchElement) {
			result = i;
		}
	}
	return result;
};

/**
 * String convenience method to remove spaces before and after.
 * 
 * @return	{String}	String without spaces before and after.
 */
String.prototype.trim = function() {
	return this.replace(/^\s+|\s+$/, "");
};

/**
 * Format date according mask. 
 * 
 * @param	{String}	mask	Mask.
 * @return	{String}	Date formated according mask.
 */
Date.prototype.format = function(mask) {
	var d = this; // Needed for the replace() closure
	
	var zeroLeft = function (value, length) {
		if (!length) {
			length = 2;
		}
		value = String(value);
		for (var i = 0, zeros = ""; i < (length - value.length); i++) {
			zeros += "0";
		}
		return zeros + value;
	};
	
	return mask.replace(/"[^"]*"|'[^']*'|\b(?:d{1,4}|M{1,4}|yy(?:yy)?|([hHmstT])\1?|[lLZ])\b/g, function($0) {
		switch($0) {
			case "d":		return d.getDate();
			case "dd":		return zeroLeft(d.getDate());
			case "ddd":		return WEEKDAYS_MEDIUM[d.getDay()];
			case "dddd":	return WEEKDAYS_LONG[d.getDay()];
			case "M":		return d.getMonth() + 1;
			case "MM":		return zeroLeft(d.getMonth() + 1);
			case "MMM":		return MONTHS_SHORT[d.getMonth()];
			case "MMMM":	return MONTHS_LONG[d.getMonth()];
			case "yy":		return String(d.getFullYear()).substr(2);
			case "yyyy":	return d.getFullYear();
			case "k":		return d.getHours() % 12 || 12;
			case "kk":		return zeroLeft(d.getHours() % 12 || 12);
			case "H":		return d.getHours();
			case "HH":		return zeroLeft(d.getHours());
			case "m":		return d.getMinutes();
			case "mm":		return zeroLeft(d.getMinutes());
			case "s":		return d.getSeconds();
			case "ss":		return zeroLeft(d.getSeconds());
			case "S":		return zeroLeft(d.getMilliseconds(), 3);
			case "SS":		var m = d.getMilliseconds();
							if (m > 99) {
								m = Math.round(m / 10);
							}
							return zeroLeft(m);
			case "a":		return d.getHours() < 12 ? "AM" : "PM";
			case "Z":		return d.toUTCString().match(/[A-Z]+$/); // Return quoted strings with the surrounding quotes removed
			default:		return $0.substr(1, $0.length - 2); } }
	);
};

    function colorize_tr_1() {
    	this.style.backgroundColor='#99ccff';
	}

    function colorize_tr_2() {
    	this.style.backgroundColor='transparent';
	}

    function colorize_tr_3() {
    	this.style.backgroundColor='#EEEEEE';
	}
