﻿package hpSMHSetup::L10N;

use Locale::Maketext;
use base qw(Locale::Maketext);

%Lexicon = (
   '_AUTO' => 1,
    
   '_WELCOME' => "-------------------------------------------------------------------------------
   Welcome to the Setup Wizard for the HP System Management HomePage 6.2.0.12

   The Setup Wizard will install the HP System Management HomePage 6.2.0.12 on
   your computer.

   On the following screens, you will configure security and access parameters
   for the HP System Management HomePage and related HP web-based management
   tools (e.g. Insight Management Agents, Version Control Agents, Diagnostics).

   HP System Management HomePage 6.2.0.12
   Hewlett-Packard Company
   www.hp.com\n\n",
   
   '_OS_SYSTEM_GROUPS' => "-------------------------------------------------------------------------------
   Operating System Groups

   Select 'Add' to add an Operating System (OS) Group Name to one of the OS
   Group Lists (up to 5 entries per group) or 'Delete' to delete a name from
   a list. When you have completed your additions and deletions,
   select 'n' below.\n\n",
   
   '_MODIFY_GROUP_LISTS' => "
   Modify Group Lists
   ------------------
   1 - Add Groups
   2 - Delete Groups
      
   n - next\n\n",
   
   '_GROUP_TYPES' => "
   1 - Administrator
   2 - Operator
   3 - User
   
   n - next\n\n",
   
   '_ENTER_GROUP_NAME_TO_DELETE' => "
   Enter the number of the $name Group to delete,
   or ENTER when you are finished: ",

   '_INVALID_GROUP_NUMBER' => "
   Invalid Group number.\n\n ",
   
   '_ANONYMOUS_ACCESS' => "
   Anonymous Access: Allow Anonymous users access to unsecured pages.
   Please note that this includes local users.\n\n",
   
   '_LOCAL_ACCESS' => "
   Local Access: Setup the System Management HomePage to automatically
   configure local IP addresses as part of the selected group. This means
   that any user with access to the local console will be granted full
   accesss if Administrator is selected, without being challenged for a
   username and password.\n\n",
   
   '_SET_ANONYMOUS_LOCAL_ACCESS' => "
   Set Anonymous Access:
   -------------------------
   1 - Anonymous Access True
   2 - Anonymous Access False

   Set Local Access
   ------------------------------
   3 - Disable Local Access
   4 - Local Access Anonymous     - Restricted access to unsecure pages
   5 - Local Access Administrator - Grant full access to secure and
                                        unsecured pages
       
   p - previous
   n - next\n\n",
   
   '_ACCESS_SETTINGS' => "
   Anonymous Access         [_1]
   Local Access             [_2]",
   
   '_SELECT_TRUST_MODE' => "
   Select a device trust mode below. This will determine how HTTP requests
   from Insight Manager 7 or Systems Insight Manager hosts are handled.

   NOTE:  HP strongly recommends using Trust by Certificate.

   Trust by Certificate: Setup the System Management HomePage to only accept
   Secure Task Execution requests and Single Login requests that have been
   signed by an Insight Manager 7 or Systems Insight Manager host with a
   Trusted Certificate.

   Trust by Name: Setup the System Management HomePage to accept Secure Task
   Execution requests and Single Login requests from specific Insight Manager 7
   or Systems Insight Manager hosts.

   Trust All: Setup the System Management HomePage to accept Secure Task
   Execution requests and Single Login requests from any server.\n\n",
   
   '_TRUST_MODES' => "
   1 - Trust by Certificate
   2 - Trust by Name
   3 - Trust All\n\n",
   
   '_ENTER_SELECTION' => "
   p - previous
   n - next

   Please enter your selection: ",
   
   '_SETUP_STE_SSO_REQUESTS' => "
   Setup the System Management HomePage to accept Secure Task Execution
   and Single Login requests from Systems Insight Manager.\n\n",
   
   '_MODIFY_SIM_SERVER_LIST' => "
   Modify Systems Insight Manager Server List
   ------------------------------------------
   1 - Add    Systems Insight Manager
   2 - Delete Systems Insight Manager
   
   p - previous
   n - next\n\n",
   
   '_TRUSTED_CERTIFICATES_INSTRUCTIONS' => "
   Select 'Add File' to add a Certificate File to the Trusted Certificates List,
   'Import' to import a certificate from a particular server, or 'Delete' to
   delete a file from the list. When you have completed your additions and
   deletions, select 'next' below.\n\n",
   
   '_TRUSTED_CERTIFICATES_OPTIONS_IMPORT_DISABLED' => "
   1 - Add File
   2 - Import (Option disabled)
   3 - Delete

   n - next\n\n",
   
   '_TRUSTED_CERTIFICATES_OPTIONS' => "
   1 - Add File
   2 - Import
   3 - Delete

   n - next\n\n",
   
   '_NO_TRUSTED_CERTIFICATES_WARNING' => "
   If you do not specify any trusted certificates, Insight Manager 7 or Systems
   Insight Manager will not be able to access the HP web-based agents on this
   device.
   
   Do you want to proceed without adding any trusted certificates?\n\n",
   
   '_YES_NO_OPTION' => "
   1 - Yes
   2 - No\n\n",
   
   '_TRUSTED_CERTIFICATE_FILE_PATH' => "
   Enter the file path of the Trusted Certificate to add to the list,
   or press ENTER when you are finished:

   File: ",
   
   '_TRUSTED_CERTIFICATE_FILE_NOT_FOUND' => "
   The file '[_1]' does not exist.

   Please try again...\n\n",
   
  '_IMPORT_TRUSTED_CERTIFICATE_DISABLED' => "
  *** Importing a remote Trusted Certificates is disabled. The 'cURL'
  *** or 'wget' utility is not installed on the system.  To enable
  *** Importing, install the curl-7.8 or wget-1.8.2 RPM package from
  *** the Linux distribution CD/DVD media.
  ***
  *** Trusted Certificates can be imported by administrators from the
  *** System Management HomePage.  Select the 'Settings' tab and choose
  *** the 'Security' option.  Under 'Security' option,  choose 'Trusted
  *** Management Servers' option, and use the 'Add Certificate from
  *** Server' option to import certificates.\n",
  
  '_ENTER_IMPORT_SERVER_NAME' => "
   Enter the name of the server whose certificate you would like to import,
   or press ENTER when you are finished:

   Server Name: ",
   
   '_RETRIEVING_CERTIFICATE' => "
   Retrieving certificate.

   Please wait...\n\n",
   
   '_REVIEW_CERTIFICATE_INFO' => "
   Review the certificate information below, and select 'Accept' to add the
   certificate to the Trusted Certificates List or select 'Reject' to return
   to the Trusted certificates information without adding the certificate.\n\n",
   
   '_ACCEPT_REJECT_OPTION' => "
   1 - Accept
   2 - Reject

   Please enter your selection: ",
   
   '_ENTER_CERTIFICATE_TO_DELETE' => "
   Enter the number of the Certificate File to delete,
   or ENTER when you are finished: ",
   
   '_IP_BINDING_INSTRUCTIONS' => "
   Select IP Binding to ON if you would like to bind to IP Addresses
   that match a specific Subnet and Mask.

   If IP Binding is enabled and no Subnet IP Address/Netmask pairs are
   configured then the System Management HomePage will only be available
   on the localhost.\n\n",
   
   '_ON_OFF_OPTION' => "
   1 - ON
   2 - OFF

   p - previous
   n - next\n\n",
   
   '_IP_BINDING_ADD_DELETE_INSTRUCTIONS' => "
   Select up to 5 IP Address and Mask using 'Add' or 'Delete' to add or
   delete a Subnet/Mask pair from the list. When you have completed your
   additions and deletions, select n for next below.\n\n",
   
   '_ADD_DELETE_OPTION' => "
   1 - Add
   2 - Delete

   p - previous
   n - next\n\n",
   
   '_ENTER_NETMASK' => "
   Enter the netmask for the subnet IP Address,
   or ENTER when you are finished.

   Netmask: ",
   
   '_ENTER_IP_ADDRESS' => "
   Enter the subnet IP Address to add to the IP Binding List,
   or ENTER when you are finished.

   IP Address: ",
   
   '_DELETE_IP_ADDRESS' => "
   Enter the number of the subnet to delete,
   or ENTER when you are finished: ",
   
   '_IP_RESTRICTED_LOGIN_INSTRUCTIONS' => "
   The System Management HomePage can restrict login access based on the
   IP address of the machine from which the login is attempted.

   If an IP address is explicitly excluded, it will be excluded even if it
   is also explicitly included. If there are any IP addresses in the inclusion
   list, then only those IP addresses will be allowed login access. If there
   are no IP addresses in the inclusion list, then login access will be allowed
   to any IP addresses not in the exclusion list.\n\n",
   
   '_IP_RESTRICTED_LOGIN_SELECT' => "
   Please select the number below to include and/or exclude specific IP
   Addresses or IP Address Ranges.\n\n",
   
   '_IP_RESTRICTED_LOGIN_OPTION' => "
   1 - IP Restricted Logins ON
   2 - IP Restricted Logins OFF

   p - previous
   n - next\n\n",
   
   '_LOGIN_RESTRICTION_INCLUDE_EXCLUDE' => "
   1 - Include Login Restriction IP Addresses
   2 - Exclude Login Restriction IP Addresses

   p - previous
   n - next\n\n",
   
   '_IP_ADDRESS_INCLUDE_INSTRUCTIONS' => "
   IP Addresses can be explicitly included in gaining login access. If there
   are any IP Addresses in the Inclusion List, then only those IP Addresses
   will be allowed login access. If there are no IP Addresses in the Inclusion
   List, then login access will be allowed to any IP Address not in the
   Exclusion List (next screen).

   IP Address Ranges should be listed with the lower end of the range followed
   by a hyphen, followed by the upper end of the range.

   Note:  All defined IP ranges will include the upper and lower address
          entries.

   Select 'Add' to add an IP Address or IP Address Range to the IP Address
   Inclusion List or 'Delete' to delete an IP Address or IP Address Range
   from the list. When you have completed your additions and deletions,
   select 'next' below.\n\n",
   
   '_ADD_DELETE_NEXT_OPTION' => "
   1 - Add
   2 - Delete

   n - next\n\n",
   
   '_IP_ADDRES_EXCLUDE_INSTRUCTIONS' => "
   IP Addresses can be explicitly excluded in gaining login access. If an IP
   Address is explicitly excluded it will be excluded even if it is also
   explicitly included (previous screen).

   IP Address Ranges should be listed with the lower end of the range followed
   by a hyphen, followed by the upper end of the range.

   Note:  All defined IP ranges will include the upper and lower address
          entries.

   Select 'Add' to add an IP Address or IP Address Range to the IP Address
   Exclusion List or 'Delete' to delete an IP Address or IP Address Range
   from the list. When you have completed your additions and deletions,
   select 'next' below.

   Ensure that you do not exclude the IP Address of your system, because you
   will not be able to login to the System Management HomePage.\n\n",
   
   '_VALID_IP_ADDRESS_INSTRUCTIONS' => "
   Valid IP Address Ranges consist of either a single IP Address or an
   IP Address Range with the lower IP Address separated from the upper
   IP Address by a '-'.

   Sample Entry: 122.23.44.1-122.23.44.255;172.84.100.35;127.0.0.0-127.0.0.255
   
   Please enter your IP Address values or ENTER to continue\n\n   ",
   
   '_ENTER_IP_NUMBER_TO_DELETE' => "
   Enter the number of the $name to delete,
   or ENTER when you are finished: "
);

1;
