#!/bin/sh
########################################################
# Parser 
# The purpose of this script is to read an LDU generated
# configuration file, and take two actions.
# Action 1 - Determine if any Elm setup variables exist
#            and run hpwebsetup accordingly.
# Action 2 - Create an configuration file to be passed
#            into a silent InstallShield invocation.
# * Also creates a Cleansweep XML File
# Requires: bash, sed, awk, seq, & expr
# Assumes: Input was validated & security checked
#          prior to storing in the file.
########################################################
admgroup=""
oprgroup=""
usrgroup=""
semi=";"
admlogin="YES"
anonacc="NO"
#ifndef WIN32
autostartsmh="NO"
#endif
localacc="NO"
localtype="ANONYMOUS"
trustmode="TRUSTBYCERT"
certlst=""
xenamelst=""
ipbind="NO"
ipbindlst=""
iprestrct="NO"
iprestrctinc=""
iprestrctexc=""
overwrite="false"
#
fn=/usr/local/hp/hpsmh.cfg
smhxml=/opt/hp/hpsmh/conf/smhpd.xml
#
if [ -f "$fn" ]; then
 l_c=$(wc -l $fn | awk '{print $1}')
# echo "Line counter = $l_c"
 for rline in $(seq 0 $l_c)
 do
   read rline

   # Force the line to uppercase
   uline=$(echo $rline | tr '[:lower:]' '[:upper:]')

   ix=$(expr match "$uline" 'FORCE-OVERWRITE')
   # If match returns 15 then FORCE-OVERWRITE found
   if [ $ix = "15" ]; then
      # Extract the overwrite flag (YES|NO)?
      ans=${uline:`expr $ix+1`:3}
      if [[ $ans == "YES" ]]; then
         overwrite="true"
      else
         overwrite="false"
      fi
   fi 

   ix=$(expr match "$uline" 'ADMIN-GROUP')
   # If match returns 11 then ADMIN-GROUP found
   if [ $ix = "11" ]; then
      work=${rline:`expr $ix+1`:32}
      # Use sed to escape all single quotes
      if [[ $admgroup = "" ]]; then
         admgroup=$work
      else
         admgroup=$admgroup$semi$work
      fi
   fi 

   ix=$(expr match "$uline" 'OPERATOR-GROUP')
   # If match returns 14 then OPERATOR-GROUP found
   if [ $ix = "14" ]; then
      work=${rline:`expr $ix+1`:32}
      # Use sed to escape all single quotes
      if [[ $oprgroup = "" ]]; then
         oprgroup=$work
      else
         oprgroup=$oprgroup$semi$work
      fi
   fi 

   ix=$(expr match "$uline" 'USER-GROUP')
   # If match returns 10 then USER-GROUP found
   if [ $ix = "10" ]; then
      work=${rline:`expr $ix+1`:32}
      # Use sed to escape all single quotes
      if [[ $usrgroup = "" ]]; then
         usrgroup=$work
      else
         usrgroup=$usrgroup$semi$work
      fi
   fi 

   ix=$(expr match "$uline" 'ALLOW-DEFAULT-OS-ADMIN')
   # If match returns 22 then ALLOW-DEFAULT-OS-ADMIN found
   if [ $ix = "22" ]; then
      # Extract the overwrite flag (YES|NO)?
      ans=${uline:`expr $ix+1`:3}
      if [[ $ans == "NO" ]]; then
         admlogin="false"
      else
         admlogin="true"
      fi
   fi 

   ix=$(expr match "$uline" 'ANONYMOUS-ACCESS')
   # If match returns 16 then ANONYMOUS-ACCESS found
   if [ $ix = "16" ]; then
      # Extract the overwrite flag (YES|NO)?
      ans=${uline:`expr $ix+1`:3}
      if [[ $ans == "YES" ]]; then
         anonacc="true"
      else
         anonacc="false"
      fi
   fi 

#ifndef WIN32   
   ix=$(expr match "$uline" 'AUTOSTART-SMH')
   # If match returns 13 then AUTOSTART-SMH found
   if [ $ix = "13" ]; then
      # Extract the overwrite flag (YES|NO)?
      ans=${uline:`expr $ix+1`:3}
      if [[ $ans == "YES" ]]; then
         autostartsmh="true"
      else
         autostartsmh="false"
      fi
   fi
#endif

   ix=$(expr match "$uline" 'LOCALACCESS-ENABLED')
   # If match returns 19 then LOCALACCESS-ENABLED found
   if [ $ix = "19" ]; then
      # Extract the overwrite flag (YES|NO)?
      ans=${uline:`expr $ix+1`:3}
      if [[ $ans == "YES" ]]; then
         localacc="true"
      else
         localacc="false"
      fi
   fi 

   ix=$(expr match "$uline" 'LOCALACCESS-TYPE')
   # If match returns 16 then LOCALACCESS-TYPE found
   if [ $ix = "16" ]; then
      work=${rline:`expr $ix+1`:14}
      ans=${uline:`expr $ix+1`:14}
      if [[ $ans == "ADMINISTRATOR" ]]; then
         localtype=$work
      else
         localtype='Anonymous'
      fi
   fi 

   ix=$(expr match "$uline" 'TRUSTMODE')
   # If match returns 9 then TRUSTMODE found
   if [ $ix = "9" ]; then
      work=${rline:`expr $ix+1`:12}
      ans=${uline:`expr $ix+1`:12}
      if [[ $ans == "TRUSTBYALL" || $ans == "TRUSTBYNAME" ]]; then
         trustmode=$work
      else
         trustmode='TrustByCert'
      fi
   fi 

   ix=$(expr match "$uline" 'CERTLIST')
   # If match returns 8 then CERTLIST found
   if [ $ix = "8" ]; then
      work=${rline:`expr $ix+1`:1024}
      certlist=$work
   fi 

   ix=$(expr match "$uline" 'XENAMELIST')
   # If match returns 10 then XENAMELIST found
   if [ $ix = "10" ]; then
      work=${rline:`expr $ix+1`:1024}
      xenamelst=$work
   fi

   ix=$(expr match "$uline" 'IP-BINDING-LIST')
   # If match returns 15 then IP-BINDING-LIST found
   if [ $ix = "15" ]; then
      work=${rline:`expr $ix+1`:256}
      ipbindlst=$work
   fi

   ix=$(expr match "$uline" 'IP-BINDING')
   # If match returns 10 then IP-BINDING found
   if [ $ix = "10" ]; then
      ans=${uline:`expr $ix+1`:3}
      if [[ $ans != "LIS" ]]; then
         if [[ $ans == "YES" ]]; then
            ipbind="true"
         else
            ipbind="false"
         fi
      fi
   fi

   ix=$(expr match "$uline" 'IP-RESTRICTED-LOGINS')
   # If match returns 20 then IP-RESTRICTED-LOGINS found
   if [ $ix = "20" ]; then
      # Extract the overwrite flag (YES|NO)?
      ans=${uline:`expr $ix+1`:3}
      if [[ $ans == "YES" ]]; then
         iprestrct="true"
      else
         iprestrct="false"
      fi
   fi 

   ix=$(expr match "$uline" 'IP-RESTRICTED-INCLUDE')
   # If match returns 21 then IP-RESTRICTED-INCLUDE found
   if [ $ix = "21" ]; then
      work=${rline:`expr $ix+1`:1024}
      iprestrctinc=$work
   fi 

   ix=$(expr match "$uline" 'IP-RESTRICTED-EXCLUDE')
   # If match returns 21 then IP-RESTRICTED-EXCLUDE found
   if [ $ix = "21" ]; then
      work=${rline:`expr $ix+1`:1024}
      iprestrctexc=$work
   fi 
 done <$fn
 #
 # Logic for FORCE-OVERWRITE
 ## if the smhpd.xml file exists then
 if [ -f $smhxml ]; then
   ## if forced overwrite is NO then
   if [[ $overwrite == "false" ]]; then
     ## Make sure permissions are set properly...
     chmod 660 $smhxml
##     /bin/chown 79:79 $smhxml
     chown hpsmh:hpsmh $smhxml
     exit
   fi
 fi
 ## Otherwise continue.. (Make a new xml file!)
 #
 # Start with clean files
 # Removed capability to write XML File for now...
 #
 rm -rf "$smhxml"
 #
 #
 ## Fixup for missing defaults
 #
 if [ $admlogin = "YES" ]; then
    admlogin="true"
 fi
 if [ $admlogin = "" ]; then
    admlogin="true"
 fi
 if [ $anonacc = "NO" ]; then
    anonacc="false"
 fi
#ifndef WIN32
 if [ $autostartsmh= "NO" ]; then
    autostartsmh="false"
 fi
#endif
 if [ $localacc = "NO" ]; then
    localacc="false"
 fi
 if [ $ipbind = "NO" ]; then
   ipbind="false"
 fi
 if [ $iprestrct = "NO" ]; then
   iprestrct="false"
 fi
 #
 ## SMH XML File
 #
 echo '<?xml version="1.0" encoding="UTF-8"?>' >> "$smhxml"
 echo '<system-management-homepage>' >> "$smhxml"
 echo "  <admin-group>$admgroup</admin-group>" >> "$smhxml"
 echo "  <operator-group>$oprgroup</operator-group>" >> "$smhxml"
 echo "  <user-group>$usrgroup</user-group>" >> "$smhxml"
 echo "  <allow-default-os-admin>$admlogin</allow-default-os-admin>" >> "$smhxml"
 echo "  <anonymous-access>$anonacc</anonymous-access>" >> "$smhxml"   
#ifndef WIN32
 echo "  <autostart>$autostartsmh</autostart>" >> "$smhxml"
#endif
 echo "  <localaccess-enabled>$localacc</localaccess-enabled>" >> "$smhxml"
 echo "  <localaccess-type>$localtype</localaccess-type>" >> "$smhxml"
 echo "  <trustmode>$trustmode</trustmode>" >> "$smhxml"
 echo "  <xenamelist>$xenamelst</xenamelist>" >> "$smhxml"
 echo "  <ip-binding>$ipbind</ip-binding>" >> "$smhxml"
 echo "  <ip-binding-list>$ipbindlst</ip-binding-list>" >> "$smhxml"     
 echo "  <ip-restricted-logins>$iprestrct</ip-restricted-logins>" >> "$smhxml"  
 echo "  <ip-restricted-include>$iprestrctinc</ip-restricted-include>" >> "$smhxml"
 echo "  <ip-restricted-exclude>$iprestrctexc</ip-restricted-exclude>" >> "$smhxml"
 echo '</system-management-homepage>' >> "$smhxml"
 chmod 660 $smhxml
## /bin/chown 79:79 $smhxml
 chown hpsmh:hpsmh $smhxml
 #
 ## Certlist processing
 #
 #
   if [ ! -d /opt/hp/hpsmh/certs ]; then
     mkdir /opt/hp/hpsmh/certs
   fi  
   declare -a certarray 
   certarray=(`echo "$certlist" | awk 'BEGIN { FS = ";" } { for (i = 1; i <= NF; i = i + 1)  print $i }'`)
   for cfile in "${certarray[@]}"; do
     # echo $cfile
     if [ -f $cfile ]; then
        cp -vf $cfile /opt/hp/hpsmh/certs
        if [ $? -eq 0 ]; then
          echo "$cfile copied sucessfully!!!"
        fi
     else
       # Check for an IP Address in the certlist...
       if [ `echo $cfile | grep '[0-9]\{1,3\}[.][0-9]\{1,3\}[.][0-9]\{1,3\}[.][0-9]\{1,3\}'` ]; then
          # If it is an IP address strip the dots & create a unique filename out of it...
          basefile=`echo "sys$cfile" |  sed -e "s/\./d/g"`
       else
          basefile=`echo $cfile | awk 'BEGIN { FS = "." } { print $1 }'`
       fi
       certfile="/opt/hp/hpsmh/certs/$basefile.pem"
       # Check for Curl
       if [ -x /usr/bin/curl ]; then
         echo "Using cURL to obtain Certificate from $cfile..."
         `/usr/bin/curl http://$cfile:280/GetCertificate -o $certfile`
       else
         # Otherwise - Check for wget
         if [ -x /usr/bin/wget ]; then
           echo "Using WGet to obtain Certificate from $cfile..."
           certfile=`echo $cfile | awk 'BEGIN { FS = "." } { print $1 }'` 
           `/usr/bin/wget http://$cfile:280/GetCertificate -O $certfile`
         else
           echo "Missing cURL & wget utilities. Cannot tranfer Certificate from $cfile..."
           exit 
         fi
       fi
       certcheck=`grep '\-\-\-\-\-END CERTIFICATE\-\-\-\-\-' $certfile > /dev/null 2>&1`
       if [ $? = 0 ]; then
         echo "Certificate passed simple check!!!"
       else
         echo "Certificate from '$cfile' stored in '$certfle' is not complete or corrupted!!!"
         echo "Removing '$certfile'!!!"
         rm -vf $certfile 
       fi
     fi
   done
##   chown 79:79 /opt/hp/hpsmh/certs/* > /dev/null 2>&1
   chown hpsmh:hpsmh /opt/hp/hpsmh/certs/* > /dev/null 2>&1
   chmod 660 /opt/hp/hpsmh/certs/* > /dev/null 2>&1
else
  echo "The configuration file $fn does not exist!"
  echo "No action taken..."
fi
