<html>
<head>
<?php
    $languages = $_SERVER["HTTP_ACCEPT_LANGUAGE"];
    $languages_array = explode(";", $languages);
    $primary_languages = explode(",", $languages_array[0]);
    
    $primary_language = "en";
    for ($i=0; $i<count($primary_languages); $i++) {
        // by default use only the main language (eg: en-bt and en-us are both en)
        $primary_languages[$i] = substr($primary_languages[$i], 0, 2);
        // test if the language pack exists
        if (file_exists("lang/".$primary_languages[$i]."/log_messages.php")) {
            $primary_language = $primary_languages[$i];
            break;
        }
    }
    include_once("lang/".$primary_language."/log_messages.php");
    // output the character encoding (this means this file should be always included inside html header)
    if (!$ENCODING) {
        $ENCODING = "UTF-8";
    }
    echo '<meta http-equiv="content-type" content="text/html; charset='.$ENCODING.'" />';
?>
</head>
<body style='background-color: #EEEEEE;'>
<?php
$authlevel = apache_note("hpsmhauthlevel");

if($authlevel == 4) {
    $logtype = $_GET["log"];
    
    $allowedLogs = array("hpsmhlog", "hpsmholdlog", "elmlog", "errorlog");
   
    $logtype = $_GET["log"];
   
    if(!$logtype || !in_array($logtype, $allowedLogs))
        $logtype = "hpsmhlog";
   
    $logfile = apache_note($logtype);
   
    $logentries = count(@file($logfile));
    $logFp = @fopen($logfile, "r");
}

if($logFp) {
    $from = $_GET["from"];
    $to = $_GET["to"];
    
    $lines = array();
    
    if($from && $to) {
        $currentLine = $logentries+0;
        
    	while(!feof($logFp) && $currentLine >= $from) {
            $line = fgets($logFp);            
            
            if($currentLine <= $to)
                array_push($lines, $line);
                
            $currentLine--;
        }
    }
    
    fclose($logFp);
    
    echo("<pre>");
    
    $lines = array_reverse($lines);
    
    foreach ($lines as $line) {
    	$line = strip_tags($line);
        if($logtype == "hpsmhlog") {
			$line = preg_replace('/\s+/',' ', $line);
            $lineArray = explode(" ", trim($line));
            
            // a log entry must contain at least a severity level, a timestamp and
            // a message id
            if(count($lineArray) >= 3) {
                $severity = $lineArray[0];
                
                // output the localized date
                setlocale(LC_TIME, $localeName);
                $date = strftime("%c", $lineArray[1]);
                
                $message = $logMessages[$lineArray[2]];
                
                $args = array_slice($lineArray, 3);
                
                printf("%s  %s\n", $severityLevel[$severity], $date);
                
                $requiredArgs = substr_count($message, "%");
                $argCount = count($args);
                
                // in case there are less arguments than required, fill the
                // remaining arguments with "(null)"
                for($i = 0; $i < $requiredArgs - $argCount; $i++) {
                    array_push($args, "(null)");
                }
                
                vprintf($message, $args);
                
                print "\n\n";
            }
        }
        else {
            echo "$line\n";
        }
	}
    
    echo("</pre>");
}
?>
</body>
</html>
