<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-us" lang="en-us">
<head>
	<title>HP System Management Homepage</title>
	<meta http-equiv="expires" content="0" />
	<meta http-equiv="pragma" content="no-cache" />
	<meta name="description" content="System Management Homepage" />
	<link rel="stylesheet" type="text/css" href="css/common.css" media="screen, projection" />
	<!--[if lte IE 6]>
		<link rel="stylesheet" type="text/css" href="../css/common_ie.css" media="screen, projection" />
	<![endif]-->
	<script type="text/javascript" src="js/functions.js"></script>
	<script type="text/javascript" src="js/global.js"></script>
	<script type="text/javascript" src="js/buttonManager.js"></script>
	<script type="text/javascript" src="js/FormManager.js"></script>
	<script type="text/javascript" src="js/LayoutManager.js"></script>
    <?php include_once("lang.php"); ?>
    <script><?php include_once("message_strings.php"); ?></script>
	<script language="JavaScript" type="text/javascript" src="js/error_table.js"></script>
	<script language="JavaScript" type="text/javascript" src="js/ui.js"></script>       
	<script>
	//--- default values to be overwritten - avoids script errors if not obtained ---
	smhversion = smhcopyright = "";
	smhconfigauth = false;
  var port2301 = 1;
  autostart = 0;
  timeoutsmh = 30;
  var errno=-1;

	<?php
	  echo("//-------- getuiinfo ------------\n");
	  virtual('/proxy/smhui/getuiinfo?JS&smhversion&smhcopyright&smhconfigauth&theme_ui&custom_ui&systemname');
	  echo("//-------- GetSMHData ------------\n");
    virtual('/proxy/GetSMHData?JScript&autostart&timeoutsmh&port2301');
	  echo("//-------- chp.js ------------\n");
	  virtual('/chp.js');
	?>

	useCustomColor();
	onlyInCHP();
	ourButtonManager = new ButtonManager();


	function FillInData() 
	{
	    
	    if (port2301.toLowerCase == "true" || port2301 == "1")
	      document.forms.visibleform.elements.port2301.checked = true;
	    
            if (autostart.toLowerCase == "false" || autostart == "0"){
	      document.forms.visibleform.elements.autostart.checked = false;
              document.forms.visibleform.elements["timeoutsmh"].value = timeoutsmh;
              document.forms.visibleform.elements.timeoutsmh.disabled = true;
            }
            else {
      	      document.forms.visibleform.elements.autostart.checked = true;
              document.forms.visibleform.elements["timeoutsmh"].value = timeoutsmh;
              document.forms.visibleform.elements.timeoutsmh.disabled = false;
              document.forms.visibleform.elements.port2301.disabled = true;
            }
      	}

        function changeLocalForms() 
        {
            if (document.forms.visibleform.elements.autostart.checked) {
              document.forms.visibleform.elements.timeoutsmh.disabled = false;
            
              if (!document.forms.visibleform.elements.port2301.checked) {  
                document.forms.visibleform.elements.port2301.checked = true;
                document.forms.visibleform.elements.port2301.disabled = true;
            
	      } else {
                document.forms.visibleform.elements.port2301.disabled = true;
              }               
       	    }
            else {
                document.forms.visibleform.elements.timeoutsmh.disabled = true; 
                document.forms.visibleform.elements.port2301.disabled = false;
            }
        }
     
	function isInteger(s)
        {
            var i;
            s = s.toString();
            for (i = 0; i < s.length; i++)
            {
                var c = s.charAt(i);
                if (isNaN(c))
                {
                   return false;
                }
            }
            return true;
        }
	
	function ValidateIPMonitor()
	{
	    var answer;
	    if(!smhconfigauth) {
		    alert("<?php echo $LANG[PORT2301_ERROR1]; ?>");
    		return false;
	    }
	    else {
                 smh = document.forms.visibleform.elements["timeoutsmh"].value;
		 if( !isFinite(smh) || !isInteger(smh) ||  smh < 0 || smh > 60 || !smh )
                 {
                   alert("<?php echo $LANG[TIMEOUTS_ERROR4]; ?>");
                   return false;
                 }
            }
		document.forms.hiddenform.elements["port2301"].value = document.forms.visibleform.elements.port2301.checked ? "true" : "false";
		document.forms.hiddenform.elements["autostart"].value = document.forms.visibleform.elements.autostart.checked ? "true" : "false";
    		document.forms.hiddenform.elements["timeoutsmh"].value = document.forms.visibleform.elements["timeoutsmh"].value;
		if("undefined"!=typeof( parent.frames.CHPHeaderFrame )) {
		    parent.frames.CHPHeaderFrame.message_return_url="/port2301_autostart.php";
		    parent.frames.CHPHeaderFrame.message_return_name="Port 2301";
		    parent.frames.CHPHeaderFrame.message_return_path="settings::System Management Homepage::Security";
		}
		document.forms.hiddenform.submit();
	}

	// disable forms elements in case user dosen't have the proper access
	function checkAuth(form_name) {
		if (!smhconfigauth) {
			for (i=0; i<document.forms[form_name].elements.length;i++) {
				if ("undefined"!=typeof( document.forms[form_name].elements[i].disabled)) {
					document.forms[form_name].elements[i].disabled = true;
				}
	        }
	      ourButtonManager.disableButtonById('saveButton');
		}
	}

	function checkAuthForms() {
		checkAuth('visibleform');
	}
		
	</script>

</head>

<body onload="FillInData(); checkAuthForms();">
	<div id="loadingBox"></div>
	<div id="loadingContent">
		<div class="content">

		<script>
		writePageHeader();
		defineError();
		drawErrorBox();
		</script>

		<form name="visibleform" method="POST" action="/port2301_autostart.php" onsubmit="ValidateIPMonitor(); return false;">
			<table border="0" cellspacing="0" cellpadding="0" width="100%" style="padding: 0px; width: 100%; margin: 0px;">
			<tr>
			    <td width='60%' valign='top'>
					<fieldset style="margin: 0px;">
						<legend><?php echo $LANG[PORT2301_TITLE]; ?></legend>
						<div class="formLine">
							<label for="description"></label>
							<input type="checkbox" name="port2301" onClick='ourButtonManager.enableButtonById("saveButton");'> <?php echo $LANG[PORT2301_ENABLE]; ?>
						</div>
             					<div class="formLine">
					                <label for="description"></label>
					                <input type="checkbox" name="autostart" onClick='changeLocalForms();ourButtonManager.enableButtonById("saveButton");'>
                					<?php echo $LANG[AUTOSTART_ENABLE];?><br>
						</div>
						<div>
              						<label for="description"></label>
						        <center> <?php echo $LANG[AUTOSTART_SERVER_TIMEOUT];?> (<?php echo $LANG[TIMEOUTS_LABEL4];?>):
					                <input type="text" name="timeoutsmh" value="" size="10" onClick='ourButtonManager.enableButtonById("saveButton");'></center>
                					<br>
						</div>
					</fieldset>
			    </td>
			    <td width="10">&nbsp;</td>
				<td style="height: 100%;" valign="top" class="note">
					<h5><?php echo $LANG[NOTE]; ?></h5>
				    <ul>
				        <li><?php echo $LANG[PORT2301_NOTES_TEXT]; ?></li>
				    </ul>
		          	    <ul>
                                        <li><?php echo $LANG[AUTOSTART_NOTES_TEXT]; ?></li>
                                    </ul>
           <ul> 
              <li><?php echo $LANG[AUTOSTART_NOTES_TEXT1]; ?></li>
           </ul>
			    </td>
			</tr>
			</table>
			
			<div class="hr"></div>
				<div class="bWrapperUp bEmphasized"><div><div><input type="submit" id="saveButton" class="hpButton" value="<?php echo $LANG[BUTTON_3]; ?>" disabled></div></div></div>
			<div class="clearFloat"></div>
		</form>

		<form name="hiddenform" action="/proxy/SetSMHData" method="post">
			<input type="hidden" name="autostart" value="">
			<input type="hidden" name="timeoutsmh" value="">
			<input type="hidden" name="port2301" value="">
		</form>

		<script>
			writePageFooter();
			//Activate buttons
			reconcileEventHandlers();
		</script>
		</div>
	</div>

</body>
</html>
