<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Call AI
  $stdout = AIBridge::getErrorLog();

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  // Create associative array of pertinent errorlog info
  $key = array(
    'test'        => 't',
    'description' => 'd',
    'repair'      => 'r',
    'count'       => 'n',
    'code'        => 'c');
  $errorLogArray = array();
  $errorLogArray['key']  = $key;
  $errorLogArray['data'] = array();
  $xpath = xpath_new_context($document);
  $records = xpath_eval($xpath, '/errorLogRecord');
  foreach ($records->nodeset as $record)
  {
    $errorArray = array();
    $errorArray[$key['test']] = $record->get_attribute('testCaption');
    $xpath = xpath_new_context($record);
    $errors = xpath_eval($xpath, '/error');
    $numberOfErrors = count($errors->nodeset);
    if ($numberOfErrors)
    {
      $error = $errors->nodeset[0]; // there should only be 1, if there are more, we ignore the remaining

      $caption      = $error->get_attribute('caption');
      $failedCount  = $error->get_attribute('count');
      $errorCode    = $error->get_attribute('errorCode');
      $errorContent = $error->get_content();
      
      $repairContent = '';
      $xpath = xpath_new_context($error);
      $repairActions = xpath_eval($xpath, '/repairAction');
      $numberOfRepairActions = count($repairActions->nodeset);
      if ($numberOfRepairActions)
      { 
        $repairAction = $repairActions->nodeset[0]; // there should only be 1, if there are more, we ignore the remaining
        $repairContent = $repairAction->get_content();
        $errorContent = substr($errorContent, 0, strpos($errorContent, $repairContent)); // remove the repair action
      }
      $errorArray[$key['description']] = $caption.'\n'.$errorContent;
      $errorArray[$key['repair']]      = $repairContent;
      $errorArray[$key['count']]       = $failedCount;
      $errorArray[$key['code']]        = $errorCode;
    }
    $errorLogArray['data'][] = $errorArray;
  }
  // Output JSON object
  exit(Rosetta::arrayToJSON($errorLogArray));
  //*/
?>