<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Check for variables
  if (!requiredParameters('processID'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Process ID is missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  
  if (isset($_GET['promptID']))
  {
    $replyingToPrompt = true;
    if (!requiredParameters('value'))
    {
      $outputArray = array(
        'name'  => 'Error',
        'value' => 'Prompt value is missing');
      die(Rosetta::arrayToJSON($outputArray));
    }
  }
  else
  {
    $replyingToPrompt = false;
  }

  // Call AI
  if ($replyingToPrompt)
    $stdout = AIBridge::replyToPrompt($_GET['processID'], $_GET['promptID'], $_GET['value']);
  else
    $stdout = AIBridge::getProcessStatus($_GET['processID']);

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  $xpath = xpath_new_context($document);
  $key = array(
    'percentComplete' => 'p',
    'state'           => 's',
    'caption'         => 'c',
    'desiredLoops'    => 'l',
    'currentLoop'     => 'o',
    'desiredTime'     => 't',
    'currentTime'     => 'i',
    'totalTests'      => 'e',
    'testsFinished'   => 'f',
    'testsFailed'     => 'a',
    'children'        => 'h',
    'component'       => 'm',
    'description'     => 'd',
    'device'          => 'v',
    'test'            => 't',
    'processID'       => 'r',
    'runTime'         => 'u',
    'result'          => 'l',
    'promptID'        => 'i',
    'content'         => 'n',
    'type'            => 't',
    'options'         => 'o',
    'optionID'        => 'i',
    'queuedPrompt'    => 'q');
  $status = array();
  $status['key'] = $key;
  $status['data'] = array();

  $percentComplete = $document->get_attribute('percentComplete');
  $status['data'][$key['percentComplete']] = ($percentComplete != '') ? $percentComplete : '0';
  $status['data'][$key['state']]         = $document->get_attribute('state');
  $status['data'][$key['caption']]       = $document->get_attribute('caption');
  $status['data'][$key['desiredLoops']]  = $document->get_attribute('testLoops');
  $status['data'][$key['currentLoop']]   = $document->get_attribute('currentLoop');
  $status['data'][$key['desiredTime']]   = $document->get_attribute('desiredTestTime');
  $status['data'][$key['currentTime']]   = $document->get_attribute('testTime');
  $status['data'][$key['totalTests']]    = $document->get_attribute('totalTests');
  $status['data'][$key['testsFinished']] = $document->get_attribute('testsFinished');
  $status['data'][$key['testsFailed']]   = $document->get_attribute('testsFailed');

  if (!isset($_GET['showChildren']) || $_GET['showChildren'] != 'no')
  {
    $status['data'][$key['children']] = array();
    $children = @ xpath_eval($xpath, '/processStatus');
    foreach ($children->nodeset as $child)
    {
      $childArray = array();
      $percentComplete = $child->get_attribute('percentComplete');
      $childArray[$key['percentComplete']] = ($percentComplete != '') ? $percentComplete : '0';
      $childArray[$key['state']] = $child->get_attribute('state');
      $childArray[$key['caption']] = $child->get_attribute('caption');
      $childArray[$key['component']] = $child->get_attribute('component');
      $childArray[$key['device']] = $child->get_attribute('device');
      $childArray[$key['test']] = $child->get_attribute('test');
      $childArray[$key['description']] = $child->get_attribute('description');
      $childArray[$key['processID']] = $child->get_attribute('processID');
      $childArray[$key['runTime']] = $child->get_attribute('testTime');
      $childArray[$key['result']] = $child->get_attribute('result');
      $status['data'][$key['children']][] = $childArray;
    }
  }

  $prompts = @ xpath_eval($xpath, 'diagPrompt');
  $foundValidPrompt = false;
  for ($i=0; $i<count($prompts->nodeset) && $foundValidPrompt == false; $i++)
  {
    $prompt = $prompts->nodeset[$i];
    $promptID = $prompt->get_attribute('promptID');
    if (!$replyingToPrompt || $_GET['promptID'] != $promptID)
    {
      $foundValidPrompt = true;
      $promptXpath = xpath_new_context($prompt);
      $parentNodes = @ xpath_eval($promptXpath, '/..');
      $parent = $parentNodes->nodeset[0];
      $promptArray = array();
      $promptArray[$key['promptID']] = $prompt->get_attribute('promptID');
      $promptArray[$key['caption']]  = $parent->get_attribute('caption');
      $promptArray[$key['content']]  = str_replace("\n", '<br />', $prompt->get_content());
      $promptArray[$key['type']]     = $prompt->get_attribute('type');
      $options = @ xpath_eval($promptXpath, '/option');
      if (count($options->nodeset) > 0)
      {
        $promptArray[$key['options']] = array();
        $optionID = 0;
        foreach ($options->nodeset as $option)
        {
          $optionArray = array();
          $optionArray[$key['optionID']] = $optionID;
          $optionArray[$key['caption']]  = $option->get_attribute('caption');
          $promptArray[$key['options']][] = $optionArray;
          $optionID++;
        }
      }
      $status['data'][$key['queuedPrompt']] = $promptArray;
    }
  }

  exit(Rosetta::arrayToJSON($status));

  /*
    $options = @ xpath_eval($xpath, '/option');
    $optionString = "[";
    for ($i=0; $i<count($options->nodeset); $i++)
    {
      $option = $options->nodeset[$i];
      if ($i > 0)
        $optionString .= ',';
      $optionString .= "{";
      $optionString .= "'id':'".$i."',";
      $optionString .= "'caption':'".$option->get_attribute('caption')."'";
      $optionString .= "}";
    }
    $optionString .= "]";
    $promptString .= "'options':".$optionString;
    $promptString .= "}";
  }

  //print_r($status);
  //exit (Rosetta::arrayToJSON($status));
/*
        $prompts = @ xpath_eval($xpath, "diagPrompt");

        
        switch ($childStateBits[0])
        {
        case ("running"):
          $childStateCaption = translate("MSG_RUNNING");
          break;
        case ("waiting"):
          $childStateCaption = translate("MSG_WAITING");
          break;
        case ("idle"):
          $childStateCaption = translate("MSG_IDLE");
          break;
        case ("canceled"):
          $childStateCaption = translate("MSG_CANCELED");
          break;
        case ("canceling"):
          $childStateCaption = translate("MSG_CANCELING");
          break;
        case ("completed"):
          if ($childResult == "passed")
            $childStateCaption = translate("MSG_PASSED");
          else if ($childResult == "failed")
            $childStateCaption = translate("MSG_FAILED");
          else
            $childStateCaption = translate("MSG_IDLE");
          break;
        default:
          $childStateCaption = "(NT)".$childStateBits[0];
        }
        
  
  // Adjust percent as needed
  if (!isset($percentComplete) || $percentComplete < 0)
    $percentComplete = 0;
  if ($percentComplete > 100)
    $percentComplete = 100;
  // Adjust state message
  switch ($state)
  {
  case ("running"):
    $stateCaption = translate("MSG_TESTING_IN_PROGRESS");
    break;
  case ("completed"):
    $stateCaption = translate("MSG_TESTING_COMPLETED");
    break;
  case ("canceling"):
    $stateCaption = translate("MSG_CANCELING");
    break;
  case ("canceled"):
  case ("canceled "):
    $stateCaption = translate("MSG_TEST_CANCELED");
    break;
  default:
    $stateCaption = "(NT)".$state;
  }
  // Output return object (JSON format)
  echo "/*JSON ({'name':'Response','state':'".$state."', 'stateCaption':'".$stateCaption."', 'percentComplete':".$percentComplete.", 'caption':'".$caption."', 'testLoops':'".$testLoops."', 'testTime':'".$testTime."', 'currentLoop':'".$currentLoop."', 'totalTests':'".$totalTests."', 'testsFinished':'".$testsFinished."', 'testsFailed':'".$testsFailed."', 'desiredTestTime':'".$desiredTestTime."', 'processes':".$processArrayString.", 'prompt':".$promptString."})";
?>
  
/*

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    $xpath = xpath_new_context($document);
    $percentComplete = $document->get_attribute("percentComplete");
    $state = $document->get_attribute("state");
    $caption = $document->get_attribute("caption");
    $testLoops = $document->get_attribute("testLoops");
    $testTime = $document->get_attribute("testTime");
    $currentLoop = $document->get_attribute("currentLoop");
    $totalTests = $document->get_attribute("totalTests");
    $testsFinished = $document->get_attribute("testsFinished");
    $testsFailed = $document->get_attribute("testsFailed");
    $desiredTestTime = $document->get_attribute("desiredTestTime");
    $promptString = "0";
    $processArrayString = "[";
    if (!isset($_GET["rootOnly"]) || $_GET["rootOnly"] == "no")
    {
      $childProcesses = @ xpath_eval($xpath, "/processStatus");
      
      for($i=0; $i<count($childProcesses->nodeset); $i++)
      {
        $child = $childProcesses->nodeset[$i];
        if ($i>0)
          $processArrayString .= ",";
        $prompts = @ xpath_eval($xpath, "diagPrompt");
        if (count($prompts->nodeset) > 0 && $promptString == '0')
        {
          $prompt = $prompts->nodeset[0];
          // If we just answered a prompt, make sure this isn't it
          if (!isset($_GET['promptID']) || $_GET['promptID'] != $prompt->get_attribute('promptID'))
            buildPromptString($prompt, $child, $promptString);
        }
        $childPercentComplete = $child->get_attribute("percentComplete");
        $childState = $child->get_attribute("state");
        $childCaption = $child->get_attribute("caption");
        $childComponent = $child->get_attribute("component");
        $childDevice = $child->get_attribute("device");
        $childTest = $child->get_attribute("test");
        $childDescription = $child->get_attribute("description");
        $childProcessID = $child->get_attribute("processID");
        $childTestTime = $child->get_attribute("testTime");
        $childResult = $child->get_attribute("result");
        $childStateBits = explode(":", $childState);
        switch ($childStateBits[0])
        {
        case ("running"):
          $childStateCaption = translate("MSG_RUNNING");
          break;
        case ("waiting"):
          $childStateCaption = translate("MSG_WAITING");
          break;
        case ("idle"):
          $childStateCaption = translate("MSG_IDLE");
          break;
        case ("canceled"):
          $childStateCaption = translate("MSG_CANCELED");
          break;
        case ("canceling"):
          $childStateCaption = translate("MSG_CANCELING");
          break;
        case ("completed"):
          if ($childResult == "passed")
            $childStateCaption = translate("MSG_PASSED");
          else if ($childResult == "failed")
            $childStateCaption = translate("MSG_FAILED");
          else
            $childStateCaption = translate("MSG_IDLE");
          break;
        default:
          $childStateCaption = "(NT)".$childStateBits[0];
        }

        if (!isset($childPercentComplete) || $childPercentComplete < 0 || $childPercentComplete == "")
          $childPercentComplete = 0;

        if ($childPercentComplete > 100)
          $childPercentComplete = 100;

        $processArrayString .= "{'state':'".$childState."','stateCaption':'".$childStateCaption."','percentComplete':".$childPercentComplete.",'caption':'".$childCaption."','component':'".$childComponent."','device':'".$childDevice."','test':'".$childTest."','description':'".$childDescription."','processID':'".$childProcessID."','testTime':'".$childTestTime."','result':'".$childResult."'}";
      }
    }
    $processArrayString .= "]";
  }
  else
  {
    die("/*JSON ({'name':'XML Error','value':'".$stdout."\\n".$stderr."'})");
  }
  // Check for prompts and include the first one found if they exist
  function buildPromptString($prompt, $parent, &$promptString)
  {
    $promptString = "{";
    $promptString .= "'title':'".$parent->get_attribute('caption')."',";
    $promptString .= "'caption':'".str_replace("\n", '<br>', $prompt->get_content())."',";
    $promptString .= "'component':'".$parent->get_attribute('component')."',";
    $promptString .= "'device':'".$prompt->get_attribute('device')."',";
    $promptString .= "'test':'".$prompt->get_attribute('test')."',";
    $promptString .= "'id':'".$prompt->get_attribute('promptID')."',";
    $promptString .= "'type':'".$prompt->get_attribute('type')."',";
    $promptString .= "'width':'".$prompt->get_attribute('width')."',";
    $promptString .= "'height':'".$prompt->get_attribute('height')."',";
    $xpath = xpath_new_context($prompt);
    $options = @ xpath_eval($xpath, '/option');
    $optionString = "[";
    for ($i=0; $i<count($options->nodeset); $i++)
    {
      $option = $options->nodeset[$i];
      if ($i > 0)
        $optionString .= ',';
      $optionString .= "{";
      $optionString .= "'id':'".$i."',";
      $optionString .= "'caption':'".$option->get_attribute('caption')."'";
      $optionString .= "}";
    }
    $optionString .= "]";
    $promptString .= "'options':".$optionString;
    $promptString .= "}";
  }
  // Adjust percent as needed
  if (!isset($percentComplete) || $percentComplete < 0)
    $percentComplete = 0;
  if ($percentComplete > 100)
    $percentComplete = 100;
  // Adjust state message
  switch ($state)
  {
  case ("running"):
    $stateCaption = translate("MSG_TESTING_IN_PROGRESS");
    break;
  case ("completed"):
    $stateCaption = translate("MSG_TESTING_COMPLETED");
    break;
  case ("canceling"):
    $stateCaption = translate("MSG_CANCELING");
    break;
  case ("canceled"):
  case ("canceled "):
    $stateCaption = translate("MSG_TEST_CANCELED");
    break;
  default:
    $stateCaption = "(NT)".$state;
  }
  // Output return object (JSON format)
  echo "/*JSON ({'name':'Response','state':'".$state."', 'stateCaption':'".$stateCaption."', 'percentComplete':".$percentComplete.", 'caption':'".$caption."', 'testLoops':'".$testLoops."', 'testTime':'".$testTime."', 'currentLoop':'".$currentLoop."', 'totalTests':'".$totalTests."', 'testsFinished':'".$testsFinished."', 'testsFailed':'".$testsFailed."', 'desiredTestTime':'".$desiredTestTime."', 'processes':".$processArrayString.", 'prompt':".$promptString."})";
?>
//*/
?>
