<?php
header('Content-type: text/plain', true);

define('IS_ATTACHMENT', (isset($_GET['attachment']) && $_GET['attachment'] == 1));

include_once '../includes/globals.php';
include_once '../includes/rosetta.class.php';
include_once '../includes/filesaver.class.php';
include_once '../includes/fileprompter.class.php';

// Check for required parameters
if (IS_ATTACHMENT)
{
  if (!requiredParameters('category', 'advanced', 'filename'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  FilePrompter::prepareForSaving();
}
else
{
  if (!requiredParameters('devicePath', 'filename', 'category', 'advanced'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  // See if file exists
  if ((!isset($_GET['overwrite']) || $_GET['overwrite'] != 'yes') &&
      FileSaver::doesFileExist($_GET['filename'], 'html', $_GET['devicePath']))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'error:exists');
    die(Rosetta::arrayToJSON($outputArray));
  }
}

// Check for ID result
if (!file_exists(IDRESULT_PATH))
{
  $outputArray = array(
    'name'  => 'Error',
    'value' => 'idResult missing');
  die(Rosetta::arrayToJSON($outputArray));
}

// Make ID result into a XMLDocument
$xml = new XMLDocument(file_get_contents(IDRESULT_PATH));
$xpath = xpath_new_context($xml->document_element());
if ($_GET['category'] == 'all')
  //$categoryNodes = @ xpath_eval($xpath, ('/diagOutput/category'));
  $categoryNodes = @ xpath_eval($xpath, ('/diagOutput/category'));
else
  $categoryNodes = @ xpath_eval($xpath, ('/diagOutput/category[@name="' . $_GET['category'] . '"]'));

// Output HTML
$computerName = getComputerName();
$buildVersion = getBuildVersion();
$html = array();

$html[] = '<html>';
$html[] = '<head>';
$html[] = '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">';
$html[] = '<title>' . $computerName . ' - ' . translate('MSG_CURRENT_CONFIGURATION') . '</title>';
$html[] = includeStyleSheet('currentConfigStyle.css');
$html[] = '</head>';
$html[] = '<body>';

if ($buildVersion != '')
  $html[] = ('<i>HP Insight Diagnostics ' . translate('MSG_VERSION') . ' ' . $buildVersion . '</i><br>');

if ($computerName != '')
  $html[] = (translate('MSG_COMPUTER_NAME') . ': <b>' . $computerName . '</b>');

$html[] = '<table>';
foreach($categoryNodes->nodeset as $category)
{
  $xpath = xpath_new_context($category);
  $categoryChildren = @ xpath_eval($xpath, '/*');
  if ($_GET['category'] == 'all')
    outputCategoryHeader($category->get_attribute('caption'));
  foreach($categoryChildren->nodeset as $child)
  {
    $tagName = $child->tagname;
    $testOnly = $child->get_attribute('testOnly');
    // Make sure we want to display this entry
    if ($testOnly != '1' && ($tagName == 'device' || $tagName == 'structure' || $tagName == 'property'))
    {
      if ($_GET['advanced'] == 'yes' || $child->get_attribute('techDetail') != '1')
      {
        $sublevel = ($_GET['category'] == 'all') ? 1 : 0;
        outputEntry($child, $sublevel);
      }
    }
  }
}
$html[] = '</table>';

function outputCategoryHeader($name)
{
  global $html;
  $html[] = '<tr class="header">';
  $html[] = ('<th colspan="2">' . $name . '</th>');
  $html[] = '</tr>';
}

function outputEntry($entry, $sublevel)//, $advanced=false)
{
  global $html;
  $description = $entry->get_attribute('description');
  $value = $entry->get_attribute('value');
  $value = ($value != '') ? $value : (($description != '') ? $description : '');
  $value = trim($value);
  $caption = trim($entry->get_attribute('caption'));
  //    $entryArray[$key['isAdvanced']] = ($advanced || $entry->get_attribute('techDetail') == '1') ? true : false;
  if ($sublevel == 0)
  {
    //$entryArray[$key['entries']] = array();
    $string = ($caption == $value || $value == '') ? $caption : ($caption . ' - ' . $value);
    $html[] = '<tr class="header">';
    $html[] = '<th colspan="2">' . $string . '</th>';
    $html[] = '</tr>';
  }
  else if ($entry->get_attribute('hexData') == '1')
  {
    $html[] = '<tr class="hex">';
    $html[] = '<td colspan="2">' . $caption . ' - ' . $value . '</td>';
    $html[] = '</tr>';
  }
  else if ($sublevel == 1)
  {
    $html[] = '<tr>';
    if ($value == '' || $value == $caption)
      $html[] = '<th colspan="2">' . $caption . '</th>';
    else
      $html[] = '<th>' . $caption . '</th><td>' . $value . '</td>';
    $html[] = '</tr>';
  }
  else
  {
    $padding = (15 * ($sublevel - 1));
    $html[] = '<tr>';
    if ($value == '' || $value == $caption)
      $html[] = '<td colspan="2">' . $caption . '</td>';
    else
      $html[] = '<td style="padding-left:' . $padding . '">' . $caption . '</td><td>' . $value . '</td>';
    $html[] = '</tr>';
  }
  $xpath = xpath_new_context($entry);
  if ($entry->has_child_nodes())
  {
    $children = @ xpath_eval($xpath, '/child::node()');
    foreach ($children->nodeset as $child)
    {
      if ($child->node_type() == XML_ELEMENT_NODE)
      {
        $tagName = $child->tagname;
        $testOnly = $child->get_attribute('testOnly');
        // Make sure we want to display this entry
        if ($testOnly != '1' && ($tagName == 'device' || $tagName == 'structure' || $tagName == 'property'))
        {
          if ($_GET['advanced'] == 'yes' || $child->get_attribute('techDetail') != '1')
          {
            $sublevel++;
            outputEntry($child, $sublevel);
            $sublevel--;
          }
        }
      }
    }
  }
}

$html[] = '</body>';
$html[] = '</html>';

if (IS_ATTACHMENT)
{
  $filename = ($_GET['filename'] . ".html");
  FilePrompter::promptForSave($filename, $html, 'text/html');
}
else
{
  $filename = $_GET["filename"];
  $extension = "html";
  $devicePath = $_GET["devicePath"];
  
  $saveResult = FileSaver::saveArrayToFile($filename, $extension, $devicePath, $html);
  if ($saveResult === true)
    exit('0');
  else
    exit('error');
}
//*/
?>
