<?php
header('Content-type: text/html; charset=utf-8', true);

define('IS_ATTACHMENT', (isset($_GET['attachment']) && $_GET['attachment'] == 1));

include_once '../includes/globals.php';
include_once '../includes/aibridge.class.php';
include_once '../includes/rosetta.class.php';
include_once '../includes/filesaver.class.php';
include_once '../includes/fileprompter.class.php';

// Check for required parameters
if (IS_ATTACHMENT)
{
  if (!requiredParameters('filename'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  FilePrompter::prepareForSaving();
}
else
{
  if (!requiredParameters('devicePath', 'filename'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  // See if file exists
  if ((!isset($_GET['overwrite']) || $_GET['overwrite'] != 'yes') &&
      FileSaver::doesFileExist($_GET['filename'], 'html', $_GET['devicePath']))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'error:exists');
    die(Rosetta::arrayToJSON($outputArray));
  }
}

if (isset($_GET['sortField']))
  $sortField = $_GET['sortField'];
else
  $sortField = '';

// Call AI
$imlLog = AIBridge::getImlLog($sortField);

// Try to make stdout into a XMLDocument
$xml = new XMLDocument($imlLog);
if ($xml)
{
  $document = $xml->document_element();
  if ($document->tagname() == 'error') // If AI returned an error:
  {
    $outputArray = array(
      'name'  => 'AI Error',
      'value' => $document->get_content());
    die(Rosetta::arrayToJSON($outputArray));
  }
  $xpath = xpath_new_context($document);
  $structures = @ xpath_eval($xpath, '/structure');
}
else
{
  $outputArray = array(
    'name'  => 'XML Error',
    'value' => $stdout);
  die(Rosetta::arrayToJSON($outputArray));
}

// Output HTML
$computerName = getComputerName();
$buildVersion = getBuildVersion();
$html = array();

$html[] = '<html>';
$html[] = '<head>';
$html[] = '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">';
$html[] = '<title>' . $computerName . ' - ' . translate('MSG_INTEGRATED_MANAGEMENT_LOG') . '</title>';
$html[] = includeStyleSheet('imlLogStyle.css');
$html[] = '</head>';
$html[] = '<body>';

if ($buildVersion != '')
  $html[] = ('<i>HP Insight Diagnostics ' . translate('MSG_VERSION') . ' ' . $buildVersion . '</i><br>');

if ($computerName != '')
  $html[] = (translate('MSG_COMPUTER_NAME') . ': <b>' . $computerName . '</b>');

$html[] = '<table>';

if (count($structures->nodeset) <= 0)
{
  $root = $xml->document_element();
  if (strstr($root->get_attribute('caption'), translate('MSG_NOT_AVAILABLE')) === FALSE)
  {
    $html[] = '<tr class="m">';
    $html[] = ('<td>' . translate('MSG_INTEGRATED_MANAGEMENT_LOG') . ' ' . translate('MSG_IS_EMPTY') . '</td>');
    $html[] = '</tr>';
  }
  else
  {
    $html[] = '<tr class="m">';
    $html[] = ('<td>' . translate('MSG_INTEGRATED_MANAGEMENT_LOG') . ': ' . translate('MSG_NOT_AVAILABLE') . '</td>');
    $html[] = '</tr>';
  }
}
else
{
  $html[] = '<thead>';
  $html[] = '<tr>';
  $html[] = ('<td>' . translate('MSG_SEVERITY') . '</th>');
  $html[] = ('<td class="c">' . translate('MSG_CLASS') . '</th>');
  $html[] = ('<td class="c">' . translate('MSG_LAST_UPDATE') . '</th>');
  $html[] = ('<td class="c">' . translate('MSG_INITIAL_UPDATE') . '</th>');
  $html[] = ('<td class="c">' . translate('MSG_COUNT') . '</th>');
  $html[] = ('<td>' . translate('MSG_DESCRIPTION') . '</th>');
  $html[] = '</tr>';
  $html[] = '</thead>';
  $html[] = '<tbody>';

  foreach ($structures->nodeset as $structure)
  {
    $structureXpath = xpath_new_context($structure);
    $properties = @ xpath_eval($structureXpath, '/property');

    $class = $structure->get_attribute('class');
    $code = $structure->get_attribute('code');
    $index = $structure->get_attribute('index');

    $description = $code;

    $individualRows = array('Severity', 'Count', 'lastUpdate', 'initialUpdate');
    $rowParameters = array();
    foreach ($properties->nodeset as $property)
    {
      $name = $property->get_attribute('name');
      $value = $property->get_attribute('value');
      if (in_array($name, $individualRows))
      {
        $rowParameters[$name] = $value;
      }
      else
      {
        $caption = $property->get_attribute("caption");
        $description .= (' - ' . $caption . ': ' . $value);
      }
    }
    
    $html[] = '<tr>';
    $html[] = ('<td>' . $rowParameters['Severity'] . '</td>');
    $html[] = ('<td class="c">' . $class . '</td>');
    $html[] = ('<td class="c">' . $rowParameters['lastUpdate'] . '</td>');
    $html[] = ('<td class="c">' . $rowParameters['initialUpdate'] . '</td>');
    $html[] = ('<td class="c">' . $rowParameters['Count'] . '</td>');
    $html[] = ('<td>' . $description . '</td>');
    $html[] = '</tr>';
  }
  $html[] = '</tbody>';
}

$html[] = '</table>';
$html[] = '</body>';
$html[] = '</html>';

if (IS_ATTACHMENT)
{
  $filename = ($_GET['filename'] . ".html");
  FilePrompter::promptForSave($filename, $html, 'text/html');
}
else
{
  $filename = $_GET["filename"];
  $extension = "html";
  $devicePath = $_GET["devicePath"]; 
  
  $saveResult = FileSaver::saveArrayToFile($filename, $extension, $devicePath, $html);
  if ($saveResult == 'success')
  {
    exit('0');
  }
  else
  {
    exit("error");
  }
}
//*/
?>
