<?php
header('Content-type: text/plain', true);

define('IS_ATTACHMENT', (isset($_GET['attachment']) && $_GET['attachment'] == 1));

include_once '../includes/aibridge.class.php';
include_once '../includes/globals.php';
include_once '../includes/rosetta.class.php';
include_once '../includes/filesaver.class.php';
include_once '../includes/fileprompter.class.php';

// Check for required parameters
if (IS_ATTACHMENT)
{
  if (!requiredParameters('filename'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  FilePrompter::prepareForSaving();
}
else
{
  if (!requiredParameters('devicePath', 'filename'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  // See if file exists
  if ((!isset($_GET['overwrite']) || $_GET['overwrite'] != 'yes') &&
      FileSaver::doesFileExist($_GET['filename'], 'html', $_GET['devicePath']))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'error:exists');
    die(Rosetta::arrayToJSON($outputArray));
  }
}

// Call AI
$stdout = AIBridge::getTestLog();

// Try to make stdout into a XMLDocument
$xml = new XMLDocument($stdout);
if ($xml)
{
  $document = $xml->document_element();
  if ($document->tagname() == 'error') // If AI returned an error:
  {
    $outputArray = array(
      'name'  => 'AI Error',
      'value' => $document->get_content());
    die(Rosetta::arrayToJSON($outputArray));
  }
  $xpath = xpath_new_context($document);
$records = @ xpath_eval($xpath, '/testLogRecord');
}
else
{
  $outputArray = array(
    'name'  => 'XML Error',
    'value' => $stdout);
  die(Rosetta::arrayToJSON($outputArray));
}

// Output HTML
$computerName = getComputerName();
$buildVersion = getBuildVersion();
$html = array();

$html[] = '<html>';
$html[] = '<head>';
$html[] = '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">';
$html[] = '<title>' . $computerName . ' - ' . translate('MSG_TEST_LOG') . '</title>';
$html[] = includeStyleSheet('testLogStyle.css');
$html[] = '</head>';
$html[] = '<body>';

if ($buildVersion != '')
  $html[] = ('<i>HP Insight Diagnostics ' . translate('MSG_VERSION') . ' ' . $buildVersion . '</i><br>');

if ($computerName != '')
  $html[] = (translate('MSG_COMPUTER_NAME') . ': <b>' . $computerName . '</b>');

if (count($records->nodeset) > 0)
{
  $html[] = '<table class="i">';
  $html[] = '<tr>';
  $html[] = ('<td class="p"><span>' . translate('MSG_PASSED') . '</span></td>');
  $html[] = ('<td> - ' . translate('MSG_DENOTES_PASSED_TESTS') . '</td>');
  $html[] = '</tr>';
  $html[] = '<tr>';
  $html[] = ('<td class="f"><span>' . translate('MSG_FAILED') . '</span></td>');
  $html[] = ('<td> - ' . translate('MSG_DENOTES_FAILED_TESTS') . '</td>');
  $html[] = '</tr>';
  $html[] = '</table>';
}
  
$html[] = '<table>';

if (count($records->nodeset) <= 0)
{
  $html[] = '<tr class="m">';
  $html[] = ('<td>' . translate('MSG_TEST_LOG') . ' ' . translate('MSG_IS_EMPTY') . '</td>');
  $html[] = '<tr>';
}
else
{
  $html[] = '<thead>';
  $html[] = '<tr>';
  $html[] = '<td>&nbsp;</td>';
  $html[] = ('<td>' . translate('MSG_DEVICE') . ', ' . translate('MSG_TEST') . '</td>');
  $html[] = ('<td class="c">' . translate('MSG_NUMBER_OF_TIMES_TESTED') . '</td>');
  $html[] = ('<td class="c">' . translate('MSG_NUMBER_OF_ERRORS') . '</td>');
  $html[] = ('<td class="c">' . translate('MSG_TEST_TIME') . '</td>');
  $html[] = ('<td class="r">' . translate('MSG_LAST_COMPLETION') . '</td>');
  $html[] = '</tr>';
  $html[] = '</thead>';
  $html[] = '<tbody>';

  foreach ($records->nodeset as $record)
  {
    $test = $record->get_attribute('testCaption');
    $passedCount = $record->get_attribute('passedCount');
    $failedCount = $record->get_attribute('failedCount');
    $time = $record->get_attribute('testTime');

    $xpath = xpath_new_context($record);
    $completions = @ xpath_eval($xpath, '/testCompletion[@result!=""]'); // only get test completions with actual results
    $testCount = $passedCount + $failedCount;
    $completionCount = count($completions->nodeset);
  
    if ($completionCount)
    {
      $lastCompletion = $completions->nodeset[$completionCount-1]; // get the last testCompetion
      $lastCompletionTime = $lastCompletion->get_attribute('completionTime');
      $result = $lastCompletion->get_attribute('result');
    }
    else
    {
      $lastCompletionTime = '';
      $result = '';
    }
    $resultCaption = ($result == 'passed') ? translate('MSG_PASSED') : (($result == 'failed') ? translate('MSG_FAILED') : '');
    $resultClass = ($result == 'passed') ? ' class="p"' : (($result == 'failed') ? ' class="f"' : '');

    $html[] = ('<tr>');
    $html[] = ('<td' . $resultClass . '><span>' . $resultCaption . '</span></td>');
    $html[] = ('<td>' . $test . '</td>');
    $html[] = ('<td class="c">' . $testCount . '</td>');
    $html[] = ('<td class="c">' . $failedCount . '</td>');
    $html[] = ('<td class="c">' . $time . '</td>');
    $html[] = ('<td class="r">' . $lastCompletionTime . '</td>');
    $html[] = '</tr>';
  }
  $html[] = '</tbody>';
}

$html[] = '</table>';
$html[] = '</body>';
$html[] = '</html>';

if (IS_ATTACHMENT)
{
  $filename = ($_GET['filename'] . ".html");
  FilePrompter::promptForSave($filename, $html, 'text/html');
}
else
{
  $filename = $_GET["filename"];
  $extension = "html";
  $devicePath = $_GET["devicePath"];
  
  $saveResult = FileSaver::saveArrayToFile($filename, $extension, $devicePath, $html);
  if ($saveResult == 'success')
  {
    exit('0');
  }
  else
  {
    exit("error");
  }
}
//*/
?>
