<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Check for variables
  if (!requiredParameters('scheduleMode','hour','minute','months','monthdays','weekdays','command'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some Required Variables were missing');
    die(Rosetta::arrayToJSON($outputArray));
  }

  // Get additional variables
  $attributes = array_slice($_POST, 7);
  
  // Call AI
  $stdout = AIBridge::scheduleProcess($_POST['scheduleMode'], $_POST['hour'], $_POST['minute'], $_POST['months'], $_POST['monthdays'], $_POST['weekdays'], $_POST['command'], $attributes);

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  exit('0');
  //*/
?>
