<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Check for variables
  if (!requiredParameters('devices'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some Required Variables were missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  
  // Call AI
  $stdout = AIBridge::startDiagnosisTests($_POST['devices']);

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
    $processID = $document->get_attribute('processID');
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  exit($processID);
?>
