<?php
header('Content-type: text/html; charset=utf-8', true);
header('Cache-control: no-cache', true);
header('Pragma: no-cache');

include_once '../includes/globals.php';

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <title>Help</title>
  <link rel="stylesheet" type="text/css" media="all" href="../css/help.css"></link>
  <script type="text/javascript">
    document.oncontextmenu = function ()
    {
      return top.CONFIG.DEBUG_ACTIVE;
    }
  </script>
</head>
<body>
<?php
// exit if path contains .. or does not contain .htm
if (strpos($_GET['path'], '..') !== false ||
    strpos($_GET['path'], '.htm') === false)
  exit('Invalid Path');
// append path to the help directory to ensure we are in the right spot
$path = realpath(dirname(__FILE__) . '/' . $_GET['path']);
// exit if path is not a valid path
if ($path == false)
  exit('Invalid Path');
// exit if path is not a file
if (!is_file($path))
  exit('Invalid Path');


if (!isset($_GET['word']))
{
  include_once $path;
}
else
{
  $word = htmlentities(stripslashes($_GET['word']), ENT_NOQUOTES, 'UTF-8');
  if ($word == '')
  {
    include_once $path;
  }
  else
  {
    $fileContent = file_get_contents($path);
    $fileContent = str_replace('<', "\n<", $fileContent);
    $fileContent = str_replace('>', ">\n", $fileContent);
    $fileContent = explode("\n", $fileContent);
    $pageContent = array();
    foreach ($fileContent as $line)
    {
      if (stristr($line, '<') == false)
        $line = preg_replace(('/(' . $word . ')/i'), '<span class="highlight">$1</span>', $line);
      $pageContent[] = $line;
    }
    echo implode('', $pageContent);
  }
}
?>
</body>
</html>
