<?php
//require_once '../inc/shared.php';

function is_associative($array)
{
  $returnVal = false;
  if (is_array($array) && count($array) > 0)
  {
    $keys = array_keys($array);
    foreach ($keys as $key)
    {
      if (!is_numeric($key))
        $returnVal = true;
    }
  }
  return $returnVal;
  //return is_array($array) && count($array) > 0 && !is_numeric(implode('', array_keys($array)));
}

class Rosetta
{
  function arrayToJSON($array, $forceArray=false, $quoteKeys=false)
  {
    return '/*JSON*/('.Rosetta::_convertVariableToJSON($array, $forceArray, $quoteKeys).')';
  }
  
  function _convertVariableToJSON($variable, $forceArray=false, $quoteKeys=false)
  {
    $returnVal = '';
    switch (gettype($variable))
    {
    case 'string':
      $variable = preg_replace('/\n/', '<br>', $variable);
      $returnVal = '"'.addslashes($variable).'"';
      break;
    case 'boolean':
      $returnVal = ($variable) ? 'true' : 'false';
      break;
    case 'integer':
    case 'float':
    case 'double':
      $returnVal = $variable;
      break;
    case 'null':
      $returnVal = 'undefined';
      break;
    case 'array':
      if (is_associative($variable) && $forceArray == false)
      {
        $returnVal .= '{';
        $keys = array_keys($variable);
        for($i=0; $i<count($keys); $i++)
        {
          $key = $keys[$i];
          $value = $variable[$key];
          if ($i>0)
            $returnVal .= ',';
          if ($quoteKeys)
            $returnVal .= '"'.$key.'":';
          else
            $returnVal .= $key.':';
          $returnVal .= Rosetta::_convertVariableToJSON($value, $forceArray, $quoteKeys);
        }
        $returnVal .= '}';
      }
      else
      {
        $returnVal .= '[';
        for($i=0; $i<count($variable); $i++)
        {
          $value = $variable[$i];
          if ($i>0)
            $returnVal .= ',';
          $returnVal .= Rosetta::_convertVariableToJSON($value, $forceArray, $quoteKeys);
        }
        $returnVal .= ']';
      }
      break;
    default:
      $returnVal = '"'.$variable.'"';
    }
    return $returnVal;
  }
  
  function xmlToArray($string)
  {
    $cleanedContent = str_replace("\n", '', $string); // strip newlines
    $cleanedContent = preg_replace('/>([\s]+)</', '><', $cleanedContent); // strip spaces between tags
    $xml = new XMLDocument($cleanedContent);
    $root = $xml->document_element();
    $array = Rosetta::_xmlTagToArray($root);
    return $array;
  }
  
  function xmlFileToArray($filePath)
  {
    if (!file_exists($filePath))
      trigger_error('Rosetta::xmlFileToArray - file '.$filePath.' does not exist', E_USER_WARNING);
    $fileContent = file_get_contents($filePath);
    $array = Rosetta::xmlToArray($fileContent);
    return $array;
    /*
    $cleanedContent = str_replace("\n", '', $fileContent); // strip newlines
    $cleanedContent = preg_replace('/>([\s]+)</', '><', $cleanedContent); // strip spaces between tags
    $xml = new XMLDocument($cleanedContent);
    $root = $xml->document_element();
    $array = Rosetta::_xmlTagToArray($root);
    return $array;
    */
  }
  
  function xmlToJSON($string)
  {
    $array = Rosetta::xmlToArray($string);
    $json = Rosetta::arrayToJSON($array);
    return $json;
  }
  
  function xmlFileToJSON($filePath)
  {
    $array = Rosetta::xmlFileToArray($filePath);
    $json = Rosetta::arrayToJSON($array);
    return $json;
  }
  
  function _xmlTagToArray(&$tag)
  {
    $array = array();
    switch ($tag->node_type())
    {
    case XML_ELEMENT_NODE:
      $array['type'] = 'element';
      $array['tagname'] = $tag->tagName();
      $array['attributes'] = array();
      $attributes = $tag->attributes();
      for ($i=0; $i<count($attributes); $i++)
      {
        $attribute = $attributes[$i];
        $attArray = array();
        $attArray['name'] = $attribute->name;
        $attArray['value'] = addslashes($attribute->value);
        $array['attributes'][] = $attArray;
      }
      $array['children'] = array();
      $children = $tag->child_nodes();
      for($i=0; $i<count($children); $i++)
      {
        $child = $children[$i];
        if (($child->node_type() == XML_ELEMENT_NODE && $child->tagName() != '') || $child->node_type() == XML_TEXT_NODE)
          $array['children'][] = Rosetta::_xmlTagToArray($child);
      }
      return $array;
      break;
    case XML_TEXT_NODE:
      $array['type'] = 'text';
      $array['value'] = addslashes($tag->node_value());
      return $array;
      break;
    }
  }
  
}
?>
