<?php
  // Translates a MSG tag into a language string
  function translate($MSG)
  {
    // Setup variables
    global $translationArray;
    $returnVal = $MSG;
    // Initialize translationArray if it is not yet initialized
    if (!isset($translationArray))
      $translationArray = buildTranslationArray(LANG);
    // If the MSG exists, return the translation, otherwise return the MSG tag
    if (isset($translationArray[$MSG]))
      $returnVal = $translationArray[$MSG];

    return $returnVal;
  }

  // Create a translation array from the common and sdl files of the specified language
  function buildTranslationArray($lang)
  {
    $returnVal = array();

    // If language is english, load the spanish files
    if ($lang == 'en')
      $suffix = '.es.xml';
    else
      $suffix = ('.' . $lang . '.xml');

    // Set up the paths of the translation files
    $translationFiles[0] = realpath(DIAGS_DIRECTORY . 'sdl' . $suffix);
    $translationFiles[1] = realpath(DIAGS_DIRECTORY . 'common' . $suffix);

    foreach($translationFiles as $file)
    {
      // Put the files into a XMLDocument and extract its strings
      $xml = new XMLDocument(file_get_contents($file));
      $xpath = xpath_new_context($xml->document_element());
      $strings = @ xpath_eval($xpath, '/string');
      foreach($strings->nodeset as $string)
      {
        $stringID = $string->get_attribute('id');
        $stringXpath = xpath_new_context($string);
        // Get the first key (should be the only key) of the string
        $keys = @ xpath_eval($stringXpath, '/key');
        $key = $keys->nodeset[0];
        // If our language is english, we will use the key only
        if ($lang == 'en')
        {
          $returnVal[$stringID] = $key->get_content(); //htmlentities($key->get_content(), ENT_QUOTES, 'utf-8');
        }
        // Otherwise we get the associated value
        else
        {
          $values = @ xpath_eval($stringXpath, '/value');
          // If a value is present (is translated), use that
          if (count($values->nodeset) > 0)
          {
            $value = $values->nodeset[0];
            $returnVal[$stringID] = $value->get_content(); //htmlentities($value->get_content(), ENT_QUOTES, 'utf-8');
          }
          // If no value is present, use the english key instead
          else
          {
            $returnVal[$stringID] = $key->get_content(); //htmlentities($key->get_content(), ENT_QUOTES, 'utf-8');
          }
        }
      }
    }
    return $returnVal;
  }
?>
