/********************************************************************
//        NAME- CollapsingWidget
// DESCRIPTION- Used by collapsable objects as the UIElement that
//              controls their states
********************************************************************/

/********************************************************************
// CollapsingWidget(controller[, initialState]) : constructor
//   controller : Object
//   initialState : String (default: empty)
// Creates a new CollapsingWidget controlled by controller.
// initialState should be (empty|collapsed|expanded)
********************************************************************/
function CollapsingWidget(controller, initialState)
{
  this.expandImage   = 'images/tree_expand.gif'; // image to use when clicking widget will expand object
  this.collapseImage = 'images/tree_collapse.gif'; // image to use when clicking widget will collapse object
  this.emptyImage    = 'images/tree_empty.gif'; // image to use when widget's object contains no children

  this.state      = initialState || 'empty'; // this widget's current state, defaults to empty
  this.controller = controller;
  // create the Element that represents the widget
  this.element    = newElement('img', {'class':'ui_treeControl', 'controller':this.controller});
  // update the element to make sure it matches default settings
  this.updateElement();
}

/********************************************************************
// CollapsingWidget.updateElement() : function
// Redraws the widget to match its current state
********************************************************************/
CollapsingWidget.prototype.updateElement = function updateElement()
{
  switch (this.state)
  {
  case 'expanded':
    this.element.src = this.collapseImage;
    this.element.fade(0); // make the widget fully opaque
    // assign the widget its behavior
    this.element.onclick = function ()
    {
      this.controller.collapse();
    }
    break;
  case 'collapsed':
    this.element.src = this.expandImage;
    this.element.fade(0); // make the widget fully opaque
    // assign the widget its behavior
    this.element.onclick = function ()
    {
      this.controller.expand();
    }
    break;
  default:
    this.element.src = this.emptyImage;
    this.element.fade(75); // make the widget 75% transparent
    // when empty, the widget should have no behavior
    this.element.onclick = null;
  }
}

/********************************************************************
// CollapsingWidget.setState(state) : function
//   state : String
// Sets the widget's state and calls updateElement
// state should be (empty|collapsed|expanded)
********************************************************************/
CollapsingWidget.prototype.setState = function setState(state)
{
  this.state = state;
  this.updateElement();
}
