/********************************************************************
//        NAME- CurrentConfigController
// DESCRIPTION- controls all the functions of the currentConfig panel
********************************************************************/

/********************************************************************
// CurrentConfigController() : constructor
// Instantiates the CurrentConfigController object
********************************************************************/
function CurrentConfigController()
{
  this.defaultCategory = 'overview';
  this.currentViewLevel = 'summary';
  this.viewURL = 'views/currentConfig.php';
  this.saveCommand = 'commands/saveCurrentConfig.php';

  this.currentCategory = null;
  
  this.viewController = new ViewController('currentConfigFrame');
  this.categoryRequest = new ServerRequest('commands/getConfigCategories.php');

  this.categoryControl = extendElement(getElement('currentConfigCategory'));
  this.shadowBox = this.viewController.shadowBox; // link to the viewController's shadowBox

  this.saveButton = getElement('saveCurrentConfig');
  if (CONFIG.IS_ONLINE)
    this.printButton = getElement('printCurrentConfig');
 
  this.init();
}

/********************************************************************
// CurrentConfigController.init() : function
// Initializes the object by setting the behaviors of various
//   elements
********************************************************************/
CurrentConfigController.prototype.init = function init()
{
  // levelControl controls the View Level
  var levelControl = getElement('currentConfigViewLevel');
  levelControl.controller = this;
  levelControl.onchange = function ()
  {
    this.controller.setViewLevel(this.value);
  }

  // categoryControl controls the currently displayed category
  this.categoryControl.controller = this;
  this.categoryControl.onchange = function ()
  {
    this.controller.loadCategory(this.value);
  }
  
  this.categoryRequest.controller = this;
  this.categoryRequest.callback = function (data)
  {
    this.controller.receiveCategories(data);
  }

  if (CONFIG.IS_ONLINE == true)
  {
    // scheduleCaptureButton controls the scheduleDialog
    var scheduleCapturesButton = getElement('scheduleCaptures');
    scheduleCapturesButton.controller = this;
    scheduleCapturesButton.action = function ()
    {
      Frontend.scheduleDialog.openDialog(translate('MSG_SCHEDULE_SURVEY_CAPTURE'), this.controller);
    }

    var manageCapturesButton = getElement('manageCaptures');
    manageCapturesButton.controller = this;
    manageCapturesButton.action = function ()
    {
      Frontend.manageSurveysDialog.show();
    }
  }

  // saveButton controls the saveDialog
  this.saveButton.controller = this;
  this.saveButton.action = function ()
  {
    this.controller.save();
  }
  this.saveButton.disable();
  
  if (this.printButton) // if we are offline, this button will not exist
  {
    this.printButton.controller = this;
    this.printButton.action = function ()
    {
      this.controller.viewController.getContentWindow().print();
    }
    this.printButton.disable();
  }
  
  this.getCategories();

  return this;
}

/********************************************************************
// CurrentConfigController.setViewLevel(value) : function
//   value : String
// Sets whether or not to display advanced entries
********************************************************************/
CurrentConfigController.prototype.setViewLevel = function setViewLevel(value)
{
  this.saveButton.disable();
  if (this.printButton)
    this.printButton.disable();
  this.currentViewLevel = value;
  this.loadCategory(this.currentCategory);
}
    
/********************************************************************
// CurrentConfigController.loadCategory(categoryName) : function
//   categoryName : String
// Sets the url of the frame with the appropriate query string to
//   display the selected categoryName
********************************************************************/
CurrentConfigController.prototype.loadCategory = function loadCategory(categoryName)
{
  this.saveButton.disable();
  if (this.printButton)
    this.printButton.disable();
  var advanced = (this.currentViewLevel == 'advanced') ? 'yes' : 'no';
  this.viewController.setParameter('advanced', advanced);
  this.viewController.setParameter('category', categoryName);
  this.viewController.setURL(this.viewURL);
  this.currentCategory = categoryName;
}

/********************************************************************
// CurrentConfigController.getCategories() : function
// Sends the ServerRequest to retrieve the list of categories
//   available for viewing
********************************************************************/
CurrentConfigController.prototype.getCategories = function getCategories()
{
  this.categoryControl.cloak();
  clearChildren(this.categoryControl);
  this.categoryControl.appendChild(newElement('option', {'text':translate('MSG_LOADING')}));
  this.categoryControl.disabled = true;
  this.categoryControl.uncloak();
  this.categoryRequest.send();
}

/********************************************************************
// CurrentConfigController.receiveCategories(categoryData) : function
//   categoryData : Object
// Receives the data from the server containing available categories
//   and displays them in the categoryControl
********************************************************************/
CurrentConfigController.prototype.receiveCategories = function receiveCategories(categoryData)
{
  var key = categoryData.key;
  var categories = categoryData.data;
  var numberOfCategories = categories.length;
  this.categoryControl.cloak();
  clearChildren(this.categoryControl);
  this.categoryControl.appendChild(newElement('option', {'value':'all','text':translate('MSG_ALL')}));
  var useDefault = false;
  for (var i=0; i<numberOfCategories; i++)
  {
    var category = categories[i];
    var name = category[key['name']];
    var caption = category[key['caption']];
    var option = this.categoryControl.appendChild(newElement('option', {'value':name, 'text':caption}));
    if (name == this.defaultCategory)
    {
      useDefault = true;
      option.selected = true;
    }
  }
  this.categoryControl.disabled = false;
  this.categoryControl.uncloak();
  if (useDefault)
    this.loadCategory(this.defaultCategory);
  else
    this.loadCategory('all');
}

/********************************************************************
// CurrentConfigController.appendScheduleInfo(request) : function
//   request : ServerRequest
// Called by scheduleDialog, adds specific variables to request
********************************************************************/
CurrentConfigController.prototype.appendScheduleInfo = function appendScheduleInfo(request)
{
  request.addVariable('command', 'diagID');
}

/********************************************************************
// CurrentConfigController.appendSaveInfo(request) : function
//   request : ServerRequest
// Called by saveDialog, adds specific variables to request
********************************************************************/
CurrentConfigController.prototype.appendSaveInfo = function appendSaveInfo(request)
{
  request.addVariable('category', this.currentCategory);
  if (this.currentViewLevel == 'advanced')
    request.addVariable('advanced', 'yes');
  else
    request.addVariable('advanced', 'no');
}

/********************************************************************
// CurrentConfigController.save() : function
// Called by saveButton, determines which type of save to perform
//   Offline Mode : use older server-side save system
//   Online Mode : use newer client-side save system
********************************************************************/
CurrentConfigController.prototype.save = function save()
{
  var header = (translate('MSG_SAVE') + ' ' + translate('MSG_CURRENT_CONFIGURATION'));
  if (CONFIG.IS_OFFLINE)
  {
    Frontend.saveDialog.openDialog(header, 'survey', this);
  }
  else
  {
    var query = 
    {
      attachment : 1,
      filename   : 'survey',
      category   : this.currentCategory,
      advanced   : (this.currentViewLevel == 'advanced') ? 'yes' : 'no'
    }
    Frontend.clientSave(this.saveCommand, query, header);
  }
}
