function DiagnoseController()
{
  //inherit(this, new DataRetriever(element));
  this.deviceRequest = new ServerRequest('commands/getDiagnosableDevices.php');
  this.request = new ServerRequest('commands/startDiagnosisTests.php', 'POST');
  this.actionCommand = new ServerRequest('commands/performDeviceAction.php');
  this.element = getElement('diagnoseDeviceListScroller');
  this.list = getElement('diagnoseDeviceList');
  this.button = extendElement(getElement('beginDiagnosis'));

  this.devices = [];

  this.init();
}

DiagnoseController.prototype.init = function init()
{
  this.deviceRequest.controller = this;
  this.deviceRequest.callback = function (data)
  {
    this.controller.receiveDevices(data);
  }

  this.request.controller = this;
  this.request.callback = function (data)
  {
    this.controller.testingBegan(data);
  }

  this.actionCommand.controller = this;
  this.actionCommand.callback = function (data)
  {
    this.controller.actionCompleted(data);
  }

  this.button.controller = this;
  this.button.action = function ()
  {
    this.controller.beginDiagnosis();
  }

  this.button.hide();
}

DiagnoseController.prototype.refresh = function refresh()
{
  this.deviceRequest.send();
}

DiagnoseController.prototype.receiveDevices = function receiveDevices(data)
{
  this.devices = [];
  var diagnosables = data["diagnosable"];
  var notDiagnosables = data["notDiagnosable"];
  clearChildren(this.list);
  var numberOfDiagnosableDevices = diagnosables.length;
  var numberOfNotDiagnosableDevices = notDiagnosables.length;
  if (numberOfDiagnosableDevices > 0 || numberOfNotDiagnosableDevices > 0)
  {
    if (numberOfDiagnosableDevices > 1)
      this.drawAllDevicesItem();
    for (var i=0; i<numberOfDiagnosableDevices; i++)
      this.drawDiagnosableDeviceItem(diagnosables[i]);
    for (var i=0; i<numberOfNotDiagnosableDevices; i++)
      this.drawNotDiagnosableDeviceItem(notDiagnosables[i]);
    this.button.show();
  }
  else
  {
    this.button.hide();
    this.drawNoDevicesItem();
  }
}

DiagnoseController.prototype.drawAllDevicesItem = function drawAllDevicesItem()
{
  var li = newElement('li', {'controller':this,'class':'ui_treeListLeaf'});
  this.allWidget = li.appendChild(newElement('input', {'type':'checkbox','controller':this}));
  li.appendChild(newText(translate('MSG_ALL_DEVICES')));
  li.widget = this.allWidget;
  this.allWidget.onclick = function ()
  {
    this.controller.allItemsToggle(this.checked);
  }
  this.list.appendChild(li);
}

DiagnoseController.prototype.drawDiagnosableDeviceItem = function drawDiagnosableDeviceItem(device)
{
  var li = newElement('li', {'controller':this,'class':'ui_treeListLeaf'});
  var widget = li.appendChild(newElement('input', {'type':'checkbox','controller':this,'value':device.name}));
  widget.onclick = function ()
  {
    this.controller.itemToggled(this);
  }
  this.devices.push(widget);
  li.appendChild(newText(device.caption));
  this.list.appendChild(li);
}

DiagnoseController.prototype.drawNotDiagnosableDeviceItem = function drawNotDiagnosableDeviceItem(device)
{
  var li = newElement('li', {'controller':this,'class':'ui_treeListLeaf disabled'});
  var widget = li.appendChild(newElement('input', {'type':'checkbox','disabled':'disabled','value':device.name}));
  li.appendChild(newText(device.caption + ' (' + translate('MSG_NOT_DIAGNOSABLE') + ')'));
  this.list.appendChild(li);
}

DiagnoseController.prototype.drawNoDevicesItem = function drawNoDevicesItem()
{
  var li = newElement('li', {'class':'ui_treeListLeaf','text':translate('MSG_DIAGNOSABLE_NOT_PRESENT')});
  this.list.appendChild(li);
}

DiagnoseController.prototype.allItemsToggle = function allItemsToggle(bool)
{
  var devices = this.devices;
  var numberOfDevices = devices.length;
  for (var i=0; i<numberOfDevices; i++)
    devices[i].checked = bool;
}


DiagnoseController.prototype.itemToggled = function itemToggled(widget)
{
  this.allWidget.checked = false;
}

DiagnoseController.prototype.beginDiagnosis = function beginDiagnosis()
{
  var targets = [];
  var devices = this.devices;
  var numberOfDevices = devices.length;
  for (var i=0; i<numberOfDevices; i++)
  {
    var device = devices[i];
    if (device.checked == true)
      targets.push(device.value);
  }
  var numberOfTargets = targets.length;
  if (numberOfTargets <= 0)
  {
    Frontend.inform(translate('MSG_PLEASE_SELECT_TEST'), translate('MSG_HARDWARE_DIAGNOSIS'));
  }
  else
  {
    var request = this.request;
    request.clearVariables();
    for (var i=0; i<numberOfTargets; i++)
      request.addVariable('devices[]', targets[i]);
    request.send();
  }
}

DiagnoseController.prototype.testingBegan = function testingBegan(data)
{
  if (data.name && data.name.indexOf('Error') >= 0)
  {
    alert(data.name + ': ' + data.value);
  }
  else
  {
    Frontend.statusController.startMonitoring(data, this, true);
  }
}

DiagnoseController.prototype.performAction = function performAction(actionData)
{
  var request = this.actionCommand;
  request.clearVariables();
  request.addVariable('component', actionData.component);
  request.addVariable('device', actionData.device);
  request.addVariable('subDevice', actionData.subDevice);
  request.addVariable('tcLoadFilename', actionData.tcLoadFilename);
  request.addVariable('call', actionData.call);
  var dialog = Frontend.dialog;
  dialog.setHeader(translate('MSG_PLEASE_WAIT'));
  dialog.setContent(translate('MSG_PERFORMING_ACTION') + ': ' + actionData.caption);
  dialog.setBadge('images/hourglass.gif');
  dialog.clearButtons();
  dialog.toggleHeader(true);
  dialog.toggleContent(true);
  dialog.toggleBadge(true);
  dialog.toggleButtons(false);
  dialog.show();
  request.send();
}

DiagnoseController.prototype.actionCompleted = function actionCompleted(response)
{
  Frontend.dialog.hide();
}

//*/
