function ErrorCodeController()
{
  this.viewURL = 'views/errorCodes.php';
  this.viewController = new ViewController('errorCodesFrame');

  this.button = getElement('findErrorCodesButton'); // looks up a specific error code
  this.input = getElement('errorCodesSearchInput'); // the field to enter the error code to look up
  
  // make a ModalElement to display specific error codes with
  this.codeDisplay = new ModalElement('errorCodeDisplay');

  // create a shadow box for the element
  this.shadowBox = this.viewController.shadowBox;

  // initialize the object
  this.init();
}

ErrorCodeController.prototype.init = function init()
{
  //this.pager.cloak(); // initially cloak the pager
  // button will look up a specific error code and display it in a Modal Element
  this.button.controller = this;
  this.button.action = function ()
  {
    this.controller.findCode(this.controller.input.value);
  }
  this.button.disable();
  // displayButton dismisses the modal element 
  var displayButton = getElement('errorCodeDisplayButton');
  displayButton.controller = this.codeDisplay;
  displayButton.onclick = function ()
  {
    this.controller.hide();
    getElement('errorCodeDisplayTable').hide();
  }
  extendElement(getElement('errorCodeDisplayTable')); // extend the element
}

ErrorCodeController.prototype.findCode = function findCode(code)
{
  var error = this.viewController.getContentWindow().getCode(code);
  if (error == -1)
  {
    Frontend.inform(('"' + code + '"<br>' + translate('MSG_ERROR_CODE_NOT_FOUND')), translate('MSG_FIND_ERROR_CODES'));
  }
  // otherwise update the modal element and display it
  else
  {
    getElement('errorCodeDisplayCodeField').innerHTML = error.code;
    getElement('errorCodeDisplayNameField').innerHTML = error.device;
    getElement('errorCodeDisplayMessageField').innerHTML = error.message;
    getElement('errorCodeDisplayRepairField').innerHTML = error.repair;
    getElement('errorCodeDisplayTable').show();
    this.codeDisplay.show(); // display modal dialog
  }
}
 
ErrorCodeController.prototype.refresh = function refresh()
{
  this.viewController.setURL(this.viewURL);
}

//*/
