/********************************************************************
//        NAME- ErrorCodeController
// DESCRIPTION- controls all the functions of the error code panel
//       NOTES- Inherits from DataRetriever
********************************************************************/

/********************************************************************
// ErrorCodeController() : constructor
// Instantiates the ErrorCodeController object
********************************************************************/
function ErrorLogController()
{
  this.saveCommand   = 'commands/saveErrorLog.php';
  this.viewURL = 'views/errorLog.php';

  this.clearButton = getElement('clearErrorLog');
  this.saveButton = getElement('saveErrorLog');

  this.viewController = new ViewController('errorLogFrame');
  this.clearRequest = new ServerRequest('commands/clearErrorLog.php');
  
  this.shadowBox = this.viewController.shadowBox;
  
  this.init();
}

ErrorLogController.prototype.init = function init()
{
  this.clearButton.controller = this;
  this.clearButton.action = function ()
  {
    this.controller.promptToClearLog(translate('MSG_ERROR_LOG'), this.controller);
  }
  this.clearButton.disable();

  this.saveButton.controller = this;
  this.saveButton.action = function ()
  {
    //Frontend.saveDialog.openDialog((translate('MSG_SAVE') + ' ' + translate('MSG_ERROR_LOG')), 'errorlog', this.controller);
    this.controller.save();
  }
  this.saveButton.disable();
  
  this.clearRequest.controller = this;
  this.clearRequest.callback = function ()
  {
    this.controller.refreshFrame();
  }
}

ErrorLogController.prototype.refreshFrame = function refreshFrame()
{
  this.saveButton.disable();
  this.clearButton.disable();
  this.viewController.setURL(this.viewURL);
}

ErrorLogController.prototype.promptToClearLog = function promptToClearLog(title)
{
  var controller = this;
  var dialog = Frontend.dialog;
  dialog.toggleBadge(false);
  dialog.setHeader(title);
  dialog.toggleHeader(true);
  dialog.setContent(translate('MSG_CLEAR_LOG_CONFIRMATION'));
  dialog.toggleContent(true);
  dialog.clearButtons();
  dialog.addButton(translate('MSG_OK'), null, function ()
  {
    dialog.hide();
    controller.clearLog();
  });
  dialog.addButton(translate('MSG_CANCEL'), null, function ()
  {
    dialog.hide();
  });
  dialog.toggleButtons(true);
  dialog.show();
}

ErrorLogController.prototype.clearLog = function clearLog()
{
  this.clearRequest.send();
}

ErrorLogController.prototype.appendSaveInfo = function appendSaveInfo(request)
{
  return false;
}

ErrorLogController.prototype.save = function save()
{
  var header = (translate('MSG_SAVE') + ' ' + translate('MSG_ERROR_LOG'));
  if (CONFIG.IS_OFFLINE)
  {
    Frontend.saveDialog.openDialog(header, 'errorlog', this);
  }
  else
  {
    var query = 
    {
      attachment : 1,
      filename   : 'errorlog'
    }
    Frontend.clientSave(this.saveCommand, query, header);
  }
}
