function ManageSurveysDialog()
{
  inherit(this, new ModalElement(getElement('manageDialog')));

  this.surveyListRequest = new ServerRequest('commands/getCapturedConfigurations.php');
  this.deleteRequest = new ServerRequest('commands/deleteCapturedConfigurations.php');

  this.deleteButton = extendElement(getElement('manageDialogDeleteButton'));
  this.cancelButton = getElement('manageDialogCancelButton');
  this.noSurveysLabel = extendElement(getElement('manageDialogNoSurveys'));
  this.loading = extendElement(getElement('manageDialogLoading'));
  this.instructions = extendElement(getElement('manageDialogInstructions'));
  this.surveyList = extendElement(getElement('manageDialogList'));
  this.scroller = extendElement(getElement('manageDialogListScroller'));

  this.surveyItems = [];

  this.init();
}


ManageSurveysDialog.prototype.init = function init()
{
  this.deleteButton.controller = this;
  this.deleteButton.onclick = function ()
  {
    this.controller.deleteSelected();
  }

  this.cancelButton.controller = this;
  this.cancelButton.onclick = function ()
  {
    this.controller.hide();
  }

  this.surveyListRequest.controller = this;
  this.surveyListRequest.callback = function (data)
  {
    this.controller.recieveData(data);
  }

  this.deleteRequest.controller = this;
  this.deleteRequest.callback = function (data)
  {
    this.controller.deleteCompleted(data);
  }

  this.scroller.hide();
  this.noSurveysLabel.hide();
  this.deleteButton.hide();
  this.instructions.hide();
}

ManageSurveysDialog.prototype.willShow = function willShow()
{
  this.refreshList();
}

ManageSurveysDialog.prototype.refreshList = function refreshList()
{
  this.scroller.hide();
  this.noSurveysLabel.hide()
  this.deleteButton.hide();
  this.loading.show();
  this.instructions.hide();
  this.surveyListRequest.send();
}

ManageSurveysDialog.prototype.recieveData = function recieveData(data)
{
  this.loading.hide();
  var surveys = data.data;
  var key = data.key;
  if (surveys.length <= 0)
  {
    this.deleteButton.hide();
    this.scroller.hide();
    this.noSurveysLabel.show();
    this.instructions.hide();
  }
  else
  {
    this.surveyItems = [];
    this.noSurveysLabel.hide();
    this.drawSurveys(key, surveys);
    this.instructions.show();
    this.scroller.show();
    this.deleteButton.show();
  }
  this.element.cloak();
  this.element.centerTo(Body.element());
  this.element.uncloak();
}

ManageSurveysDialog.prototype.drawSurveys = function drawSurveys(key, surveys)
{
  clearChildren(this.surveyList);
  this.drawAllSurveysItem();
  var count = surveys.length;
  for (var i=0; i<count; i++)
  {
    var survey = surveys[i];
    var li = newElement('li', {'controller':this, 'survey':survey[key['filename']]}, false);
    this.surveyItems.push(li);
    li.widget = li.appendChild(newElement('input', {'type':'checkbox', 'controller':this}, false));
    li.widget.onclick = function ()
    {
      this.controller.itemToggled(this);
    }
    li.appendChild(newText(survey[key['timestamp']]));
    this.surveyList.appendChild(li);
  }
}

ManageSurveysDialog.prototype.drawAllSurveysItem = function drawAllSurveysItem()
{
  var li = newElement('li', {'controller':this}, false);
  this.allWidget = li.appendChild(newElement('input', {'type':'checkbox', 'controller':this}, false));
  li.appendChild(newText(translate('MSG_CHECK_ALL')));
  li.widget = this.allWidget;
  this.allWidget.onclick = function ()
  {
    this.controller.allItemsToggle(this.checked);
  }
  this.surveyList.appendChild(li);
}

ManageSurveysDialog.prototype.allItemsToggle = function allItemsToggle(isChecked)
{
  var items = this.surveyItems;
  var count = items.length;
  for (var i=0; i<count; i++)
    items[i].widget.checked = isChecked;
}

ManageSurveysDialog.prototype.itemToggled = function itemToggled()
{
  this.allWidget.checked = false;
}

ManageSurveysDialog.prototype.deleteSelected = function deleteSelected()
{
  var selected = this.getSelected();
  var count = selected.length;
  if (count <= 0)
  {
    this.inform(translate('MSG_PLEASE_SELECT_CONFIG'), true, true);
  }
  else
  {
    this.deleteRequest.clearVariables();
    for (var i=0; i<count; i++)
      this.deleteRequest.addVariable('surveys[]', selected[i]);
    this.inform(translate('MSG_DELETING'), false);
    this.deleteRequest.send();
  }
}

ManageSurveysDialog.prototype.deleteCompleted = function deleteCompleted(response)
{
  if (response == '0')
  {
    this.endInform();
    this.inform(translate('MSG_CONFIGS_DELETED'), true, false);
  }
  else if (response != undefined && response.name != undefined && response.name.indexOf('Error') > -1)
  {
    this.endInform();
    this.inform((response.name + ': ' . response.value), true, true);
  }
  else
  {
    this.endInform();
    this.inform(('Unknown Error: ' + response), true, true);
  }
}

ManageSurveysDialog.prototype.getSelected = function getSelected()
{
  var items = this.surveyItems;
  var count = items.length;
  var selected = [];
  for (var i=0; i<count; i++)
  {
    if (items[i].widget.checked == true)
      selected.push(items[i].survey);
  }
  return selected;
}

ManageSurveysDialog.prototype.inform = function inform(message, doIncludeButton, doShowSelfAfterDismiss)
{
  doShowSelfAfterDismiss = (doShowSelfAfterDismiss == undefined) ? true : doShowSelfAfterDismiss;
  doIncludeButton = (doIncludeButton == undefined) ? true : doIncludeButton;
  var dialog = Frontend.dialog;
  dialog.setHeader(translate('MSG_MANAGE_SYS_CONFIGS'));
  dialog.toggleHeader(true);
  dialog.toggleBadge(false);
  dialog.setContent(message);
  dialog.toggleContent(true);
  dialog.clearButtons();
  if (doIncludeButton)
  {
    dialog.addButton(translate('MSG_OK'), null, function ()
    {
      if (doShowSelfAfterDismiss)
        Frontend.manageSurveysDialog.show();
      Frontend.dialog.hide();
    });
    dialog.toggleButtons(true);
  }
  else
  {
    dialog.toggleButtons(false);
  }
  dialog.show();
  this.hide();
}

ManageSurveysDialog.prototype.endInform = function endInform(doShowSelf)
{
  if (doShowSelf)
    this.show();
  Frontend.dialog.hide();
}
