function StatusController()
{
  this.viewURL = 'views/testStatus.php';
  this.diagnosisResultURL = 'views/diagnoseResult.php';

  this.runningStates = ['running', 'canceling'];

  this.progressBar = new ProgressBar('statusViewProgressBar');
  //this.dialog = new ModalDialog();
  this.buttonDialog = new TestPromptButtonDialog(this);
  this.textDialog = new TestPromptTextDialog(this);

  this.viewController = new BufferedViewController('statusFrameA', 'statusFrameB');

  this.caption = extendElement(getElement('statusCaption'));
  this.message = extendElement(getElement('statusMessage'));
  this.info = extendElement(getElement('statusInfo'));
  this.button = extendElement(getElement('cancelRetestButton'));

  this.resultRequest = new ServerRequest('commands/getProcessResult.php');
  this.cancelRequest = new ServerRequest('commands/cancelProcess.php');

  this.isMonitoring = false;
  this.isCanceling = false;
  this.isDiagnosisTests = false;

  this.init();
}

StatusController.prototype.init = function init()
{
  this.button.controller = this;
  this.button.cloak();
  
  this.viewController.setURL(this.viewURL);
  
  return this;
}

StatusController.prototype.resize = function resize()
{
  Body.adjustToViewport(this.viewController.currentFrame);
}

StatusController.prototype.startMonitoring = function startMonitoring(processID, caller, isDiagnosisTests)
{
  var that = this;
  backgroundTask(function ()
  {
    that.isDiagnosisTests = (isDiagnosisTests == undefined) ? false : isDiagnosisTests;
    that.caller = caller;
    that.processID = processID;
    Frontend.tabs.disableTab('diagnose');
    Frontend.tabs.disableTab('test');
    Frontend.tabs.helpTabs.disableTab('testComponent');
    Frontend.tabs.selectTab('status');
    that.refreshFrame();
  });
}

StatusController.prototype.refreshFrame = function refreshFrame(parameters)
{
  this.viewController.clearParameters();
  this.viewController.setParameter('processID', this.processID);
  if (parameters != undefined)
  {
    var numberOfParameters = parameters.length;
    for (var i=0; i<numberOfParameters; i++)
    {
      var parameter = parameters[i];
      this.viewController.setParameter(parameter.name, parameter.value);
    }
  }
  if (this.isDiagnosisTests === true)
    this.viewController.setParameter('diagnosisTests', 'yes');
  if (CONFIG.SCRIPT_TESTING_PID != undefined)
    this.viewController.setParameter('scriptTesting', 'yes');
  this.viewController.setURL(this.viewURL);
  this.isMonitoring = true;
}

StatusController.prototype.getDiagnosisResult = function getDiagnosisResult()
{
  this.viewController.clearParameters();
  this.viewController.setParameter('processID', this.processID);
  this.viewController.setURL(this.diagnosisResultURL);
}

StatusController.prototype.displayDiagnosisResult = function displayDiagnosisResult()
{
  this.resize();
  this.viewController.switchFrames();
  // these two lines force the frame to readjust its width in IE
  this.viewController.currentFrame.hide();
  this.viewController.currentFrame.show();
}

StatusController.prototype.setCaption = function setCaption(value)
{
  this.caption.innerHTML = value;
}

StatusController.prototype.setPercent = function setPercent(percent)
{
  this.progressBar.setPercent(percent);
}

StatusController.prototype.setMessage = function setMessage(value)
{
  this.message.innerHTML = value;
}

StatusController.prototype.setInfo = function setInfo(value)
{
  this.info.innerHTML = value;
}

StatusController.prototype.updateWithState = function updateWithState(state, failedCount)
{
  if (this.runningStates.contains(state) || state == '')
  {
    if (state != '' && this.isCanceling == false)
      this.setButtonToCancel();
    setTimeout(function ()
    {
      Frontend.statusController.refreshFrame();
    }, 2000);
  }
  else
  {
    if (this.isDiagnosisTests === true && this.isCanceling === false)
      this.getDiagnosisResult();
    else
      this.getResult();
    if (failedCount != undefined && failedCount > 0 && this.isDiagnosisTests === false)
      this.progressBar.setClass('failed');
    this.isCanceling = false;
    this.isMonitoring = false;
    this.setButtonToRetest();
    Frontend.tabs.enableTab('diagnose');
    Frontend.tabs.enableTab('test');
    Frontend.tabs.helpTabs.enableTab('testComponent');
  }
}

StatusController.prototype.updateWithPrompt = function updateWithPrompt(promptID, type, caption, content, options)
{
  var that = this;
  switch (type)
  {
  case 'button':
    var dialog = this.buttonDialog;
    dialog.promptID = promptID;
    dialog.setHeader(caption);
    dialog.setContent(content);
    dialog.setOptions(options);
    break;
  case 'text':
    var dialog = this.textDialog;
    dialog.promptID = promptID;
    dialog.setHeader(caption);
    dialog.setContent(content);
    break;
  }
  dialog.show();
}

StatusController.prototype.replyToPrompt = function replyToPrompt(promptID, value)
{
  var parameters = [];
  parameters.push({'name': 'promptID', 'value': promptID});
  parameters.push({'name': 'promptResponse', 'value': value});
  this.refreshFrame(parameters);
}

StatusController.prototype.getResult = function getResult()
{
  this.resultRequest.clearVariables();
  this.resultRequest.addVariable('processID', this.processID);
  this.resultRequest.callback = function ()
  {
    if (CONFIG.SCRIPT_TESTING_PID != undefined && CONFIG.SCRIPT_TESTING_AUTO_CLOSE != undefined && CONFIG.SCRIPT_TESTING_AUTO_CLOSE === true)
      Frontend.closeWindow();
  }
  this.resultRequest.send();
}

StatusController.prototype.cancelTesting = function cancelTesting()
{
  this.cancelRequest.clearVariables();
  this.cancelRequest.addVariable('processID', this.processID);
  this.cancelRequest.send();
  this.isCanceling = true;
  this.setButtonToCanceling();
}

StatusController.prototype.repeatTest = function repeatTest()
{
  this.caller.request.send();
  this.setButtonToRetesting();
}

StatusController.prototype.setButtonToCancel = function setButtonToCancel()
{
  this.button.action = function ()
  {
    this.controller.cancelTesting();
  }
  this.button.innerHTML = translate('MSG_CANCEL');
  this.button.enable();
  this.button.uncloak();
}

StatusController.prototype.setButtonToRetest = function setButtonToRetest()
{
  this.button.action = function ()
  {
    this.controller.repeatTest();
  }
  this.button.innerHTML = translate('MSG_RETEST');
  this.button.enable();
  this.button.uncloak();
}

StatusController.prototype.setButtonToCanceling = function setButtonToCanceling()
{
  this.button.innerHTML = translate('MSG_CANCEL');
  this.button.disable();
  this.button.uncloak();
}

StatusController.prototype.setButtonToRetesting = function setButtonToRetesting()
{
  this.button.innerHTML = translate('MSG_RETEST');
  this.button.disable();
  this.button.uncloak();
}
//*/