function TestPromptButtonDialog(controller)
{
  this.controller = controller;
  this.element = newElement('div', {'class':'dialog testPrompt'});

  inherit(this, new ModalElement(this.element));

  this.promptID = '0-0';

  this.header = this.element.appendChild(newElement('div', {'class':'header'}));
  this.body = this.element.appendChild(newElement('div', {'class':'body'}));
  this.content = this.body.appendChild(newElement('div', {'class':'content'}));
  this.buttonBar = this.body.appendChild(newElement('div', {'class':'buttonBar'}));

  this.options = [];
  this.hotkeys = {};

  this.keycodes = 
  {
    'A': 65,
    'B': 66,
    'C': 67,
    'D': 68,
    'E': 69,
    'F': 70,
    'G': 71,
    'H': 72,
    'I': 73,
    'J': 74,
    'K': 75,
    'L': 76,
    'M': 77,
    'N': 78,
    'O': 79,
    'P': 80,
    'Q': 81,
    'R': 82,
    'S': 83,
    'T': 84,
    'U': 85,
    'V': 86,
    'W': 87,
    'X': 88,
    'Y': 89,
    'Z': 90,
    'ESC': 27,
    'n0': 48,
    'n1': 49,
    'n2': 50,
    'n3': 51,
    'n4': 52,
    'n5': 53,
    'n6': 54,
    'n7': 55,
    'n8': 56,
    'n9': 57,
    'k0': 96,
    'k1': 97,
    'k2': 98,
    'k3': 99,
    'k4': 100,
    'k5': 101,
    'k6': 102,
    'k7': 103,
    'k8': 104,
    'k9': 105
  }
}

TestPromptButtonDialog.prototype.setContent = function setContent(contentHTML)
{
  this.content.innerHTML = contentHTML;
}

TestPromptButtonDialog.prototype.setHeader = function setHeader(headerHTML)
{
  this.header.innerHTML = headerHTML;
}

TestPromptButtonDialog.prototype.setOptions = function setOptions(data)
{
  clearChildren(this.buttonBar);
  this.hotkeys = {};
  var count = data.length;
  for (var i=0; i<count; i++)
  {
    var option = data[i];
    var caption = option.caption;
    var hotkeys = this.determineHotkeys(option);
    var image = option.image;
    var button = newElement('button', {'buttonValue':i, 'controller':this});
    if (image != '')
      button.appendChild(newElement('img', {'src':('images/' + image)}));
    if (hotkeys.label != undefined && hotkeys.label != '')
      var label = ('(' + hotkeys.label + ') ' + caption);
    else
      var label = caption;
    button.appendChild(newText(label));
    button.onclick = function ()
    {
      this.controller.optionSelected(this.buttonValue);
    }
    this.buttonBar.appendChild(button);
    if (hotkeys.codes != undefined)
    {
      var keycount = hotkeys.codes.length;
      for (var j=0; j<keycount; j++)
        this.hotkeys['code' + hotkeys.codes[j]] = i;
    }
  }
}

TestPromptButtonDialog.prototype.optionSelected = function optionSelected(value)
{
  this.controller.replyToPrompt(this.promptID, value);
  this.hide();
}

TestPromptButtonDialog.prototype.determineHotkeys = function determineHotkey(option)
{
  var hotkeyData = {};
  var hotkey = option.hotkey;
  if (hotkey != '')
  {
    hotkeyData['codes'] = [this.keycodes[hotkey.toUpperCase()]];
    hotkeyData['label'] = hotkey.toUpperCase();
  }
  else
  {
    var caption = option.caption;
    switch (caption)
    {
    case translate('MSG_OK'):
      hotkeyData['codes'] = [this.keycodes['O']];
      break;
    case translate('MSG_YES'):
      hotkeyData['codes'] = [this.keycodes['Y']];
      break;
    case translate('MSG_NO'):
      hotkeyData['codes'] = [this.keycodes['N']];
      break;
    case translate('MSG_CANCEL'):
      hotkeyData['codes'] = [this.keycodes['ESC']];
      break;
    default:
      if (!isNaN(caption))
      {
        hotkeyData['codes'] = [this.keycodes['n' + caption], this.keycodes['k' + caption]];
        hotkeyData['label'] = caption;
      }
    }
  }
  return hotkeyData;
}

TestPromptButtonDialog.prototype.didShow = function didShow()
{
  if (this.areButtonsVisibile = true)
  {
    var buttons = this.buttonBar.getElementsByTagName('button');
    if (buttons.length > 0)
      buttons[0].focus();
  }
  var that = this;
  document.onkeyup = function (event)
  {
    event = event || window.event;
    var code = event.keyCode;
    if (that.hotkeys['code' + code] != undefined)
      that.optionSelected(that.hotkeys['code' + code]);
    return false;
  }
}

TestPromptButtonDialog.prototype.didHide = function didHide()
{
  var buttons = this.buttonBar.getElementsByTagName('button');
  var count = buttons.length;
  for (var i=0; i<count; i++)
    buttons[i].blur();
  document.onkeyup = function () { return true; }
}
