<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/globals.php';
  include_once '../includes/aibridge.class.php';
  
 if (isset($_GET['processID']))
    $processID = $_GET['processID'];
  else
    $processID = 0;

  $stdout = AIBridge::getProcessStatus($processID);
  
  $xml = new XMLDocument($stdout);
  $root = $xml->document_element();
  $xpath = xpath_new_context($root);

  $catalogState = $root->get_attribute('state');

  $components = @ xpath_eval($xpath, '/processStatus');
  $numberOfComponents = count($components->nodeset);

  $failedComponents = @ xpath_eval($xpath, '/processStatus[@state="crashed"]');
  $numberOfFailedComponents = count($failedComponents->nodeset);

  $output = array();
  appendViewHeader($output);
  $output[] = '<script type="text/javascript" src="../js/lib.js"></script>';
  $output[] = '<script type="text/javascript" src="js/catalogStatus.js"></script>';
  $output[] = '</head>';
  $isRunning = ($catalogState === 'running') ? 'true' : 'false';
  $hasCrashedChild = ($numberOfFailedComponents > 0) ? 'true' : 'false';
  $output[] = "<body onload=\"init($isRunning, $hasCrashedChild);\">";
  $output[] = ('<p class="catalogMessage">' . translate('MSG_BUILDING_CATALOG') . ' ...</p>');
  if ($processID == 0)
  {
    $output[] = '<table>';
    $output[] = '<tr class="message">';
    $output[] = '<td>PROCESS ID MISSING</td>';
    $output[] = '</tr>';
    $output[] = '</table>';
  }
  else if ($numberOfComponents > 0)
  {
    $output[] = '<table class="catalog" id="catalogStatus">';
    $output[] = '<thead>';
    $output[] = '<tr>';
    $output[] = ('<th colspan="3">' . translate('MSG_TEST_COMPONENTS') . ':</th>');
    $output[] = '</tr>';
    $output[] = '</thead>';
    $output[] = '<tbody>';
  
    foreach ($components->nodeset as $component)
    {
      $name = $component->get_attribute('component');
      $state = $component->get_attribute('state');
      if ($state == 'completed')
      {
        $img = '../images/status_passed.gif';
        $message = translate('MSG_COMPLETED');
        $rowClass = 'passed';
      }
      else if ($state == 'crashed')
      {
        $img = '../images/status_failed.gif';
        $message = translate('MSG_ABNORMAL_TERMINATION');
        $rowClass = 'failed';
      }
      else if ($state == 'running')
      {
        $img = '../images/status_unknown.gif';
        $message = translate('MSG_LOADING');
        $rowClass = 'loading';
      }
      else
      {
        $img = '../images/status_unknown.gif';
        $message = $state;
        $rowClass = 'unknown';
      }
      $output[] = "<tr class=\"$rowClass\">";
      $output[] = "<td class=\"name\">$name</td>";
      $output[] = "<td class=\"icon\"><img src=\"$img\" alt=\"$message\" /></td>";
      $output[] = "<td class=\"status\">$message</td>";
      $output[] = '</tr>';
    }
  
    $output[] = '</tbody>';
    $output[] = '</table>';
  }
  appendViewFooter($output);
  
  echo implode("\n", $output);
  //*/
?>
