<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/globals.php';
  include_once '../includes/aibridge.class.php';
  
  $diagnosisLog = AIBridge::getDiagnosisLog();

  $xml = new XMLDocument($diagnosisLog);
  $xpath = xpath_new_context($xml->document_element());
  $diagnosisLogRecords = @xpath_eval($xpath, '/diagnosisLogRecord');
  
  outputViewHeader();
  echo '<script type="text/javascript" src="../js/lib.js"></script>';
  echo '<script type="text/javascript" src="js/diagnosisLog.js"></script>';
  echo '</head>';
  echo ('<body onload="init(' . ((DEBUG_MODE === true) ? 'true' : 'false') . ');">');
  echo '<table class="log" id="diagnosisLog">';
  
  if (count($diagnosisLogRecords->nodeset) <= 0)
  {
    echo '<tr class="message">';
    echo ('<td>' . translate('MSG_DIAGNOSIS_LOG') . ' ' . translate('MSG_IS_EMPTY') . '</td>');
    echo '</tr>';
  }
  else
  {
    echo '<thead>';
    echo '<tr>';
    echo '<th class="icon"></th>';
    echo ('<th class="test">' . translate('MSG_DEVICE') . ', ' . translate('MSG_TEST') . '</th>');
    echo ('<th class="number">' . translate('MSG_NUMBER_OF_TIMES_DIAGNOSED') . '</th>');
    echo ('<th class="count">' . translate('MSG_FAILED') . ' ' . translate('MSG_COUNT') . '</th>');
    echo ('<th class="count">' . translate('MSG_PASSED_WITH_WARNINGS') . ' ' . translate('MSG_COUNT') . '</th>');
    echo ('<th class="time">' . translate('MSG_DIAGNOSIS_TIME') . '</th>');
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';
    foreach ($diagnosisLogRecords->nodeset as $record)
    {
      $test = $record->get_attribute('diagnosisCaption');
      $passedCount = $record->get_attribute('passedCount');
      $warningCount = $record->get_attribute('passedWithWarningsCount');
      $failedCount = $record->get_attribute('failedCount');
      $numberOfTests = ($passedCount + $warningCount + $failedCount);
      $time = $record->get_attribute('testTime');
      if ($failedCount > 0)
        $icon = '../images/status_failed.gif';
      else if ($warningCount > 0)
        $icon = '../images/status_warning.gif';
      else
        $icon = '../images/status_passed.gif';
      echo '<tr>';
      echo ('<td class="icon"><img src="' . $icon . '" /></td>');
      echo ('<td class="test">' . $test . '</td>');
      echo ('<td class="number">' . $numberOfTests . '</td>');
      echo ('<td class="count">' . $failedCount . '</td>');
      echo ('<td class="count">' . $warningCount . '</td>');
      echo ('<td class="time">' . $time . '</td>');
      echo '</tr>';
      $diagnosisResults = getDiagnosisResults($record);
      foreach ($diagnosisResults as $diagnosisResult)
      {
        generateErrorTable($diagnosisResult);
        $innerResults = getDiagnosisResults($diagnosisResult);
        if (count($innerResults) > 0)
        {
          foreach ($innerResults as $innerResult)
            generateErrorTable($innerResult);
        }
      }
    }
    echo '</tbody>';
  }
  echo '</table>';
  outputViewFooter();

  // UTILITY FUNCTIONS

  function generateErrorTable($device)
  {
    $deviceCaption = $device->get_attribute('caption');
    $xpath = xpath_new_context($device);
    $errors = @ xpath_eval($xpath, '/error');
    $warnings = @ xpath_eval($xpath, '/warning');
    $timestamp = $device->get_attribute('time');
    if (count($errors->nodeset) > 0 || count($warnings->nodeset) > 0)
    {
      echo '<tr>';
      echo '<td></td>'; // empty icon column
      echo '<td colspan="5" class="errorsAndWarnings">';
      echo (translate('MSG_ERRORS_AND_WARNINGS_FOR') . ' ' . $deviceCaption);
      if ($timestamp != "")
        echo ('<br /><label class="time">' . $timestamp . '</label>');
      echo '<table class="errorsAndWarnings">';
      foreach ($errors->nodeset as $error)
      {
        $caption = $error->get_attribute('caption');
        $code = $error->get_attribute('code');
        if ($code == "")
          $code = $error->get_attribute('errorCode');
        echo '<tr class="error">';
        echo ('<th>' . translate('MSG_ERROR') . ':</th>');
        if ($code != "")
          echo ('<td>' . $code . ': ' . $caption . '</td>');
        else
          echo ('<td>' . $caption . '</td>');
        echo '</tr>';
      }
      foreach ($warnings->nodeset as $warning)
      {
        $caption = $warning->get_attribute('caption');
        echo '<tr class="warning">';
        echo ('<th>' . translate('MSG_WARNING') . ':</th>');
        echo ('<td>' . $caption . '</td>');
        echo '</tr>';
      }
      echo '</table>';
      echo '</td>';
      echo '</tr>';
    }
  }

  function getDiagnosisResults($element)
  {
    $results = array();
    $children = $element->child_nodes();
    foreach ($children as $child)
    {
      if ($child->node_type() == XML_ELEMENT_NODE && $child->node_name() == 'diagnosisResult')
        $results[] = $child;
    }
    return $results;
  }
  //*/
?>
