<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/globals.php';
  include_once '../includes/aibridge.class.php';
  
  $errorLog = AIBridge::getErrorLog();
  
  $xml = new XMLDocument($errorLog);
  $xpath = xpath_new_context($xml->document_element());
  $errorLogRecords = @xpath_eval($xpath, '/errorLogRecord');
  
  outputViewHeader();
  echo '<script type="text/javascript" src="../js/lib.js"></script>';
  echo '<script type="text/javascript" src="js/errorLog.js"></script>';
  echo '</head>';
  echo ('<body onload="init(' . ((DEBUG_MODE === true) ? 'true' : 'false') . ');">');
  echo '<table class="log" id="errorLog">';
  
  if (count($errorLogRecords->nodeset) <= 0)
  {
    echo '<tr class="message">';
    echo ('<td>' . translate('MSG_ERROR_LOG') . ' ' . translate('MSG_IS_EMPTY') . '</td>');
    echo '</tr>';
  }
  else
  {
    echo '<thead>';
    echo '<tr>';
    echo ('<th class="test">' . translate('MSG_DEVICE') . ', ' . translate('MSG_TEST') . '</th>');
    echo ('<th class="description">' . translate('MSG_DESCRIPTION') . '</th>');
    echo ('<th class="repair">' . translate('MSG_REPAIR') . '</th>');
    echo ('<th class="count">' . translate('MSG_FAILED') . ' ' . translate('MSG_COUNT') . '</th>');
    echo ('<th class="code">' . translate('MSG_ERROR_CODE') . '</th>');
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';
    foreach ($errorLogRecords->nodeset as $record)
    {
      $test = $record->get_attribute('testCaption');
      $recordXpath = xpath_new_context($record);
      $errorNodes = @ xpath_eval($recordXpath, '/error');
      foreach ($errorNodes->nodeset as $error)
      {
        $errorXpath = xpath_new_context($error);
        $content = $error->get_content();
        $count = $error->get_attribute('count');
        $code = $error->get_attribute('errorCode');
        $repairActionNodes = @ xpath_eval($errorXpath, '/repairAction');
        if (count($repairActionNodes->nodeset) > 0)
        {
          $repairAction = $repairActionNodes->nodeset[0]->get_content();
          $content = substr($content, 0, strpos($content, $repairAction));
        }
        else
        {
          $repairAction = '';
        }

        if ($content == '')
          $description = $error->get_attribute('caption');
        else
          $description = ($error->get_attribute('caption') . '<br />' .  $content);

        $description = str_replace( "\n", "<br />", $description );
        $repairAction = str_replace( "\n", "<br />", $repairAction );
      
        echo '<tr>';
        echo ('<td class="test">' . $test . '</td>');
        echo ('<td class="description">' . $description . '</td>');
        echo ('<td class="repair">' . $repairAction . '</td>');
        echo ('<td class="count">' . $count . '</td>');
        echo ('<td class="code">' . $code . '</td>');
        echo '</tr>';
      }
    }
    echo '</tbody>';
  }
  
  echo '</table>';
  outputViewFooter();
  //*/
?>
