<?php
  header('Content-type: text/html; charset=utf-8', true);
  header('Cache-control: no-cache', true);
  header('Pragma: no-cache');

  include_once '../includes/globals.php';
  include_once '../includes/aibridge.class.php';
  
  $testLog = AIBridge::getTestLog();

  $xml = new XMLDocument($testLog);
  $xpath = xpath_new_context($xml->document_element());
  $testLogRecords = @ xpath_eval($xpath, '/testLogRecord');
  
  outputViewHeader();
  echo '<script type="text/javascript" src="../js/lib.js"></script>';
  echo '<script type="text/javascript" src="js/testLog.js"></script>';
  echo '</head>';
  echo ('<body onload="init(' . ((DEBUG_MODE === true) ? 'true' : 'false') . ');">');
  echo '<table class="log" id="testLog">';
  
  if (count($testLogRecords->nodeset) <= 0)
  {
    echo '<tr class="message">';
    echo ('<td>' . translate('MSG_TEST_LOG') . ' ' . translate('MSG_IS_EMPTY') . '</td>');
    echo '</tr>';
  }
  else
  {
    echo '<thead>';
    echo '<tr>';
    echo '<th class="icon"></th>';
    echo ('<th class="test">' . translate('MSG_DEVICE') . ', ' . translate('MSG_TEST') . '</th>');
    echo ('<th class="number">' . translate('MSG_NUMBER_OF_TIMES_TESTED') . '</th>');
    echo ('<th class="failed">' . translate('MSG_FAILED') . ' ' . translate('MSG_COUNT') . '</th>');
    echo ('<th class="time">' . translate('MSG_TEST_TIME') . '</th>');
    echo ('<th class="last">' . translate('MSG_LAST_COMPLETION') . '</th>');
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';
    foreach ($testLogRecords->nodeset as $record)
    {
      $test = $record->get_attribute('testCaption');
      $testTime = $record->get_attribute('testTime');
      $passedCount = $record->get_attribute('passedCount'); 
      $failedCount = $record->get_attribute('failedCount');
      $recordXpath = xpath_new_context($record);
      $numberOfTimesTested = $passedCount + $failedCount;
      $testCompletionNodes = @ xpath_eval($recordXpath, '/testCompletion');
      $numberOfTestCompletions = count($testCompletionNodes->nodeset);
      if ($numberOfTestCompletions <= 0)
      {
        $testCompletionNodes = @ xpath_eval($recordXpath, '/testCompletetion');
        $numberOfTestCompletions = count($testCompletionNodes->nodeset);
      }
      if ($numberOfTestCompletions <= 0)
  {
        $lastCompletion = '';
        $src = '../images/status_unknown.gif';
      }
      else
      {
        $lastTestCompletion = $testCompletionNodes->nodeset[$numberOfTestCompletions - 1];
        $lastCompletion = $lastTestCompletion->get_attribute('completionTime');
        $result = $lastTestCompletion->get_attribute('result');
        if ($result == 'passed')
        {
          $src = '../images/status_passed.gif';
          $alt = translate('MSG_PASSED');
        }
        else if ($result == 'failed')
        {
          $src = '../images/status_failed.gif';
          $alt = translate('MSG_FAILED');
        }
        else
        {
          $src = '../images/status_unknown.gif';
          $alt = translate('MSG_UNKNOWN');
        }
      }
      
      echo '<tr>';
      echo ('<td class="icon"><img alt="' . $alt . '" src="' . $src . '" /></td>');
      echo ('<td class="test">' . $test . '</td>');
      echo ('<td class="number">' . $numberOfTimesTested . '</td>');
      echo ('<td class="failed">' . $failedCount . '</td>');
      echo ('<td class="time">' . $testTime . '</td>');
      echo ('<td class="last">' . $lastCompletion . '</td>');
      echo '</tr>';
    }
    echo '</tbody>';
  }

  echo '</table>';
  outputViewFooter();
  //*/
?>
