<?php
    // Linux PHP File.

    //seems cleansweep has not passed the webapp name in - hard code now
    $webapp = 'ACU_XE';
    $webappNameLen = strlen($webapp);
    $bldDir = '/opt/compaq/cpqacuxe/bld';
    $fixedLocksDir = '/var/opt/compaq/locks/';
    $ipcExecutable = $bldDir . '/ipcelmclient';
    $htmlHome = $bldDir . '/../HTML/';
    $headerVar = "HTTP_{$webapp}_PROP";
    $original_uri = $_SERVER['REDIRECT_SCRIPT_URL'];
    if (!isset($_SERVER[$headerVar]) ||
        !isset($_SERVER["HTTP_HPSMH_AUTHLEVEL"]))
    {
       $queryStr = $_SERVER['QUERY_STRING'];
       $new_q = str_replace('=', '%<xx>', $queryStr);
       $new_q = str_replace('&', '%<yy>', $new_q);
       if ($new_q) $new_q = '&RedirectQueryString=' . $new_q;
       $new_uri = 'https://' . $_SERVER['HTTP_HOST'] . "/cpqlogin.php" . '?RedirectUrl=' . $original_uri . $new_q;
       header("Location: $new_uri");
       exit;
    }
    if (strpos($original_uri,"/ACU-XE/") !== 0)
    {
        header("HTTP/1.1 404 Not Found");
        exit;
    }

    // set infinite time-out for the php script. The default is 30 secs and may be too little
    // for generating dynamic content.
    set_time_limit( 0 ); 

    $document_root = $_SERVER['DOCUMENT_ROOT'];
    $http_accept_lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
    if($http_accept_lang == "" )
    {
       $http_accept_lang = "en";
    }
    $path_translated = $htmlHome . substr($original_uri, $webappNameLen + 2);
    $method = $_SERVER['REQUEST_METHOD'];
    
   
    //if($fHandle = fopen("c:\\temp\\debug.txt", 'a'))
    //{
    //  fwrite($fHandle, $original_uri . "\n"); 
    //  fwrite($fHandle, $path_translated . "\n");         
    //  fclose($fHandle);    
    //}

    // Cache-control. Default is to cache the files but have the browser check for new versions every time
    $cache_sec = 0;
    // Cache images for two weeks. 
    $image_cache_sec = 1209600;
    
    // We set the mime type on every request. Needed for Firefox to present data correctly.
    $mimeType = "text/html";
    $fileExt = strtolower(substr(($ext = strrchr($path_translated, '.')) !== false ? $ext : '', 1));
    switch ($fileExt)
    {
    case "png":
       $cache_sec = $image_cache_sec;
       $mimeType = "image/png";
       break;
    case "gif":
       $cache_sec = $image_cache_sec;
       $mimeType = "image/gif";
       break;
    case "js":
       $mimeType = "application/x-javascript";
       break;
    case "css":
       $mimeType = "text/css";
       break;
    case "xml":
       $mimeType = "text/xml";
       break; 
    case "xsl":
       $mimeType = "text/xml";
       break;
    case "jpg":
       $cache_sec = $image_cache_sec;
       $mimeType = "image/jpeg";
       break;
    case "zip":
       $mimeType = "application/octet-stream";
       break;
    default:
       break;
    }

   /* 1. form processing - go thru each post and construct name=value pairs */
   // We just use the raw_post_data since it does not eliminate duplicate keys. $_POST is an associative 
   // array which will only keep unique keys in the array. */
   $data = "";
   if( $method == "POST" )
   {
      // The php://input stream will get raw post data from the request
      $data = file_get_contents( "php://input" );
   }
   else
   {
      $data = "";
      if( isset( $_SERVER['QUERY_STRING'] ) )
      {
         $data = $_SERVER['QUERY_STRING']; 
      }

      if (file_exists($path_translated) == TRUE)
      {
         // Send MIME-type
         header("Content-Type: " . $mimeType);   
         
         $fileModTime = gmdate("r", filemtime($path_translated)); // RFC 2822 formatted date
         // Check the If-modified-since header
         $headers = getallheaders();
         if(isset($headers["If-Modified-Since"]))
         {            
            if (substr($headers["If-Modified-Since"],0,25) == substr($fileModTime,0,25))
            {
               // The file has not been modified
               header("HTTP/1.1 304 Not Modified");
               exit;
            }
         }
         $fileSize = filesize($path_translated);
         header("Content-Length: " . $fileSize);
         // Send cache control headers
         header("Cache-Control: max-age=" . $cache_sec . ", public"); // HTTP/1.1
         $cache_exp_date = gmdate("r", time() + $cache_sec); // RFC 2822 formatted date
         header("Expires: " . $cache_exp_date); // Date in the future
         
         // Send last modified date  
         header("Last-Modified: " . $fileModTime);
         // Send file contents
         readfile($path_translated);
         return;
      }
   }
   if ( $data == "")
      $data = "ACU_LANG=" . $http_accept_lang;
   else
      $data = $data . "&ACU_LANG=" . $http_accept_lang;
   // Browser type
   $data = $data . "&ACU_USER_AGENT=" . $_SERVER['HTTP_USER_AGENT'];
   
   $http_charset_str = "";
   if ($mimeType == "application/x-javascript")
   {
      if ($http_accept_lang == "ja")
         $http_charset_str = "; charset=x-sjis";
      else
         $http_charset_str = "; charset=ISO-8859-1";
   }
   
   $adminFlag = "0";
   if ( $_SERVER["HTTP_HPSMH_AUTHLEVEL"] == "4" )
   {
      $adminFlag = "1";
   }
   
   // Send MIME-type
   header("Content-Type: " . $mimeType . $http_charset_str);   

   /* 2. execute command - with post data as command line arg and capture output into output_array */
   $command = $ipcExecutable . " ACU-XE " . "ACU-XE " . $original_uri . " \"" . $path_translated . "\" \"" . $http_accept_lang . "\" " . $method . " " . $adminFlag . " \"" . $data . "\"";

   // These requests are not cached
   header("Cache-Control: no-store");
   header("Expires: " . gmdate("r", time() - 3600)); // Date in the past
   
   putenv("ACUXE_LOCK_FILES_DIR=$fixedLocksDir");
   passthru($command);
   //echo($command);
?>
