<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Check for filenames
  if (!isset($_GET['leftFile']) || !isset($_GET['rightFile']))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Must Specify leftFile and rightFile');
    die(Rosetta::arrayToJSON($outputArray));
  }
  
  // Call AI
  $stdout = AIBridge::compareSurveys($_GET['leftFile'], $_GET['rightFile']);
 
  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
    $filesMatch = $document->get_attribute('filesMatch'); // Check to see if files matched
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  // If Files match, output 0
  if ($filesMatch)
  {
    exit('0');
  }
  else
  {
    // Get results of the compare
    AIBridge::changeComparisonPermissions();
    $leftCompare  = file_get_contents(WRITE_DIRECTORY . 'surveycompare.left.xml');
    $rightCompare = file_get_contents(WRITE_DIRECTORY . 'surveycompare.right.xml');
  
    // Change results into XMLDocuments
    $leftXML  = new XMLDocument($leftCompare);
    $rightXML = new XMLDocument($rightCompare);
  
    // Setup XPath Contexts
    $leftXpath  = xpath_new_context($leftXML->document_element());
    $rightXpath = xpath_new_context($rightXML->document_element());
  
    // Get Categories (Left file used as template)
    $leftCategoryNodes = xpath_eval($leftXpath, '//category');
  
    // Output comparison results in JSON format
    exit(Rosetta::arrayToJSON(buildCompareConfig()));
  }
  
  // Create JSON for #compareConfigTable
  function buildCompareConfig()
  {
    global $leftCategoryNodes;
    global $rightXpath;
    global $key;

    $key = array(
      'leftFileName'  => 'l',
      'rightFileName' => 'r',
      'categories'    => 'c',
      'name'          => 'n',
      'caption'       => 'c',
      'sections'      => 's',
      'left'          => 'l',
      'right'         => 'r',
      'isAdvanced'    => 'a',
      'isChanged'     => 'c',
      'entries'       => 'e',
      'depth'         => 'd',
      'isHex'         => 'h');
    $comparison = array();
    $comparison['key'] = $key;
    $comparison['data'] = array();
    $comparison['data'][$key['leftFileName']]  = $_GET['leftFileName'];
    $comparison['data'][$key['rightFileName']] = $_GET['rightFileName'];
    $comparison['data'][$key['categories']] = array();
    // Iterate through categories
    for($catNum=0; $catNum<count($leftCategoryNodes->nodeset); $catNum++)
    {
      // Get Left Category[$i]
      $leftCategory = $leftCategoryNodes->nodeset[$catNum];
      // Get right category with MATCHING name (ensures that tables columns are in sync)
      $rightCategoryNodes = xpath_eval($rightXpath, "//category[@name='".$leftCategory->get_attribute('name')."']");
      $rightCategory = $rightCategoryNodes->nodeset[0];

      $category = array();
      $category[$key['name']] = $leftCategory->get_attribute('name');
      $category[$key['caption']] = $leftCategory->get_attribute('caption');
      $category[$key['sections']] = array();
      
      // Get children of left and right categories
      $leftCategoryXpath = xpath_new_context($leftCategory);
      $rightCategoryXpath = xpath_new_context($rightCategory);
      $leftCategoryChildren = xpath_eval($leftCategoryXpath, '/child::node()');
      $rightCategoryChildren = xpath_eval($rightCategoryXpath, '/child::node()');
      // Iterate through children to create table rows (use left children as template)
      for($i=0; $i<count($leftCategoryChildren->nodeset); $i++)
      {
        $leftChild = $leftCategoryChildren->nodeset[$i];
        $rightChild = $rightCategoryChildren->nodeset[$i];
        $sublevel = 0; // Current sublevel (tree depth)
        // Make sure both children are XML_ELEMENT_NODEs
        if ($leftChild->node_type() == XML_ELEMENT_NODE && $rightChild->node_type() == XML_ELEMENT_NODE)
        {
          $category[$key['sections']][] = buildSection($leftChild, $rightChild, $sublevel);
        }
      }
      $comparison['data'][$key['categories']][] = $category;
    }
    return $comparison;
  }

  // Create JSON for sections
  function buildSection($leftChild, $rightChild, $sublevel, $advanced=false)
  {
    global $key;
    $entry = array();
    // Set up XPath
    $leftChildXpath = xpath_new_context($leftChild);
    $rightChildXpath = xpath_new_context($rightChild);

    $leftChildren = xpath_eval($leftChildXpath, '/child::node()');
    $rightChildren = xpath_eval($rightChildXpath, '/child::node()');
    // Get attributes
    $leftCaption = str_replace('"', '\\"', $leftChild->get_attribute('caption'));
    $rightCaption = str_replace('"', '\\"', $rightChild->get_attribute('caption'));

    $leftValue = str_replace('"', '\\"', $leftChild->get_attribute('value'));
    $rightValue = str_replace('"', '\\"', $rightChild->get_attribute('value'));

    $leftDescription = str_replace('"', '\\"', $leftChild->get_attribute('description'));
    $rightDescription = str_replace('"', '\\"', $rightChild->get_attribute('description'));

    // Get extra info from left child ONLY (template)
    $testOnly = $leftChild->get_attribute('testOnly');
    $tagname = $leftChild->tagname;

    // Get Changed status from right child ONLY
    $changedValue = ($rightChild->get_attribute('compareResult') == 'changed') ? true : false;
    $advancedValue = ($advanced || $leftChild->get_attribute('techDetail') == '1') ? true : false;
    $hexDataValue = ($leftChild->get_attribute('hexData') == '1') ? true : false;

    // Make sure this element is something we want displayed
    if ($testOnly != '1' && ($tagname == 'device' || $tagname == 'structure' || $tagname == 'property'))
    {
      if ($sublevel == 0) // Child of Category, should be a header
      {
        // Set up header subtitles if needed
        $leftSubtitle = ($leftValue != '' && $leftCaption != $leftValue) ? ' - '.$leftValue : (($leftDescription != '' && $leftCaption != $leftDescription) ? ' - '.$leftDescription : '');
        $rightSubtitle = ($rightValue != '' && $rightCaption != $rightValue) ? ' - '.$rightValue : (($rightDescription != '' && $rightCaption != $rightDescription) ? ' - '.$rightDescription : '');

        // Check to see if this header contains any children that are changed. If so, this header will have the change class as well
        $changedChildren = xpath_eval($rightChildXpath, "/child::node()[@compareResult='changed']");
        $changedValue = (count($changedChildren->nodeset) > 0) ? true : $changedValue;

        //$entry[$key['left']] = $leftCaption.$leftSubtitle;
        //$entry[$key['right']] = $rightCaption.$rightSubtitle;
        $entry[$key['name']] = $leftCaption.$leftSubtitle;
        $entry[$key['isAdvanced']] = $advancedValue;
        $entry[$key['isChanged']] = $changedValue;
        $entry[$key['entries']] = array();
      }
      else
      {
        $trueLeftValue = ($leftValue != '') ? $leftValue : (($leftDescription != '') ? $leftDescription : '');
        $trueRightValue = ($rightValue != '') ? $rightValue : (($rightDescription != '') ? $rightDescription : '');
        
        //$entry[$key['leftCaption']] = $leftCaption;
        //$entry[$key['leftValue']] = $trueLeftValue;
        $entry[$key['name']] = $leftCaption;
        $entry[$key['left']] = $trueLeftValue;
        //$entry[$key['rightCaption']] = $rightCaption;
        //$entry[$key['rightValue']] = $trueRightValue;
        $entry[$key['right']] = $trueRightValue;
        $entry[$key['depth']] = $sublevel;
        $entry[$key['isHex']] = $hexDataValue;
        $entry[$key['isAdvanced']] = $advancedValue;
        $entry[$key['isChanged']] = $changedValue;
      }
      // If the left child (template) has children, we will iterate through this function for each one, adjusting $sublevel accordingly
      for($i=0; $i<count($leftChildren->nodeset); $i++)
      {
        $leftNestedChild = $leftChildren->nodeset[$i];
        $rightNestedChild = $rightChildren->nodeset[$i];
        // Make sure both children are XML_ELEMENT_NODEs
        if ($leftNestedChild->node_type() == XML_ELEMENT_NODE && $rightNestedChild->node_type() == XML_ELEMENT_NODE)
        {
          $nestedAdvanced = false;
          // If this element is advanced, all of its children need to be marked advanced as well so they are hidden or visible along with their parent
          $nestedAdvanced = ($advanced || $leftChild->get_attribute('techDetail')=='1') ? true : false;
          $sublevel++;
          $entry[$key['entries']][] = buildSection($leftNestedChild, $rightNestedChild, $sublevel, $nestedAdvanced);
          $sublevel--; // put sublevel back to original number on return
        }
      }
    }
    return $entry;
  }
  //*/
?>
