<?php
  header('Content-type: text/plain', true);

  include_once '../includes/aibridge.class.php';
  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Check for variables
  if (!requiredParameters('processID'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Process ID is missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  
  // Call AI
  $stdout = AIBridge::getProcessResult($_GET['processID']);

  // Try to make stdout into a XMLDocument
  $xml = new XMLDocument($stdout);
  if ($xml)
  {
    $document = $xml->document_element();
    if ($document->tagname() == 'error') // If AI returned an error:
    {
      $outputArray = array(
        'name'  => 'AI Error',
        'value' => $document->get_content());
      die(Rosetta::arrayToJSON($outputArray));
    }
  }
  else
  {
    $outputArray = array(
      'name'  => 'XML Error',
      'value' => $stdout);
    die(Rosetta::arrayToJSON($outputArray));
  }

  $key = array(
    'component'   => 'c',
    'devices'     => 'd',
    'caption'     => 'c',
    'tests'       => 't',
    'description' => 'd',
    'parameters'  => 'p'
    );
  $catalogResult = array();
  $catalogResult['key'] = $key;
  $catalogResult['data'] = array();

  $xpath = xpath_new_context($document);
  $catResults = @ xpath_eval($xpath, '/diagOutput/catResult');
  //$numberOfCatResults = count($catResults->nodeset);
  foreach ($catResults->nodeset as $catResult)
  {
    $catResultArray = array();
    $catResultArray[$key['component']] = $catResult->get_attribute('component');
    $catResultArray[$key['devices']] = array();
    $xpath = xpath_new_context($catResult);
    $devices = @ xpath_eval($xpath, '/device');
    //$numberOfDevices = count($devices->nodeset);
    foreach ($devices->nodeset as $device)
    {
      $deviceArray = array();
      $deviceArray[$key['caption']] = $device->get_attribute('caption');
      $deviceArray[$key['tests']] = array();
      $deviceXpath = xpath_new_context($device);
      $tests = @ xpath_eval($deviceXpath, '/test');
      //$numberOfTests = count($tests->nodeset);
      foreach ($tests->nodeset as $test)
      {
        $testArray = array();
        $testArray[$key['caption']] = $test->get_attribute('caption');
        $testArray[$key['description']] = $test->get_attribute('description');
        $testArray[$key['parameters']] = array();
        $testXpath = xpath_new_context($test);
        $parameters = @ xpath_eval($testXpath, '/parameter');
        //$numberOfParameters = count($parameters->nodeset);
        foreach ($parameters->nodeset as $parameter)
        {
          $parameterArray = array();
          $parameterArray[$key['caption']] = $parameter->get_attribute('caption');
          $parameterArray[$key['description']] = $parameter->get_attribute('description');
          $testArray[$key['parameters']][] = $parameterArray;
        }
        $deviceArray[$key['tests']][] = $testArray;
      }
      $catResultArray[$key['devices']][] = $deviceArray;
    }
    $catalogResult['data'][] = $catResultArray;
  }

  //print_r($catalogResult);
  exit(Rosetta::arrayToJSON($catalogResult));
  //*/
?>
