<?php
  header('Content-type: text/plain', true);

  include_once '../includes/globals.php';
  include_once '../includes/rosetta.class.php';

  // Check for ID result
  if (!file_exists(IDRESULT_PATH))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'idResult missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  
  // Make ID result into a XMLDocument
  $xml = new XMLDocument(file_get_contents(IDRESULT_PATH));
  $xpath = xpath_new_context($xml->document_element());
  $categories = @ xpath_eval($xpath, '/diagOutput/category');
  
  // Factory mode adds factory tests and destructive tests
  if (IS_FACTORY)
    $testEval = ''; // factory mode uses all tests
  else if (ADVANCED_MODE)
    $testEval = '[@fieldtest="1" and (not(@package) or @package="0")]'; // advanced mode uses all field tests
  else
    $testEval = '[@fieldtest="1" and @destructive="0" and (not(@package) or @package="0")]'; // field mode uses non-destructire field tests

  $json = array();
  $key = array(
    'name'          => 'n',
    'component'     => 'C',
    'caption'       => 'c',
    'devices'       => 'd',
    'tests'         => 't',
    'parameters'    => 'p',
    'description'   => 'd',
    'isInteractive' => 'i',
    'needsMedia'    => 'm',
    'isAdvanced'    => 'a',
    'isRomTest'     => 'r',
    'type'          => 't',
    'value'         => 'v',
    'options'       => 'o',
    'min'           => 'm',
    'max'           => 'x');
  $json['key'] = $key;
  $json['data'] = array();
  foreach ($categories->nodeset as $category)
  {
    $xpath = xpath_new_context($category);
    $devices = @ xpath_eval($xpath, ('/device[test' . $testEval . ']'));
    if (count($devices->nodeset) > 0)
    {
      $categoryArray = array();
      $categoryArray[$key['name']]    = $category->get_attribute('name');
      $categoryArray[$key['caption']] = $category->get_attribute('caption');
      $categoryArray[$key['devices']] = array();
      foreach ($devices->nodeset as $device)
      {
        $xpath = xpath_new_context($device);
        $tests = @ xpath_eval($xpath, ('/test' . $testEval));
        $deviceArray = array();
        $deviceArray[$key['name']]        = $device->get_attribute('name');
        $deviceArray[$key['component']]   = $device->get_attribute('component');
        $deviceArray[$key['caption']]     = $device->get_attribute('caption');
        $deviceArray[$key['description']] = $device->get_attribute('description');
        $deviceArray[$key['tests']]       = array();
        foreach ($tests->nodeset as $test)
        {
          $xpath = xpath_new_context($test);
          $parameters = @ xpath_eval($xpath, '/parameter');
          $testArray = array();
          $testArray[$key['name']]          = $test->get_attribute('name');
          $testArray[$key['caption']]       = $test->get_attribute('caption');
          $testArray[$key['description']]   = $test->get_attribute('description');
          $testArray[$key['isInteractive']] = ($test->get_attribute('interactive') == 1)   ? true : false;
          $testArray[$key['needsMedia']]    = ($test->get_attribute('requiresMedia') == 1) ? true : false;
          $testArray[$key['isAdvanced']]    = ($test->get_attribute('destructive') == 1)   ? true : false;
          $testArray[$key['isRomTest']]     = ($test->get_attribute('romTest') == 1)      ? true : false;
          $testArray[$key['parameters']]    = array();
          foreach ($parameters->nodeset as $parameter)
          {
            $parameterArray = array();
            $parameterArray[$key['name']] = $parameter->get_attribute('name');
            $parameterArray[$key['caption']] = $parameter->get_attribute('caption');
            $parameterArray[$key['description']] = $parameter->get_attribute('description');
            $parameterArray[$key['type']] = strtolower($parameter->get_attribute('type'));
            $defaultValue = $parameter->get_attribute('defaultValue');
            
            switch ($parameterArray[$key['type']])
            {
            case 'bool':
              $parameterArray[$key['value']] = ($defaultValue == '1' || $defaultValue == 'on') ? true : false;
              break;
            case 'enum':
              $xpath = xpath_new_context($parameter);
              $options = @ xpath_eval($xpath, '/TextItem');
              $numberOfOptions = count($options->nodeset);
              $parameterArray[$key['value']] = 0;
              $parameterArray[$key['options']] = array();
              for ($i=0; $i<$numberOfOptions; $i++)
              {
                $option = $options->nodeset[$i];
                $optionArray = array();
                $optionArray[$key['name']]    = $option->get_attribute('name');
                $optionArray[$key['caption']] = $option->get_attribute('caption');
                $parameterArray[$key['options']][] = $optionArray;
                if ($optionArray[$key['name']] == $defaultValue)
                  $parameterArray[$key['value']] = $i;
              }
              break;
            case 'int':
              if ($parameter->has_attribute('min'))
                $parameterArray[$key['min']] = $parameter->get_attribute('min');
              if ($parameter->has_attribute('max'))
                $parameterArray[$key['max']] = $parameter->get_attribute('max');
            default:
              $parameterArray[$key['value']] = $defaultValue;
              
            }
            
            $testArray[$key['parameters']][] = $parameterArray;
         }
          $deviceArray[$key['tests']][] = $testArray;
        }
        $categoryArray[$key['devices']][] = $deviceArray;
      }
      $json['data'][] = $categoryArray;
    }
  }
  exit(Rosetta::arrayToJSON($json));
    
    /*if (count($devices->nodeset) > 0 && count($containedTests->nodeset) > 0)

  }


  $deviceNodes = xpath_eval($xpath, '/diagOutput/category/device');
  // Setup tests array
  $tests = array();
  $key = array(
    'interactiveOnly'  => 2,
    'mixedInteractive' => 1,
    'unattendedOnly'   => 0,
    'name'             => 'n',
    'caption'          => 'c',
    'isBusy'           => 'b',
    'description'      => 'd',
    'interactivity'    => 'i',
    'needsMedia'       => 'm');
  $tests['key']  = $key;
  $tests['data'] = array();
  // Get information on each device
  foreach($deviceNodes->nodeset as $device)
  {
    $deviceXpath   = xpath_new_context($device);
    // Get all of the interactive tests
    $interactiveTests = xpath_eval($deviceXpath, '/test[@' . $mode . '="1" and @fieldtest="1" and @interactive="1"]');
    if (count($interactiveTests->nodeset) <= 0)
      $interactiveTests = xpath_eval($deviceXpath, '/test[@' . $mode . '="1" and @fieldtest="1" and @interactive="1" and (../@component!="cdm" or @package="1")]');
    // Get all of the unattended tests
    $unattendedTests = xpath_eval($deviceXpath, '/test[@' . $mode . '="1" and @fieldtest="1" and @interactive="0"]');
    if (count($unattendedTests->nodeset) <= 0)
      $unattendedTests = xpath_eval($deviceXpath, '/test[@' . $mode . '="1" and @fieldtest="1" and @interactive="0" and (../@component!="cdm" or @package="1")]');
    // Determine how many of each type of test exist in this device
    $numberOfInteractiveTests = count($interactiveTests->nodeset);
    $numberOfUnattendedTests  = count($unattendedTests->nodeset);
    $testCount = $numberOfInteractiveTests + $numberOfUnattendedTests;
    // Only continue if the device contains appropriate tests
    if ($testCount > 0)
    {
      $deviceArray = array();
      $deviceArray[$key['name']]    = $device->get_attribute('name');
      $deviceArray[$key['caption']] = $device->get_attribute('caption');
      $deviceArray[$key['isBusy']]  = 
        ($device->get_attribute('listWithoutTests') == '1') 
        ? true 
        : false;
      // Description depends on isBusy status
      $deviceArray[$key['description']] = 
        ($deviceArray[$key['isBusy']])
        ? $device->get_attribute('listWithoutTestsCaption')
        : $device->get_attribute('description');
      // Set the interactivity level based on the numbers of interactive and unattended tests:
      //   Both Interactive and Unattended tests = mixedInteractive
      //   Only Interactive tests = interactiveOnly
      //   Only Unattended tests = unattendedOnly
      if ($numberOfInteractiveTests > 0 && $numberOfUnattendedTests > 0)
        $deviceArray[$key['interactivity']] = $key['mixedInteractive'];
      else if ($numberOfInteractiveTests > 0)
        $deviceArray[$key['interactivity']] = $key['interactiveOnly'];
      else if ($numberOfUnattendedTests > 0)
        $deviceArray[$key['interactivity']] = $key['unattendedOnly'];
      else
        $deviceArray[$key['interactivity']] = -1;
      // Check to see if the device has any tests that require media
      $testsNeedingMedia = xpath_eval($deviceXpath, '/test[@requiresMedia="1"]');
      if (count($testsNeedingMedia->nodeset) > 0)
        $deviceArray[$key['needsMedia']] = true;
      else
        $deviceArray[$key['needsMedia']] = false;
      $tests['data'][] = $deviceArray;
    } 
  }
  exit(Rosetta::arrayToJSON($tests));

//*

  function buildCustomTestList(&$testList, &$testParameterDivs, &$testParameterObjects, &$mediaNeeded, &$isBusy)
  {
    global $xpath;
    $categories = xpath_eval($xpath, "/diagOutput/category");
    // Factory mode adds factory tests and destructive tests
    if (DEPLOYMENT_MODE == "factory")
      $testEval = CUSTOM_TEST_EVAL_FACTORY;
    // Field Advanced mode adds destructive tests
    else if (isset($_REQUEST["advanced"]) && $_REQUEST["advanced"] == "on")
      $testEval = CUSTOM_TEST_EVAL_FIELD_ADVANCED;
    // Field Normal mode removes destructive tests
    else
      $testEval = CUSTOM_TEST_EVAL_FIELD;

    for($c=0; $c<count($categories->nodeset); $c++)
    {
      $category = $categories->nodeset[$c];
      $categoryXpath = xpath_new_context($category);
      $devices = xpath_eval($categoryXpath, "/device[test[".$testEval."]]");
      $containedTests = xpath_eval($categoryXpath, "/device/test[".$testEval."]");
      if (count($devices->nodeset) > 0 && count($containedTests->nodeset) > 0)
      {
        $testList .= "<li class=\"ui_treeListBranch\">".$category->get_attribute("caption")."\n";
        $testList .= "<ul>\n";
        for($d=0; $d<count($devices->nodeset); $d++)
        {
          $device = $devices->nodeset[$d];
          $deviceXpath = xpath_new_context($device);
          $tests = xpath_eval($deviceXpath, "/test[".$testEval."]");
          if (count($tests->nodeset) > 0)
          {
            $testList .= "<li class=\"ui_treeListBranch\">".$device->get_attribute("caption")."\n";
            $testList .= "<ul>\n";
            for($t=0; $t<count($tests->nodeset); $t++)
            {
              $test = $tests->nodeset[$t];
              $testID = "testID_".$c."_".$d."_".$t;
              $testXpath = xpath_new_context($test);
              $parameters = xpath_eval($testXpath, "/parameter");
              $className = "";
              $suffix = "";
              if ($test->get_attribute("interactive") == "1")
              {
                $className .= " interactive";
                $suffix = " (".translate("MSG_INTERACTIVE").")";
              }

              if ($test->get_attribute("destructive") == "1")
              {
                $className .= " destructive";
                $suffix = " (".translate("MSG_ADVANCED").")";
              }
               
              $testList .= "<li class=\"ui_treeListLeaf ui_value_".$testID.$className."\" onclick=\"Frontend.selectCustomTestListLeaf(this);\" id=\"".$testID."\">".$test->get_attribute("caption").$suffix."</li>\n";
              buildCustomTestParameters($test, $device, $testID, $testParameterDivs, $testParameterObjects);
            }
            $testList .= "</ul>\n";
            $testList .= "</li>\n";
          }
        }
        $testList .= "</ul>\n";
        $testList .= "</li>\n";
      }
    }
  }

  function buildCustomTestParameters(&$test, &$device, $testID, &$testParameterDivs, &$testParameterObjects)
  {
    $testXpath = xpath_new_context($test);
    $parameters = xpath_eval($testXpath, "/parameter");
    $testCaption = $test->get_attribute("caption");
    $testDescription = $test->get_attribute("description");
    $deviceCaption = $device->get_attribute("caption");
    $deviceDescription = $device->get_attribute("description");
    $testSuffix = "";
    if ($test->get_attribute("interactive") == "1")
      $testSuffix = " <span class=\"interactive\">(".translate("MSG_INTERACTIVE").")</span>";
    if ($test->get_attribute("destructive") == "1")
      $testSuffix = " <span class=\"destructive\">(".translate("MSG_ADVANCED").")</span>";
    $testParameterDivs .= "<div id=\"".$testID."_parameters\" class=\"customTestParameters ui_hidden\">\n";
    $testParameterDivs .= "<p class=\"customTestName\">".$testCaption.$testSuffix."</p>\n";
    $testParameterDivs .= "<p>".$deviceCaption." - ".$deviceDescription."</p>\n";
    $testParameterDivs .= "<p><i>".$testDescription."</i></p>\n";
    if (count($parameters->nodeset) > 0)
    {
      $testParameterDivs .= "<table id=\"".$testID."_fields\" class=\"customTestParameterFields\">\n";
      foreach($parameters->nodeset as $parameter)
      {
        $parameterName = $parameter->get_attribute("name");
        $parameterCaption = $parameter->get_attribute("caption");
        $parameterDescription = $parameter->get_attribute("description");
        $parameterType = $parameter->get_attribute("type");
        $parameterDefaultValue = $parameter->get_attribute("defaultValue");
        $parameterID = $testID."#".$parameterName;
        $testParameterDivs .= "<tr title=\"".$parameterDescription."\">\n";
        $testParameterDivs .= "<th>".$parameterCaption.":</th>\n";
        $testParameterDivs .= "<td>";
        switch($parameterType)
        {
        case ("bool"):
          $checked = "";
          if ($parameter->get_attribute("defaultValue") == "1" || $parameter->get_attribute("defaultValue") == "on")
            $checked = "checked=\"checked\"";
          $testParameterDivs .= "<input type=\"checkbox\" id=\"".$parameterID."\" ".$checked." />";
          break;
        case ("ENUM"):
          $enumXpath = xpath_new_context($parameter);
          $enumOptions = xpath_eval($enumXpath, "/TextItem");
          $testParameterDivs .= "\n<select id=\"".$parameterID."\" size=\"1\">\n";
          foreach($enumOptions->nodeset as $enumOption)
          {
            $enumOptionName = $enumOption->get_attribute("name");
            $enumOptionCaption = $enumOption->get_attribute("caption");
            $selected = "";
            if ($parameterDefaultValue == $enumOptionName)
              $selected = "selected=\"selected\"";
            $testParameterDivs .= "<option value=\"".$enumOptionName."\" ".$selected.">".$enumOptionCaption."</option>\n";
          }
          $testParameterDivs .= "</select>\n";
          break;
        case ("int"):
        case ("string"):
        case ("dword"):
          $testParameterDivs .= "<input type=\"text\" id=\"".$parameterID."\" value=\"".$parameterDefaultValue."\" />";
          break;
        }

        $testParameterDivs .= "</td>\n";
        $testParameterDivs .= "</tr>\n";
      }
      $testParameterDivs .= "</table>\n";
    }
    else
    {
      $testParameterDivs .= "<p class=\"noTestParameters\">".translate("MSG_NO")." ".translate("MSG_TEST_PARAMETERS")."</p>\n";
    }

    $testParameterDivs .= "</div>\n";
  }
//*/
?>
