<?php
header('Content-type: text/html', true);

define('IS_ATTACHMENT', (isset($_GET['attachment']) && $_GET['attachment'] == 1));

include_once '../includes/aibridge.class.php';
include_once '../includes/globals.php';
include_once '../includes/rosetta.class.php';
include_once '../includes/filesaver.class.php';
include_once '../includes/fileprompter.class.php';

// Check for required parameters
if (IS_ATTACHMENT)
{
  if (!requiredParameters('filename'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  FilePrompter::prepareForSaving();
}
else
{
  if (!requiredParameters('devicePath', 'filename'))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'Some required parameters are missing');
    die(Rosetta::arrayToJSON($outputArray));
  }
  // See if file exists
  if ((!isset($_GET['overwrite']) || $_GET['overwrite'] != 'yes') &&
      FileSaver::doesFileExist($_GET['filename'], 'html', $_GET['devicePath']))
  {
    $outputArray = array(
      'name'  => 'Error',
      'value' => 'error:exists');
    die(Rosetta::arrayToJSON($outputArray));
  }
}

// Call AI
$stdout = AIBridge::getErrorLog();

// Try to make stdout into a XMLDocument
$xml = new XMLDocument($stdout);
if ($xml)
{
  $document = $xml->document_element();
  if ($document->tagname() == 'error') // If AI returned an error:
  {
    $outputArray = array(
      'name'  => 'AI Error',
      'value' => $document->get_content());
    die(Rosetta::arrayToJSON($outputArray));
  }
  $xpath = xpath_new_context($document);
  $records = @ xpath_eval($xpath, '/errorLogRecord');
}
else
{
  $outputArray = array(
    'name'  => 'XML Error',
    'value' => $stdout);
  die(Rosetta::arrayToJSON($outputArray));
}

// Output HTML
$computerName = getComputerName();
$buildVersion = getBuildVersion();
$html = array();

$html[] = '<html>';
$html[] = '<head>';
$html[] = '<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">';
$html[] = '<title>' . $computerName . ' - ' . translate('MSG_ERROR_LOG') . '</title>';
$html[] = includeStyleSheet('errorLogStyle.css');
$html[] = '</head>';
$html[] = '<body>';

if ($buildVersion != '')
  $html[] = ('<i>HP Insight Diagnostics ' . translate('MSG_VERSION') . ' ' . $buildVersion . '</i><br>');

if ($computerName != '')
  $html[] = (translate('MSG_COMPUTER_NAME') . ': <b>' . $computerName . '</b>');

$html[] = '<table>';

if (count($records->nodeset) <= 0)
{
  $html[] = '<tr class="m">';
  $html[] = ('<td>' . translate('MSG_ERROR_LOG') . ' ' . translate('MSG_IS_EMPTY') . '</td>');
  $html[] = '</tr>';
}
else
{
  $html[] = '<thead>';
  $html[] = '<tr>';
  $html[] = ('<td>' . translate('MSG_DEVICE') . ', ' . translate('MSG_TEST') . '</td>');
  $html[] = ('<td>' . translate('MSG_DESCRIPTION') . '</td>');
  $html[] = ('<td>' . translate('MSG_REPAIR') . '</td>');
  $html[] = ('<td>' . translate('MSG_NUMBER_OF_ERRORS') . '</td>');
  $html[] = ('<td>' . translate('MSG_ERROR_CODE') . '</td>');
  $html[] = '</tr>';
  $html[] = '</thead>';
  $html[] = '<tbody>';

  foreach ($records->nodeset as $record)
  {
    $test = $record->get_attribute('testCaption');
    $xpath = xpath_new_context($record);
    $errors = @ xpath_eval($xpath, '/error');
    foreach ($errors->nodeset as $error)
    {
      $caption = $error->get_attribute('caption');
      $failedCount = $error->get_attribute('count');
      $errorCode = $error->get_attribute('errorCode');
      $errorContent = $error->get_content();

      $repairContent = '';
      $xpath = xpath_new_context($error);
      $repairActions = @ xpath_eval($xpath, '/repairAction');
      $numberOfRepairActions = count($repairActions->nodeset);
      if ($numberOfRepairActions)
      { 
        $repairAction = $repairActions->nodeset[0]; // there should only be 1, if there are more, we ignore the remaining
        $repairContent = $repairAction->get_content();
        $errorContent = substr($errorContent, 0, strpos($errorContent, $repairContent)); // remove the repair action from the content
      }
      $html[] = '<tr>';
      $html[] = ('<td>' . $test . '</td>');
      $html[] = ('<td>' . $caption . '<br>' . $errorContent . '</td>');
      $html[] = ('<td>' . $repairContent . '</td>');
      $html[] = ('<td class="c">' . $failedCount . '</td>');
      $html[] = ('<td class="c">' . $errorCode . '</td>');
      $html[] = '</tr>';
    }
  }
}

$html[] = '</tbody>';
$html[] = '</table>';
$html[] = '</body>';
$html[] = '</html>';

if (IS_ATTACHMENT)
{
  $filename = ($_GET['filename'] . ".html");
  FilePrompter::promptForSave($filename, $html, 'text/html');
}
else
{
  $filename = $_GET["filename"];
  $extension = "html";
  $devicePath = $_GET["devicePath"];
  
  $saveResult = FileSaver::saveArrayToFile($filename, $extension, $devicePath, $html);
  if ($saveResult == 'success')
  {
    exit('0');
  }
  else
  {
    exit("error");
  }
}
//*/
?>
