<?php
  header('Content-type: text/html; charset=utf-8', true);
  require_once 'includes/globals.php';
  
  frontendStartup();

  $auxControls = '<div class="auxControls">';
  if (IS_OFFLINE)
    $auxControls .= ('<a href="#" onclick="Frontend.restart(); return false;">' . translate('MSG_RELOAD') . '</a>');
  $auxControls .= ('<a href="#" onclick="Frontend.aboutDialog.show(); return false;">' . translate('MSG_ABOUT') . '</a>');
  $auxControls .= '</div>';

  $translatorPath = 'js/translator.js.php';
  $parameters = array();
  if (defined('OVERRIDE_LANG') == true)
    $parameters[] = ('overrideLang=' . OVERRIDE_LANG);
  if (DEBUG_MODE)
    $parameters[] = 'debugMode=on';
  if (count($parameters) > 0)
    $translatorPath .= ('?' . implode('&', $parameters));
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
  <title><?=translate('MSG_HP_INSIGHT_DIAGNOSTICS');?></title>

  <link type="text/css" rel="stylesheet" media="all" href="css/frontend.css"></link>
  <link type="text/css" rel="stylesheet" media="all" href="css/debugger.css"></link>

  <script type="text/javascript">
    var CONFIG = <?php echo buildJsConfig(); ?>
  </script>
  <script type="text/javascript" src="js/lib.js"></script>
  <script type="text/javascript" src="js/ui/includeAllFiles.php"></script>
  <script type="text/javascript" src="js/frontend.js"></script>
  <script type="text/javascript" src="<?=$translatorPath;?>"></script>
  <script type="text/javascript" src="js/debugger.js"></script>
</head>

<body onload="Frontend.init();">

<!-- START initialWait -->
<div id="initialWait">
  <img src="images/hourglass.gif" /><br />
  <span id="initialWaitMessage"><?=translate('MSG_PLEASE_WAIT');?></span>
</div>
<!-- END initialWait -->

<!-- START masthead -->
<div id="masthead" class="hidden">
  <img id="hpLogo" src="images/masthead_hplogo.gif" alt="Hewlett-Packard" />
  <img id="productName" src="images/masthead_productname.gif" alt="HP Insight Diagnostics" />
  <?php
    $factoryClass = (IS_FACTORY === true) ? 'mode' : 'mode hidden';
    $advancedClass = (IS_FACTORY === false && ADVANCED_MODE === true) ? 'mode' : 'mode hidden';
  ?>
  <span class="<?=$factoryClass;?>" id="factoryModeLabel"><?=translate('MSG_FACTORY_MODE');?></span>
  <span class="<?=$advancedClass;?>" id="advancedModeLabel"><?=translate('MSG_ADVANCED_MODE');?></span>
</div>
<!-- END masthead -->

<!-- START content -->
<div id="content" class="hidden">

  <table id="systemInfo">
    <tr>
      <td colspan="2"><?=(IS_PHOENIX) ? 'SmartStart' : getComputerName();?></td>
    </tr>
    <?php
      $serialNumber = getSerialNumber();
      if ($serialNumber != '')
      {
        echo '<tr>';
        echo ('<th scope="row">' . translate('MSG_SYSTEM') . ': </th>');
        echo ('<td>' . $serialNumber . '</td>');
        echo '</tr>';
      }
    ?>
  </table>
  <!-- START mainTabs -->
  <div class="tabBar" id="mainTabs">
    <div id="surveyTab"><?=translate('MSG_SURVEY');?></div>
  <?php if (DIAGNOSIS_SUPPORT) { ?>
    <div id="diagnoseTab"><?=translate('MSG_DIAGNOSE');?></div>
  <?php } ?>
  <?php if (!SURVEY_ONLY) { ?>
    <div id="testTab"><?=translate('MSG_TEST');?></div>
  <?php } ?>
    <div id="statusTab"><?=translate('MSG_STATUS');?></div>
    <div id="logTab"><?=translate('MSG_LOG');?></div>
    <div id="helpTab"><?=translate('MSG_HELP');?></div>
  </div>
  <!-- END mainTabs -->
  
  <!-- START surveyView -->
  <div class="tabBody" id="surveyView">
    <h2><?=(translate('MSG_SYSTEM') . ' ' . translate('MSG_SURVEY'));?></h2>
    <?=$auxControls;?>
    <div class="subTabBar" id="surveyModeControls">
      <div id="currentConfigTab"><?=translate('MSG_CURRENT_CONFIGURATION');?></div>
      <?=(IS_ONLINE) ? ('<div id="compareConfigTab">' . translate('MSG_COMPARE_CONFIG_CHANGES') . '</div>' . "\n") : '';?>
    </div>
  
    <div class="subTabBody" id="currentConfigView">
      <div class="controls" id="currentConfigControls">
        <label><?=translate('MSG_VIEW_LEVEL');?>:
          <select size="1" id="currentConfigViewLevel">
            <option value="summary" selected="selected"><?=translate('MSG_SUMMARY');?></option>
            <option value="advanced"><?=translate('MSG_ADVANCED');?></option>
          </select>
        </label>
        <label><?=translate('MSG_CATEGORIES');?>:
          <select size="1" id="currentConfigCategory"></select>
        </label>
      </div>
      <iframe id="currentConfigFrame" class="viewFrame" src="utils/dummy.html" frameborder="0"></iframe>
    </div>
  
    <?php if (IS_ONLINE) { ?>
    <div class="subTabBody" id="compareConfigView">
      <div class="controls" id="compareConfigControls">
        <label class="compareConfigFileLabel"><?=translate('MSG_CONFIGURATION');?> 1:
          <select size="1" id="compareConfigLeftFile"></select>
        </label>
        <label class="compareConfigFileLabel"><?=translate('MSG_CONFIGURATION');?> 2:
          <select size="1" id="compareConfigRightFile"></select>
        </label>
        <div class="subButton" id="viewComparisonResultsButton">
          <?= translate('MSG_VIEW_COMPARE_RESULTS'); ?>
        </div>
        <div id="compareConfigViewControls">
          <label><?=translate('MSG_VIEW_LEVEL');?>:
            <select size="1" id="compareConfigViewLevel">
              <option value="summary" selected="selected"><?= translate('MSG_SUMMARY'); ?></option>
              <option value="advanced"><?= translate('MSG_ADVANCED'); ?></option>
            </select>
          </label>
          <label><?= translate('MSG_CATEGORIES'); ?>:
            <select size="1" id="compareConfigCategory"></select>
          </label>
          <label><?=translate('MSG_VIEW_CHANGES_ONLY');?>
            <input type="checkbox" id="viewChangesOnly" />
          </label>
        </div>
      </div>
      <iframe id="compareConfigsFrame" class="viewFrame" src="utils/dummy.html" frameborder="0"></iframe>
    </div>
    <?php } ?>
  </div>
  <!-- END surveyView -->

  <?php if (DIAGNOSIS_SUPPORT) { ?>
  <!-- START diagnoseView -->
  <div class="tabBody" id="diagnoseView">
    <h2><?=translate('MSG_HARDWARE_DIAGNOSIS');?></h2>
    <?=$auxControls;?>
    <div class="content" id="diagnoseContent">
      <p><?=translate('MSG_DIAGNOSIS_INSTRUCTIONS'); ?></p>

      <div class="subButton" id="diagnosisMoreInfoButton">
        <?= translate('MSG_CLICK_FOR_MORE_INFORMATION');?>
      </div>

      <div id="diagnoseDeviceListScroller" class="scrollBox">
        <ul id="diagnoseDeviceList" class="checkList">
          <li><?=(translate('MSG_LOADING') . ' ...');?></li>  
        </ul>
      </div>

    </div>
  </div>
  <!-- END diagnoseView -->
  <?php } ?>

  <?php if (!SURVEY_ONLY) { ?>
  <!-- START testView -->
  <div class="tabBody" id="testView">
    <h2><?=(translate('MSG_DIAGNOSTICS') . ' ' . translate('MSG_TEST'));?></h2>
    <?=$auxControls;?>

    <!-- START testViewControls -->
    <div class="subTabBar" id="testViewControls">
      <div id="quickTestTab"><?=translate('MSG_QUICK_TEST');?></div>
      <div id="completeTestTab"><?=translate('MSG_COMPLETE_TEST');?></div>
      <div id="customTestTab"><?=translate('MSG_CUSTOM_TEST');?></div>
    </div>
    <!-- END testViewControls -->

    <!-- START quickTestView -->
    <div class="subTabBody" id="quickTestView">
      <p><?=translate('MSG_SELECT_DEVICE_QUICK');?></p>
      <p><?=translate('MSG_SELECT_ALL_DEVICES_QUICK');?></p>
      <p><?=translate('MSG_TEST_SCHEDULE_INSTRUCTION');?></p>

      <!-- START quickTestControls -->
      <div class="testControls" id="quickTestControls">
        <table>
          <tr>
            <td>
              <b><?=translate('MSG_TEST_MODE');?>:</b>
            </td>
            <td>
              <label>
                <input type="radio" name="quickTestMode" id="quickTestInteractiveMode" checked="checked" /><?=translate('MSG_INTERACTIVE');?>
              </label> 
            </td>
            <td>
              <b><?=translate('MSG_DURATION_OF_TEST');?>:</b>
            </td>
            <td>
              <label>
                <input type="radio" name="quickTestDuration" id="quickTestLoopMode" checked="checked" /><?=translate('MSG_NUMBER_OF_LOOPS');?>
              </label>
            </td>
            <td>
              <input type="text" class="text" id="quickTestNumberOfLoops" maxlength="4" value="1" />
            </td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>
              <label>
                <input type="radio" name="quickTestMode" id="quickTestUnattendedMode" /><?=translate('MSG_UNATTENDED');?>
              </label>
            </td>
            <td>&nbsp;</td>
            <td>
              <label>
                <input type="radio" name="quickTestDuration" id="quickTestTimeMode" /><?=translate('MSG_TOTAL_TEST_TIME');?>
              </label>
            </td>
            <td>
              <input type="text" class="text" id="quickTestNumberOfMinutes" maxlength="4" value="1" />
            </td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="4">
              <label>
                <input type="checkbox" id="quickTestStopOnError" /><?=translate('MSG_STOP_ON_FIRST_ERROR');?>
              </label>
            </td>
          </tr>
        </table>
        <p><?=translate('MSG_SELECT_DEVICE');?>:</p>
        <div id="quickTestDeviceListScroller" class="scrollBox">
          <ul id="quickTestDeviceList" class="checkList">
            <li><?= translate('MSG_LOADING'); ?> ...</li>
          </ul>
        </div>
      </div>
      <!-- END quickTestControls -->

    </div>
    <!-- END quickTestView -->

    <!-- START completeTestView -->
    <div class="subTabBody" id="completeTestView">
      <p><?=translate('MSG_SELECT_DEVICE_COMPLETE');?></p>
      <p><?=translate('MSG_SELECT_ALL_DEVICES_COMPLETE');?></p>
      <p><?=translate('MSG_TEST_SCHEDULE_INSTRUCTION');?></p>

      <!-- START completeTestControls -->
      <div class="testControls" id="completeTestControls">
        <table>
          <tr>
            <td>
              <b><?=translate('MSG_TEST_MODE');?>:</b>
            </td>
            <td>
              <label>
                <input type="radio" name="completeTestMode" id="completeTestInteractiveMode" checked="checked" /><?=translate('MSG_INTERACTIVE');?>
              </label> 
            </td>
            <td>
              <b><?=translate('MSG_DURATION_OF_TEST');?>:</b>
            </td>
            <td>
              <label>
                <input type="radio" name="completeTestDuration" id="completeTestLoopMode" checked="checked" /><?=translate('MSG_NUMBER_OF_LOOPS');?>
              </label>
            </td>
            <td>
              <input type="text" class="text" id="completeTestNumberOfLoops" maxlength="4" value="1" />
            </td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>
              <label>
                <input type="radio" name="completeTestMode" id="completeTestUnattendedMode" /><?=translate('MSG_UNATTENDED');?>
              </label>
            </td>
            <td>&nbsp;</td>
            <td>
              <label>
                <input type="radio" name="completeTestDuration" id="completeTestTimeMode" /><?=translate('MSG_TOTAL_TEST_TIME');?>
              </label>
            </td>
            <td>
              <input type="text" class="text" id="completeTestNumberOfMinutes" maxlength="4" value="1" />
            </td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="4">
              <label>
                <input type="checkbox" id="completeTestStopOnError" /><?=translate('MSG_STOP_ON_FIRST_ERROR');?>
              </label>
            </td>
          </tr>
        </table>
        <p><?=translate('MSG_SELECT_DEVICE');?>:</p>
        <div id="completeTestDeviceListScroller" class="scrollBox">
          <ul id="completeTestDeviceList" class="checkList">
            <li><?= translate('MSG_LOADING'); ?> ...</li>  
          </ul>
        </div>
      </div>
      <!-- END completeTestControls -->

    </div>
    <!-- END completeTestView -->

    <!-- START customTestView -->
    <div class="subTabBody" id="customTestView">
      <p><?=translate('MSG_CUSTOM_TEST_INSTRUCTIONS');?></p>
      <p><?=translate('MSG_SELECT_ALL_INSTRUCTIONS');?></p>

      <!-- START customTestControls -->
      <div class="testControls" id="customTestControls">
        <table>
          <tr>
            <td>
              <b><?=translate('MSG_TEST_MODE');?>:</b>
            </td>
            <td>
              <label>
                <input type="radio" name="customTestMode" id="customTestInteractiveMode" checked="checked" /><?=translate('MSG_INTERACTIVE');?>
              </label> 
            </td>
            <td>
              <b><?=translate('MSG_DURATION_OF_TEST');?>:</b>
            </td>
            <td>
              <label>
                <input type="radio" name="customTestDuration" id="customTestLoopMode" checked="checked" /><?=translate('MSG_NUMBER_OF_LOOPS');?>
              </label>
            </td>
            <td>
              <input type="text" class="text" id="customTestNumberOfLoops" maxlength="4" value="1" />
            </td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td>
              <label>
                <input type="radio" name="customTestMode" id="customTestUnattendedMode" /><?=translate('MSG_UNATTENDED');?>
              </label>
            </td>
            <td>&nbsp;</td>
            <td>
              <label>
                <input type="radio" name="customTestDuration" id="customTestTimeMode" /><?=translate('MSG_TOTAL_TEST_TIME');?>
              </label>
            </td>
            <td>
              <input type="text" class="text" id="customTestNumberOfMinutes" maxlength="4" value="1" />
            </td>
          </tr>
          <tr>
            <td>&nbsp;</td>
            <td colspan="4">
              <label>
                <input type="checkbox" id="customTestStopOnError" /><?=translate('MSG_STOP_ON_FIRST_ERROR');?>
              </label>
            </td>
          </tr>
        </table>
        <div class="subButton" id="customCheckAll">
          <?=translate('MSG_CHECK_ALL');?>
        </div>
        <div class="subButton" id="customUncheckAll">
          <?=translate('MSG_UNCHECK_ALL');?>
        </div>
        <div class="subButton" id="expandCollapseCustomButton">
          <?=translate('MSG_EXPAND');?>
        </div>
        <div id="customTestCountDisplay">
          <span id="customTestCount">0</span> <?=translate('MSG_TESTS_SELECTED');?> <span id="customTestAdvanced">(<span id="customTestAdvancedCount">0</span> <?=translate('MSG_ADVANCED');?>)</span>
        </div>
      </div>
      <!-- END customTestControls -->

      <table id="customTestTable">
        <tr>
          <td>
            <div id="customTestListScroller" class="scrollBox">
              <ul id="customTestList" class="treeCheckList">
                <li><?= translate('MSG_LOADING'); ?> ...</li>  
              </ul>
            </div>
          </td>
          <td>
            <div id="customTestParameterScroller" class="scrollBox">
              <h3><?=translate('MSG_TEST_PARAMETERS');?>:</h3>
              <div id="customTestParameters"></div>
            </div>
          </td>
        </tr>
      </table>
    </div>
    <!-- END customTestView -->

  </div>
  <!-- END testView -->
  <?php } ?>

  <!-- START statusView -->
  <div class="tabBody" id="statusView">
    <h2><?=translate('MSG_TEST_STATUS');?></h2>
    <?=$auxControls;?>

    <!-- START statusContent -->
    <div class="content" id="statusContent">
      <h3 id="statusCaption">&nbsp;</h3>

      <!-- START statusViewControls -->
      <div class="controls" id="statusViewControls">
        <table style="clear: both;">
          <tr>
            <th>
              <div id="statusMessage"></div>
              <div id="statusViewProgressBar" class="progressBar"></div>
            </th>
            <td style="vertical-align: bottom;">
              <div class="subButton" id="cancelRetestButton">
                <?=translate('MSG_CANCEL_TESTING');?>
              </div>
            </td>
          </tr>
          <tr>
            <td colspan="2" id="statusInfo"></td>
          </tr>
        </table>
      </div>
      <!-- END statusViewControls -->

      <iframe id="statusFrameA" class="viewFrame" src="views/testStatus.php" frameborder="0"></iframe>
      <iframe id="statusFrameB" class="viewFrame" src="utils/dummy.html" frameborder="0"></iframe>

    </div>
    <!-- END statusContent -->

  </div>
  <!-- END statusView -->

  <!-- START logView -->
  <div class="tabBody" id="logView">
    <h2>Log</h2>
    <?=$auxControls;?>

    <!-- START logViewControls -->
    <div class="subTabBar" id="logViewControls">
      <?=(DIAGNOSIS_SUPPORT === true) ? ('<div id="diagnosisLogTab">' . translate('MSG_DIAGNOSIS_LOG') . '</div>' . "\n") : '';?>
      <?=(SURVEY_ONLY === false) ? ('<div id="testLogTab">' . translate('MSG_TEST_LOG') . '</div>' . "\n") : '';?>
      <div id="errorLogTab"><?=translate('MSG_ERROR_LOG');?></div>
      <?=(IML_SUPPORT) ? ('<div id="imlLogTab">' . translate('MSG_INTEGRATED_MANAGEMENT_LOG') . '</div>' . "\n") : '';?>
    </div>
    <!-- END logViewControls -->
    
    <?php if (DIAGNOSIS_SUPPORT) { ?>
    <!-- START diagnosisLogView -->
    <div class="subTabBody" id="diagnosisLogView">
      <iframe id="diagnosisLogFrame" class="viewFrame" src="utils/dummy.html" frameborder="0"></iframe>
    </div>
    <!-- END diagnosisLogView -->
    <?php } ?>

    <?php if (SURVEY_ONLY === false) { ?>
    <!-- START testLogView -->
    <div class="subTabBody" id="testLogView">
      <iframe id="testLogFrame" class="viewFrame" src="utils/dummy.html" frameborder="0"></iframe>
    </div>
    <!-- END testLogView -->
    <?php } ?>

    <!-- START errorLogView -->
    <div class="subTabBody" id="errorLogView">
      <iframe id="errorLogFrame" class="viewFrame" src="utils/dummy.html" frameborder="0"></iframe>
    </div>
    <!-- END errorLogView -->

    <?php if (IML_SUPPORT) { ?>
    <!-- START imlLogView -->
    <div class="subTabBody" id="imlLogView">
      <div class="subButton" id="imlLogSetToRepair">
        <?=translate('MSG_SET_SELECTED_ITEMS_TO_REPAIRED');?>
      </div>
      <div class="floatRight">
        <div class="subButton" id="imlLogCheckAll">
          <?=translate('MSG_CHECK_ALL');?>
        </div>
        <div class="subButton" id="imlLogUncheckAll">
          <?=translate('MSG_UNCHECK_ALL');?>
        </div>
      </div>
      <br class="clear" />
      <iframe id="imlLogFrame" class="viewFrame" src="utils/dummy.html" frameborder="0"></iframe>
    </div>
    <!-- END imlLogView -->
    <?php } ?>

  </div>
  <!-- END logView -->

  <!-- START helpView -->
  <div class="tabBody" id="helpView">
    <h2><?=translate('MSG_HELP');?></h2>
    <?=$auxControls;?>

    <!-- START helpViewControls -->
    <div class="subTabBar" id="helpViewControls">
      <div id="hpInsightDiagnosticsTab"><?=translate('MSG_HP_INSIGHT_DIAGNOSTICS');?></div>
    <?php if (!SURVEY_ONLY) { ?>
      <div id="errorCodesTab"><?=translate('MSG_ERROR_CODES');?></div>
      <div id="testComponentTab"><?=translate('MSG_TEST_COMPONENTS');?></div>
    <?php } ?>
    </div>
    <!-- END helpViewControls -->

    <!-- START hpInsightDiagnosticsView -->
    <div class="subTabBody" id="hpInsightDiagnosticsView">
      <iframe class="viewFrame" id="diagsHelpFrame" src="utils/dummy.html"></iframe>
    </div>
    <!-- END hpInsightDiagnosticsView -->

    <?php if (!SURVEY_ONLY) { ?>
    <!-- START errorCodesView -->
    <div class="subTabBody" id="errorCodesView">
      <div class="controls" id="errorCodesControls">
        <input type="text" id="errorCodesSearchInput" />
        <div class="subButton" style="clear: none; float: none; display: inline; position: relative;" id="findErrorCodesButton"><?=translate('MSG_FIND_ERROR_CODES');?></div>
        <br />
      </div>
      <iframe class="viewFrame" id="errorCodesFrame" src="utils/dummy.html" frameborder="0"></iframe>
    </div>
    <!-- END errorCodesView -->

    <!-- START testComponentView -->
    <div class="subTabBody" id="testComponentView">
      <iframe id="testComponentFrameA" class="viewFrame" src="utils/dummy.html" frameborder="0"></iframe>
      <iframe id="testComponentFrameB" class="viewFrame" src="utils/dummy.html" frameborder="0"></iframe>
      <div id="testComponentContinuePanel">
        <p><?=(translate('MSG_ONE_OR_MORE_TCS_FAILED') . ' ' . translate('MSG_CATALOG') . ' ...');?></p>
        <div class="subButton" id="testComponentContinueButton">
          <?=translate('MSG_CONTINUE');?>
        </div>
      </div>
    </div>
    <!-- END testComponentView -->
    <?php } ?>

  </div>
  <!-- END helpView -->

  <!-- START footer -->
  <div id="footer">
    <?php if (IS_OFFLINE || IS_FACTORY) { ?>
    <div id="exitDiags" class="button">
      <?= translate('MSG_EXIT') . ' ' . translate('MSG_DIAGNOSTICS');?>
    </div>
    <?php } ?>
    
    <!-- START submodeFooters -->
    <div class="floatRight">
      
      <!-- START surveyViewFooter -->
      <div id="surveyViewFooter">

        <!-- START currentConfigViewFooter -->
        <div id="currentConfigViewFooter" class="submodeFooter">
          <?php if (IS_ONLINE) { ?>
          <div id="printCurrentConfig" class="button">
            <?=translate('MSG_PRINT');?>
          </div>
          <?php } ?>

          <div id="saveCurrentConfig" class="button">
            <?=translate('MSG_SAVE');?>
          </div>

          <?php if (IS_ONLINE) { ?>
          <div id="scheduleCaptures" class="button">
            <?=translate('MSG_SCHEDULED_CONFIG_CAPTURES');?>
          </div>

          <div id="manageCaptures" class="button">
            <?=translate('MSG_MANAGE_SYS_CONFIGS');?>
          </div>
          <?php } ?>
        </div>
        <!-- END currentConfigViewFooter -->
  
        <?php if (IS_ONLINE) { ?>
        <!-- START compareConfigViewFooter -->
        <div id="compareConfigViewFooter" class="submodeFooter">
          <div id="printCompareConfig" class="button">
            <?=translate('MSG_PRINT');?>
          </div>
          <div id="saveCompareConfig" class="button">
            <?=translate('MSG_SAVE');?>
          </div>
        </div>
        <!-- END compareConfigViewFooter -->
        <?php } ?>

      </div>
      <!-- END surveyViewFooter -->

      <?php if (DIAGNOSIS_SUPPORT) { ?>
      <!-- START diagnoseViewFooter -->
      <div id="diagnoseViewFooter">
        <div id="beginDiagnosis" class="button">
          <?=translate('MSG_DIAGNOSE');?>
        </div>
      </div>
      <!-- END diagnoseViewFooter -->
      <?php } ?>

      <?php if (!SURVEY_ONLY) { ?>
      <!-- START testViewFooter -->
      <div id="testViewFooter">

        <!-- START quickTestViewFooter -->
        <div id="quickTestViewFooter" class="submodeFooter">
          <?php if (IS_ONLINE) { ?>
          <div id="scheduleQuickTests" class="button">
            <?=translate('MSG_SCHEDULED_QUICK_TESTS');?>
          </div>
          <?php } ?>

          <div id="beginQuickTesting" class="button">
            <?=translate('MSG_BEGIN_TESTING');?>
          </div>
        </div>
        <!-- END quickTestViewFooter -->
  
        <!-- START completeTestViewFooter -->
        <div id="completeTestViewFooter" class="submodeFooter">
          <?php if (IS_ONLINE) { ?>
          <div id="scheduleCompleteTests" class="button">
            <?=translate('MSG_SCHEDULED_COMPLETE_TESTS');?>
          </div>
          <?php } ?>

          <div id="beginCompleteTesting" class="button">
            <?=translate('MSG_BEGIN_TESTING');?>
          </div>
        </div>
        <!-- END completeTestViewFooter -->
  
        <!-- START customTestViewFooter -->
        <div id="customTestViewFooter" class="submodeFooter">
          <div id="beginCustomTesting" class="button">
            <?=translate('MSG_BEGIN_TESTING');?>
          </div>
        </div>
        <!-- END customTestViewFooter -->

      </div>
      <!-- END testViewFooter -->
      <?php } ?>

      <!-- START logViewFooter -->
      <div id="logViewFooter">

        <?php if (DIAGNOSIS_SUPPORT) { ?>
        <!-- START diagnosisLogViewFooter -->
        <div id="diagnosisLogViewFooter" class="submodeFooter">
          <div id="clearDiagnosisLog" class="button">
            <?=translate('MSG_CLEAR_DIAGNOSIS_LOG');?>
          </div>
          <div id="saveDiagnosisLog" class="button">
            <?=translate('MSG_SAVE');?>
          </div>
        </div>
        <!-- END diagnosisLogViewFooter -->
        <?php } ?>
  
        <?php if (SURVEY_ONLY === false) { ?>
        <!-- START testLogViewFooter -->
        <div id="testLogViewFooter" class="submodeFooter">
          <div id="clearTestLog" class="button">
            <?=translate('MSG_CLEAR_TEST_LOG');?>
          </div>
          <div id="saveTestLog" class="button">
            <?=translate('MSG_SAVE');?>
          </div>
        </div>
        <!-- END testLogViewFooter -->
        <?php } ?>
  
        <!-- START errorLogViewFooter -->
        <div id="errorLogViewFooter" class="submodeFooter">
          <div id="clearErrorLog" class="button">
            <?=translate('MSG_CLEAR_ERROR_LOG');?>
          </div>
          <div id="saveErrorLog" class="button">
            <?=translate('MSG_SAVE');?>
          </div>
        </div>
        <!-- END errorLogViewFooter -->

        <?php if (IML_SUPPORT) { ?>
        <!-- START imlLogViewFooter -->
        <div id="imlLogViewFooter" class="submodeFooter">
          <div id="addNoteImlLog" class="button">
            <?=translate('MSG_ADD_MAINTENANCE_NOTE');?>
          </div>
          <div id="clearImlLog" class="button">
            <?=translate('MSG_CLEAR_IML');?>
          </div>
          <div id="saveImlLog" class="button">
            <?=translate('MSG_SAVE');?>
          </div>
        </div>
        <!-- END imlLogViewFooter -->
        <?php } ?>

      </div>
      <!-- END logViewFooter -->
  
    </div>
    <!-- END submodeFooters -->

  </div>
  <!-- END footer -->

  <!-- add padding to bottom of page -->
  <br style="clear: both;" />

</div>
<!-- END content -->

<?php if (IS_ONLINE === true) { ?>
<!-- START smhRefreshFrame -->
<div id="smhRefreshFrameDiv">
  <iframe id="smhRefreshFrame" src="utils/dummy.html" frameborder="0" onload="if (Frontend != undefined && Frontend.sessionRefresher != undefined) { Frontend.sessionRefresher.frameLoaded(); }"></iframe>
</div>
<!-- END smhRefreshFrame -->
<?php } ?>

<?php if (IS_ONLINE === true) { ?>
<!-- START scheduleDialog -->
<div id="scheduleDialog" class="dialog hidden">
  <div class="header" id="scheduleDialogHeader"></div>
  <div class="body">
    <div class="subTabBar">
      <div id="weeklyTab"><?=translate('MSG_WEEKLY');?></div>
      <div id="monthlyTab"><?=translate('MSG_MONTHLY');?></div>
    </div>
    <div>
      <div id="weeklyContent" class="subTabBody">
        <fieldset id="weeklyFieldset">
          <legend><?=translate('MSG_SELECT_WEEKDAYS');?></legend>
          <table>
            <tr>
              <td>
                <label>
                  <input type="checkbox" value="0" /> <?=translate('MSG_SUNDAY');?>
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="1" /> <?=translate('MSG_MONDAY');?>
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="2" /> <?=translate('MSG_TUESDAY');?>
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="3" /> <?=translate('MSG_WEDNESDAY');?>
                </label>
              </td>
            </tr>
            <tr>
              <td>
                <label>
                  <input type="checkbox" value="4" /> <?=translate('MSG_THURSDAY');?>
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="5" /> <?=translate('MSG_FRIDAY');?>
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="6" /> <?=translate('MSG_SATURDAY');?>
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="7" id="weeklyAll" /> <?=translate('MSG_EVERY_DAY');?>
                </label>
              </td>
            </tr>
          </table>
        </fieldset>
      </div>
      <div id="monthlyContent" class="subTabBody">
        <fieldset id="monthlyFieldset">
          <legend><?=translate('MSG_SELECT_MONTHDAYS');?></legend>
          <table>
            <tr>
              <td>
                <label>
                  <input type="checkbox" value="1" /><br />1
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="2" /><br />2
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="3" /><br />3
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="4" /><br />4
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="5" /><br />5
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="6" /><br />6
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="7" /><br />7
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="8" /><br />8
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="9" /><br />9
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="10" /><br />10
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="11" /><br />11
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="12" /><br />12
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="13" /><br />13
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="14" /><br />14
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="15" /><br />15
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="16" /><br />16
                </label>
              </td>
            </tr>
            <tr>
              <td>
                <label>
                  <input type="checkbox" value="17" /><br />17
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="18" /><br />18
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="19" /><br />19
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="20" /><br />20
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="21" /><br />21
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="22" /><br />22
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="23" /><br />23
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="24" /><br />24
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="25" /><br />25
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="26" /><br />26
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="27" /><br />27
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="28" /><br />28
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="29" /><br />29
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="30" /><br />30
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="31" /><br />31
                </label>
              </td>
              <td>
                <label>
                  <input type="checkbox" value="0" id="monthlyAll" /><br /><?=translate('MSG_ALL')?>
                </label>
              </td>
            </tr>
          </table>
        </fieldset>
      </div>
      <div id="scheduleDialogTimeInput">
        <?=translate('MSG_SELECT_START_TIME');?>
        <br />
        <input type="text" id="scheduleDialogHourField" value="13" /> : <input type="text" id="scheduleDialogMinuteField" value="00" />
      </div>
    </div>
    <div class="buttonBar">
      <input id="scheduleDialogOkButton" type="button" value="<?= translate('MSG_OK'); ?>" />
      <input id="scheduleDialogCancelButton" type="button" value="<?= translate('MSG_CANCEL'); ?>" />
    </div>
  </div>
</div>
<!-- END scheduleDialog -->
<?php } ?>

<?php if (IS_ONLINE) { ?>
<!-- START manageDialog -->
<div id="manageDialog" class="dialog hidden">
  <div class="header" id="manageDialogHeader"><?=translate('MSG_MANAGE_SYS_CONFIGS');?></div>
  <div class="body">
    <div id="manageDialogContent" class="content">
      <p id="manageDialogNoSurveys"><?=translate('MSG_NO_CONFIGS_2_MANAGE');?></p>
      <p id="manageDialogLoading"><?=translate('MSG_LOADING');?></p>
      <p id="manageDialogInstructions"><?=translate('MSG_SELECT_CONFIGS_TO_DELETE');?></p>
      <div id="manageDialogListScroller" class="scrollBox">
        <ul id="manageDialogList" class="checkList"></ul>
      </div>
    </div>
    <div id="manageDialogButtonBar" class="buttonBar">
      <input type="button" id="manageDialogDeleteButton" value="<?= translate('MSG_DELETE'); ?>" />
      <input type="button" id="manageDialogCancelButton" value="<?= translate('MSG_CANCEL'); ?>" />
    </div>
  </div>
</div>
<!-- END manageDialog -->
<?php } ?>

<?php if (IS_OFFLINE === true) { // only display server-side save dialog if in offline mode ?> 
<!-- START saveDialog -->
<div id="saveDialog" class="dialog hidden">
  <div class="header" id="saveDialogHeader"><?=translate('MSG_SAVE');?></div>
  <div class="body">
    <div class="content">
      <div id="saveDialogLocationsDiv">
        <span id="saveDialogSelectMessage"><?=translate('MSG_PLEASE_SELECT_SAVE_LOCATION');?>:</span>
        <div id="saveDialogScanningMessage"><?=translate('MSG_SCANNING_FOR_DEVICES');?> ...</div>
        <ul id="saveDialogLocations"></ul>
      </div>
      <div id="saveDialogFilenameDiv">
        <?=translate('MSG_FILENAME');?>: <input type="text" id="saveDialogFilename" />.html
      </div>
    </div>
    <div class="buttonBar">
      <input type="button" class="spacer" id="saveDialogRescanButton" value="<?= translate('MSG_RESCAN_DEVICES'); ?>" />
      <input type="button" id="saveDialogSaveButton" value="<?= translate('MSG_SAVE'); ?>" />
      <input type="button" id="saveDialogCancelButton" value="<?= translate('MSG_CANCEL'); ?>" />
    </div>
  </div>
</div>
<!-- END saveDialog -->
<?php } ?>


<?php if (SURVEY_ONLY === false) { ?>
<!-- START displayErrorCodeDialog -->
<div id="errorCodeDisplay" class="dialog hidden">
  <div class="header"><?= translate('MSG_ERROR_CODES'); ?></div>
  <div class="body">
    <div class="content">
      <table id="errorCodeDisplayTable" class="hidden">
        <tr>
          <th><?=translate('MSG_CODE');?></th>
          <td id="errorCodeDisplayCodeField"></td>
        </tr>
        <tr>
          <th><?=(translate('MSG_DEVICE') . ', ' . translate('MSG_TEST'));?></th>
          <td id="errorCodeDisplayNameField"></td>
        </tr>
        <tr>
          <th><?=translate('MSG_MESSAGE');?></th>
          <td id="errorCodeDisplayMessageField"></td>
        </tr>
        <tr>
          <th><?=translate('MSG_REPAIR');?></th>
          <td id="errorCodeDisplayRepairField"></td>
        </tr>
      </table>
    </div>
    <div class="buttonBar">
      <input type="button" id="errorCodeDisplayButton" value="<?= translate('MSG_OK'); ?>" />
    </div>
  </div>
</div>
<!-- END displayErrorCodeDialog -->
<?php } ?>

<!-- START aboutDialog -->
<div id="aboutDialog" class="dialog hidden">
  <div class="header" id="aboutDialogHeader"><?=translate('MSG_ABOUT');?></div>
  <div class="body">
    <div class="content" id="aboutDialogContent">
      <div id="aboutDialogBanner" class="banner">
        <img src="images/about_splash.gif" />
      </div>
      <div id="aboutDialogBadge" class="badge">
        <img src="images/startup_logo.gif" />
      </div>
      <div id="aboutDialogProductName" class="name">
        <img src="images/about_productname.gif" />
      </div>
      <div id="aboutDialogVersionNumber" class="version">
        <?php
          echo (translate('MSG_VERSION') . ' ' . DIAGS_VERSION);
          echo (' - ' . DIAGS_BUILD_DATE);
        ?>
      </div>
      <div id="aboutDialogCopyright" class="copyright">
        <?=DIAGS_COPYRIGHT; ?>
      </div>
    </div>
    <div class="buttonBar" id="aboutDialogButtonBar">
      <input type="button" id="aboutDialogButton" value="<?= translate('MSG_OK'); ?>" />
    </div>
  </div>
</div>
<!-- END aboutDialog -->

<?php if (DIAGNOSIS_SUPPORT) { ?>
<!-- START aboutDiagnosisDialog -->
<div id="aboutDiagnosisDialog" class="dialog hidden">
  <div class="header" id="aboutDiagnosisDialogHeader"><?=translate('MSG_HARDWARE_DIAGNOSIS');?></div>
  <div class="body">
    <div class="content">
      <h3><?=translate('MSG_SMART_ARRAY_DIAGNOSIS');?></h3>
      <p><?=translate('MSG_SMART_ARRAY_DIAGNOSIS_DESC');?></p>
      <h3><?=translate('MSG_POWER_SUPPLY_DIAGNOSIS');?></h3>
      <p><?=translate('MSG_POWER_SUPPLY_DIAGNOSIS_DESC');?></p>
    </div>
    <div class="buttonBar">
      <input type="button" id="aboutDiagnosisDialogButton" value="<?= translate('MSG_OK'); ?>" />
    </div>
  </div>
</div>
<!-- END aboutDiagnosisDialog -->
<?php } ?>

</body>

</html>
