<?php
header('Content-type: text/html; charset=utf-8', true);
header('Cache-control: no-cache', true);
header('Pragma: no-cache');

include_once '../includes/globals.php';
include_once 'includes/parseContents.php';

// exit if path contains .
if (strpos($_GET['path'], '.') !== false)
  exit('Invalid Path');
// append path to the help directory to ensure we are in the right spot
$path = realpath(dirname(__FILE__) . '/' . $_GET['path']);
// exit if path is not a valid path
if ($path == false)
  exit('Invalid Path');
// exit if path is not a directory
if (!is_dir($path))
  exit('Invalid Path');

$items = parseContents($path);
$firstPage = $items[0]['src'];
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
 "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <title>help</title>
  <link type="text/css" rel="stylesheet" media="all" href="../css/toc.css"></link>
  <script type="text/javascript" src="js/CollapsableListItem.js"></script>
  <script type="text/javascript" src="js/toc.js"></script>
  <script type="text/javascript">
    document.oncontextmenu = function ()
    {
      return top.CONFIG.DEBUG_ACTIVE;
    }
  </script>
</head>
<body onload="init('<?=$firstPage;?>');">
  <div class="controls right">
    <a target="_self" href="search.php"><?php echo translate('MSG_SEARCH_HELP'); ?> &gt;</a>
  </div>
  <ul id="tableOfContents">
<?php

foreach ($items as $item)
{
  $type = $item['type'];
  switch ($type)
  {
    case 'page': drawPage($item); break;
    case 'book': drawBook($item); break;
  }
}

function drawPage(&$page)
{
  echoln('<li class="page">');
  echoln('<img src="../images/tree_empty_faded.gif" />');
  echoln('<a target="contentFrame" href="pageview.php?path=' . $page['src'] . '">' . $page['title'] . '</a>');
  echoln('</li>');
}

function drawBook(&$book)
{
  $items = $book['content'];
  $count = count($items);
  $imgsrc = ($count > 0) ? '../images/tree_expand.gif' : '../images/tree_collapse.gif';
  echoln('<li class="book">');
  echoln('<img src="' . $imgsrc . '" />');
  echoln('<a href="#">' . $book['title'] . '</a>');
  if ($count > 0)
  {
    echoln('<ul>');
    foreach ($items as $item)
    {
      $type = $item['type'];
      switch ($type)
      {
        case 'bookmark': drawBookmark($item); break;
        case 'chapter': drawChapter($item); break;
      }
    }
    echoln('</ul>');
  }
  echoln('</li>');
}

function drawBookmark(&$bookmark)
{
  echoln('<li class="bookmark">');
  echoln('<img src="../images/tree_empty_faded.gif" />');
  echoln('<a target="contentFrame" href="pageview.php?path=' . $bookmark['src'] . '">' . $bookmark['title'] . '</a>');
  echoln('</li>');
}

function drawChapter(&$chapter)
{
  $items = $chapter['content'];
  $count = count($items);
  $imgsrc = ($count > 0) ? '../images/tree_expand.gif' : '../images/tree_collapse.gif';
  echoln('<li class="chapter">');
  echoln('<img src="' . $imgsrc . '" />');
  echoln('<a href="#">' . $chapter['title'] . '</a>');
  if ($count > 0)
  {
    echoln('<ul>');
    foreach ($items as $item)
      drawBookmark($item);
    echoln('</ul>');
  }
  echoln('</li>');
}

?>
  </ul>
</body>
</html>
