<?php

class AIBridge
{
  function aicommand($command)
  {
    if (DEBUG_MODE == true)
    {
      $debugFile = fopen(FRONTEND_DEBUG_FILE, 'a');
      fwrite($debugFile, (date('Y-m-d H:i:s') . "\naicommand: IN: \n" . $command . "\n"));
    }

    $stdout = '';
    $pipeDescriptor = array(
    0 => array('pipe', 'r'),  // stdin
    1 => array('pipe', 'w')); // stdout

    $process = proc_open(AI_PATH, $pipeDescriptor, $pipes);
    if (is_resource($process))
    {
      fwrite($pipes[0], $command);
      fclose($pipes[0]);

      while (!feof($pipes[1]))
        $stdout .= fgets($pipes[1]);
      fclose($pipes[1]);

      proc_close($process);
    }

    if (DEBUG_MODE == true)
    {
      if (strlen($stdout) > 2048)
        $debugOut = (substr($stdout, 0, 2048) . "\n--CUT--\n\n"); // only get first 2K of stdout to keep log file size low
      else
        $debugOut = ($stdout . "\n");
      fwrite($debugFile, ("\naicommand: OUT: \n" . $debugOut));
      fclose($debugFile);

      $outputFile = fopen(AI_OUTPUT_FILE, 'w');
      fwrite($outputFile, $stdout);
      fclose($outputFile);
    }

    return $stdout;
  }

  function startSystemSurvey()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('startProcess');
    $root->set_attribute('blockIfBusy', '1');
    $diagID = $root->append_child($command->create_element('diagID'));
    $diagID->set_attribute('language', LANG);
    $diagID->set_attribute('serialize', '1');
    $diagID->set_attribute('surveyCapture', '1');
    $diagID->set_attribute('surveyFilename', 'survey.lastwebsession.xml');
    return AIBridge::aicommand($command->dump_mem());
  }

  function startCatalog()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('startProcess');
    $root->set_attribute('blockIfBusy', '1');
    $diagID = $root->append_child($command->create_element('diagCatalog'));
    return AIBridge::aicommand($command->dump_mem());
  }

  function getProcessStatus($processID)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('getProcessStatus');
    $root->set_attribute('processID', $processID);
    return AIBridge::aicommand($command->dump_mem());
  }

  function getProcessResult($processID)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('getProcessResult');
    $root->set_attribute('processID', $processID);
    return AIBridge::aicommand($command->dump_mem());
  }

  function replyToPrompt($processID, $promptID, $value)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('sendProcessReply');
    $root->set_attribute('processID', $processID);
    $root->set_attribute('promptID', $promptID);
    $response = $root->append_child($command->create_element('promptResponse'));
    $response->set_attribute('value', $value);
    return AIBridge::aicommand($command->dump_mem());
  }

  function cancelProcess($processID)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('cancelProcess');
    $root->set_attribute('processID', $processID);
    return AIBridge::aicommand($command->dump_mem());
  }

  function compareSurveys($leftFile, $rightFile)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('compareSurveyFiles');
    $root->set_attribute('leftFilename', $leftFile);
    $root->set_attribute('rightFilename', $rightFile);
    return AIBridge::aicommand($command->dump_mem());
  }

  function getErrorLog()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('getErrorLog');
    $root->set_attribute('language', LANG);
    return AIBridge::aicommand($command->dump_mem());
  }

  function clearErrorLog()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('clearErrorLog');
    $root->set_attribute('language', LANG);
    return AIBridge::aicommand($command->dump_mem());
  }

  function getTestLog()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('getTestLog');
    $root->set_attribute('language', LANG);
    return AIBridge::aicommand($command->dump_mem());
  }

  function clearTestLog()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('clearTestLog');
    $root->set_attribute('language', LANG);
    return AIBridge::aicommand($command->dump_mem());
  }

  function getDiagnosisLog()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('getDiagnosisLog');
    $root->set_attribute('language', LANG);
    return AIBridge::aicommand($command->dump_mem());
  }

  function clearDiagnosisLog()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('clearDiagnosisLog');
    $root->set_attribute('language', LANG);
    return AIBridge::aicommand($command->dump_mem());
  }
  
  function performDeviceAction($component, $device, $subDevice, $tcLoadFilename, $call)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('deviceAction');
    $root->set_attribute('component', $component);
    $root->set_attribute('device', $device);
    $root->set_attribute('subDevice', $subDevice);
    $root->set_attribute('tcLoadFilename', $tcLoadFilename);
    $root->append_child($command->create_element($call));
    return AIBridge::aicommand($command->dump_mem());
  }

  function getImlLog($sortField='')
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('imlGetLog');
    $root->set_attribute('language', LANG);
    $root->set_attribute('sortField', $sortField);
    return AIBridge::aicommand($command->dump_mem());
  }

  function clearImlLog()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('imlClearLog');
    $root->set_attribute('language', LANG);
    return AIBridge::aicommand($command->dump_mem());
  }

  function addImlNote($string)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('imlAddMaintenanceNote');
    $root->set_attribute('language', LANG);
    $root->set_content($string);
    return AIBridge::aicommand($command->dump_mem());
  }

  function repairImlItems($indexList)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('imlSetItemsToRepaired');
    $root->set_attribute('language', LANG);
    $root->set_attribute('indexList', $indexList);
    return AIBridge::aicommand($command->dump_mem());
  }

  function getSurveyList()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('getSurveyList');
    return AIBridge::aicommand($command->dump_mem());
  }

  function scheduleProcess($mode, $hour, $minute, $months, $monthdays, $weekdays, $process, $attributes)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('scheduleProcess');
    $root->set_attribute('mode', $mode);
    $root->set_attribute('hour', $hour);
    $root->set_attribute('minute', $minute);
    $root->set_attribute('months', $months);
    $root->set_attribute('monthdays', $monthdays);
    $root->set_attribute('weekdays', $weekdays);
    switch ($process)
    {
    case 'diagID':
      $processXML = $root->append_child($command->create_element('diagID'));
      $processXML->set_attribute('language', LANG);
      $processXML->set_attribute('surveyCapture', '1');
      break;
    case 'quick':
    case 'complete':
      AIBridge::appendStandardTestXML($command, $root, $attributes);
      break;
    }
    return AIBridge::aicommand($command->dump_mem());
  }

  function removeSurveyFiles($surveys)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('removeSurveyFiles');
    foreach ($surveys as $survey)
    {
      $surveyFile = $root->append_child($command->create_element('surveyFile'));
      $surveyFile->set_content($survey);
    }
    return AIBridge::aicommand($command->dump_mem());
  }

  function shutdownDiags($doRebootIfDiagsCD=true)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('killDiags');
    if (IS_DIAGSCD && $doRebootIfDiagsCD)
      $root->set_attribute('rebootIfDiagsCD', '1');
    AIBridge::aicommand($command->dump_mem());
    return 0;
  }

  function startStandardTests($testMode, $runMode, $runTime, $stopOnError, $devices)
  {
    // Determine the appropriate parameters
    if ($testMode == 'quick')
      $caption = translate('MSG_QUICK_TEST');
    else if ($testMode == 'complete')
      $caption = translate('MSG_COMPLETE_TEST');
    else if ($testMode == 'custom')
      $caption = translate('MSG_CUSTOM_TEST');
    else
      $caption = (translate('MSG_UNKNOWN') . ' ' . translate('MSG_TEST'));
    if ($runMode == 'time')
      $durationType = 'desiredTestTime';
    else if ($runMode == 'loop')
      $durationType = 'testLoops';
    else
      $durationType = $runMode;
    // Load the idResult
    $idResult = new XMLDocument(file_get_contents(IDRESULT_PATH));
    $xpath = xpath_new_context($idResult->document_element());
    // Build the xml command
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('startProcess');
    $parameters = array(
      'type' => $testMode,
      'durationType' => $runMode,
      'durationValue' => $runTime,
      'stopOnError' => $stopOnError,
      'devices' => $devices);
    AIBridge::appendStandardTestXML($command, $root, $parameters);

    return AIBridge::aicommand($command->dump_mem(false, 'UTF-8'));
  }

  function startCustomTests($testMode, $runMode, $runTime, $stopOnError, $tests, $ignoreParameters=false)
  {
    // Determine the appropriate parameters
    if ($testMode == 'custom')
      $caption = translate('MSG_CUSTOM_TEST');
    else
      $caption = $testMode;
    if ($runMode == 'time')
      $durationType = 'desiredTestTime';
    else if ($runMode == 'loop')
      $durationType = 'testLoops';
    else
      $durationType = $runMode;
    // Load the idResult
    $idResult = new XMLDocument(file_get_contents(IDRESULT_PATH));
    $xpath = xpath_new_context($idResult->document_element());
    // Build the xml command
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('startProcess');
    $diagRun = $root->append_child($command->create_element('diagRun'));
    $diagRun->set_attribute('language', LANG);
    $diagRun->set_attribute('jobCaption', $caption);
    $diagRun->set_attribute('stopOnError', ($stopOnError == 'yes') ? '1' : '0');
    if (!$ignoreParameters)
    {
      if (isset($durationType) && !empty($durationType))
        $diagRun->set_attribute($durationType, $runTime);
    }
    // Iterate through the devices and get the required info
    foreach($tests as $testArray)
    {
      $componentName = $testArray['component'];
      $deviceName = $testArray['device'];
      $deviceNodes = xpath_eval($xpath, ('/diagOutput/category/device[@component="' . $componentName . '" and @name="' . $deviceName . '"]'));
      $device = $deviceNodes->nodeset[0]; // there should be only 1 result
      $deviceXpath = xpath_new_context($device);
      $deviceCaption = $device->get_attribute('caption');
      $deviceClass = $device->get_attribute('class');
      $deviceCdmClass = $device->get_attribute('cdmClass');
      $deviceSlot = $device->get_attribute('Slot');
      if ($componentName == 'cdm')
        $deviceName = $device->get_attribute('deviceID');

      $testName = $testArray['test'];
      $testNodes = xpath_eval($deviceXpath, ('/test[@name="' . $testName . '"]'));
      $test = $testNodes->nodeset[0]; // there should be only 1 result
      $testCaption = $test->get_attribute('caption');
      $testDescription = $test->get_attribute('description');
      $testSingleThread = $test->get_attribute('singleThread');
      $testInteractive = $test->get_attribute('interactive');

      $runTest = $diagRun->append_child($command->create_element('runTest'));
      $runTest->set_attribute('component', $componentName);
      $runTest->set_attribute('deviceClass', $deviceClass);
      if ($componentName == 'cdm')
        $runTest->set_attribute('cdmClass', $deviceCdmClass);
      $runTest->set_attribute('tcLoadFilename', ($componentName . '.dat'));
      $runTest->set_attribute('language', LANG);
      $runTest->set_attribute('device', $deviceName);
      $runTest->set_attribute('test', $testName);
      $runTest->set_attribute('description', $testDescription);
      $runTest->set_attribute('caption', ($deviceCaption . ' - ' . $testCaption));
      $runTest->set_attribute('complete', '1');
      if ($deviceSlot != '')
        $runTest->set_attribute('Slot', $deviceSlot);
      if ($testSingleThread != '')
        $runTest->set_attribute('singleThread', $testSingleThread);
      else
        $runTest->set_attribute('singleThread', '0');
      if (!$ignoreParameters)
      {
        $runTest->set_attribute('complete', '1');
        if ($testInteractive != '')
          $runTest->set_attribute('interactive', $testInteractive);
        else
          $runTest->set_attribute('interactive', '0');
      }
      else
      {
        $runTest->set_attribute('interactive', '0');
      }

      if (isset($testArray['parameters']) && is_array($testArray['parameters']))
      {
        $parameters = $testArray['parameters'];
        foreach ($parameters as $parameter)
        {
          $name = $parameter['name'];
          $value = $parameter['value'];
          if (is_bool($value))
            $value = ($value == true) ? '1' : '0';
          if ($value == 'true')
            $value = '1';
          if ($value == 'false')
            $value = '0';
          $runTest->set_attribute($name, $value);
        }
      }
    }
    if (IS_FACTORY) // dump this xml command to a file in factory mode
      $command->dump_file(WRITE_DIRECTORY . 'customtest.xml');

    return AIBridge::aicommand($command->dump_mem(false, 'UTF-8'));
  }

  function appendStandardTestXML($xmldoc, $parentNode, $parameters)
  {
    $testMode = $parameters['type'];
    $runMode = $parameters['durationType'];
    $runTime = $parameters['durationValue'];
    $stopOnError = $parameters['stopOnError'];
    $devices = $parameters['devices'];
    // Determine the appropriate parameters
    if ($testMode == 'quick')
      $caption = translate('MSG_QUICK_TEST');
    else if ($testMode == 'complete')
      $caption = translate('MSG_COMPLETE_TEST');
    else if ($testMode == 'custom')
      $caption = translate('MSG_CUSTOM_TEST');
    else
      $caption = $testMode;
    if ($runMode == 'time')
      $durationType = 'desiredTestTime';
    else if ($runMode == 'loop')
      $durationType = 'testLoops';
    else
      $durationType = $runMode;
    // Load the idResult
    $idResult = new XMLDocument(file_get_contents(IDRESULT_PATH));
    $xpath = xpath_new_context($idResult->document_element());
    // Build the xml command
    $diagRun = $parentNode->append_child($xmldoc->create_element('diagRun'));
    $diagRun->set_attribute('jobCaption', $caption);
    $diagRun->set_attribute($durationType, $runTime);
    $diagRun->set_attribute('language', LANG);
    $diagRun->set_attribute('stopOnError', ($stopOnError == 'yes') ? '1' : '0');
    // Iterate through the devices and get the required info
    foreach($devices as $deviceIdentifier)
    {
      $deviceIdentifierParts = explode(':::', $deviceIdentifier);
      $componentName = $deviceIdentifierParts[0];
      $deviceName = $deviceIdentifierParts[1];
      $deviceNodes = xpath_eval($xpath, ('/diagOutput/category/device[@component="' . $componentName . '" and @name="' . $deviceName . '"]'));
      $device = $deviceNodes->nodeset[0]; // there should be only 1 result
      $deviceXpath = xpath_new_context($device);
      $deviceCaption = $device->get_attribute('caption');
      $deviceClass = $device->get_attribute('class');
      $deviceCdmClass = $device->get_attribute('cdmClass');
      $deviceSlot = $device->get_attribute('Slot');
      if ($componentName == 'cdm')
        $deviceName = $device->get_attribute('deviceID');
      $tests = xpath_eval($deviceXpath, ('/test[@' . $testMode . '="1" and @fieldtest="1"]'));
      if (count($tests->nodeset) <= 0)
        $tests = xpath_eval($deviceXpath, ('/test[@' . $testMode . '="1" and @fieldtest="1" and (../@component!="cdm" or @package="1")]'));
      foreach($tests->nodeset as $test)
      {
        $testName = $test->get_attribute('name');
        $testCaption = $test->get_attribute('caption');
        $testDescription = $test->get_attribute('description');
        $testSingleThread = $test->get_attribute('singleThread');
        $testInteractive = $test->get_attribute('interactive');
        $runTest = $diagRun->append_child($xmldoc->create_element('runTest'));
        $runTest->set_attribute('component', $componentName);
        $runTest->set_attribute('deviceClass', $deviceClass);
        if ($componentName == 'cdm')
          $runTest->set_attribute('cdmClass', $deviceCdmClass);
        $runTest->set_attribute('tcLoadFilename', ($componentName . '.dat'));
        $runTest->set_attribute('language', LANG);
        $runTest->set_attribute('device', $deviceName);
        $runTest->set_attribute('test', $testName);
        $runTest->set_attribute('description', $testDescription);
        $runTest->set_attribute('caption', ($deviceCaption . ' - ' . $testCaption));
        if ($deviceSlot != '')
          $runTest->set_attribute('Slot', $deviceSlot);
        if ($testSingleThread != '')
          $runTest->set_attribute('singleThread', $testSingleThread);
        else
          $runTest->set_attribute('singleThread', '0');
        if ($testInteractive != '')
          $runTest->set_attribute('interactive', $testInteractive);
        else
          $runTest->set_attribute('interactive', '0');
        if ($testMode == 'quick')
          $runTest->set_attribute('quick', '1');
      }
    }
  }

  function startDiagnosisTests($devices)
  {
    // Load the idResult
    $idResult = new XMLDocument(file_get_contents(IDRESULT_PATH));
    $xpath = xpath_new_context($idResult->document_element());
    // Build the xml command
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('startProcess');
    $diagRunDiagnosis = $root->append_child($command->create_element('diagRunDiagnosis'));
    $diagRunDiagnosis->set_attribute('jobCaption', translate('MSG_HARDWARE_DIAGNOSIS'));
    $diagRunDiagnosis->set_attribute('language', LANG);
    foreach ($devices as $deviceName)
    {
      $deviceNodes = xpath_eval($xpath, ('//device[@name="' . $deviceName . '"]'));
      if (count($deviceNodes->nodeset) > 0)
      {
        $device = $deviceNodes->nodeset[0];
        $component = $device->get_attribute('component');
        $caption = $device->get_attribute('caption');
        $runDiagnosis = $diagRunDiagnosis->append_child($command->create_element('runDiagnosis'));
        $runDiagnosis->set_attribute('device', $deviceName);
        $runDiagnosis->set_attribute('component', $component);
        $runDiagnosis->set_attribute('caption', $caption);
      }
    }

    return AIBridge::aicommand($command->dump_mem(false, 'UTF-8'));
  }

  function startTestScript($filepath)
  {
    $scriptDoc = new XMLDocument(file_get_contents($filepath));
    $scriptXPath = xpath_new_context($scriptDoc->document_element());
    $idResultXML = new XMLDocument(file_get_contents(IDRESULT_PATH));
    $idResultXPath = xpath_new_context($idResultXML->document_element());
    $runTests = xpath_eval($scriptXPath, '/diagRun/runTest');
    foreach ($runTests->nodeset as $runTest)
    {
      $deviceName = $runTest->get_attribute('device');
      $testName = $runTest->get_attribute('test');
      $tests = xpath_eval($idResultXPath, "/diagOutput/category/device[@name='{$deviceName}']/test[@name='{$testName}']");
      if (count($tests->nodeset) > 0)
      {
        $test = $tests->nodeset[0]; // we only check the first one
        $device = $test->parent_node();
        $deviceCaption = $device->get_attribute('caption');
        $testCaption = "";
        if ($runTest->has_attribute('caption'))
        {
          $testCaption = $runTest->get_attribute('caption');
        }
        if (empty($testCaption))
        {
          $testCaption = $test->get_attribute('caption');
        }
        $captionString = implode(' - ', array($deviceCaption, $testCaption)); // do it this way so that if one is missing, the dash is not created
        $runTest->set_attribute('caption', $captionString);
      }
    }
    return AIBridge::aicommand($scriptDoc->dump_mem(false, 'UTF-8'));
  }

  function makeDirectory($directoryName)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('makeDirectory');
    $root->set_content($directoryName);
    return AIBridge::aicommand($command->dump_mem());
  }

  function removeDirectory($directoryName)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('removeDirectory');
    $root->set_content($directoryName);
    return AIBridge::aicommand($command->dump_mem());
  }

  function mountDevice($device, $directory='', $fat=false)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('mountDevice');
    $deviceElement = $root->append_child($command->create_element('device'));
    $deviceElement->set_content($device);
    $directoryElement = $root->append_child($command->create_element('directory'));
    $directoryElement->set_content($directory);
    if ($fat)
      $root->set_attribute('fat', '1');
    return AIBridge::aicommand($command->dump_mem());
  }

  function unmountDevice($mountPoint)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('unmountDevice');
    $root->set_content($mountPoint);
    return AIBridge::aicommand($command->dump_mem());
  }

  function copyFile($source, $destination)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('copyFile');
    $sourceElement = $root->append_child($command->create_element('source'));
    $sourceElement->set_content($source);
    $destinationElement = $root->append_child($command->create_element('destination'));
    $destinationElement->set_content($destination);
    return AIBridge::aicommand($command->dump_mem());
  }

  function callSgscan()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('callSgscan');
    return AIBridge::aicommand($command->dump_mem());
  }

  function callSgmap()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('callSgmap');
    return AIBridge::aicommand($command->dump_mem());
  }

  function changeComparisonPermissions()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('changeComparisonPermissions');
    return AIBridge::aicommand($command->dump_mem());
  }

  function createFactoryXML($sourceFile, $testScriptsOnly=false)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('createFactoryXML');
    $root->set_content($sourceFile);
    if ($testScriptsOnly === true)
      $root->set_attribute('testScriptsOnly', '1');
    return AIBridge::aicommand($command->dump_mem());
  }

  function startConfigVerify()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('startConfigVerify');
    return AIBridge::aicommand($command->dump_mem());
  }

  function getSaveDevices()
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('getRemovableMediaDevices');
    return AIBridge::aicommand($command->dump_mem());
  }
  
  function checkForFileOnSaveDevice($devicePath, $fileName)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('checkForRemovableMediaFile');
    $root->set_attribute('devicePath', $devicePath);
    $root->set_attribute('filename', $fileName);
    return AIBridge::aicommand($command->dump_mem());
  }

  function copyFileToSaveDevice($tempFilePath, $devicePath, $fileName)
  {
    $command = domxml_new_doc('1.0');
    $root = $command->add_root('copyFileToRemovableMediaDevice');
    $root->set_attribute('srcPath', $tempFilePath);
    $root->set_attribute('devicePath', $devicePath);
    $root->set_attribute('filename', $fileName);
    return AIBridge::aicommand($command->dump_mem());
  }
}

//*/
?>
