<?php
  $systemConstants = get_defined_constants(); // used in debug mode as a filter

  require_once 'constants.php';
  require_once 'translations.php';

  /* DECLARE ADDITIONAL CONSTANTS */
  define('MANUAL_OVERRIDE', (isset($_REQUEST['man']) && $_REQUEST['man'] == '1'));
  define('SURVEY_ONLY', isSurveyOnly());
  define('IML_SUPPORT', isImlSupported());
  define('DIAGNOSIS_SUPPORT', isDiagnosisSupported());
  define('DISPLAY_ERROR_SLOTS', shouldDisplayErrorSlots());

  /* GLOBAL FUNCTIONS */

  function frontendStartup()
  {
    $idResult = new XMLDocument(file_get_contents(IDRESULT_PATH));
    $xpath = xpath_new_context($idResult->document_element());

    $diagOutput = @ xpath_eval($xpath, '/diagOutput');
    if (count($diagOutput->nodeset) > 0)
    {
      $diagOutput = $diagOutput->nodeset[0];
      define('DIAGS_VERSION', $diagOutput->get_attribute('buildVersion'));
      define('DIAGS_BUILD_DATE', $diagOutput->get_attribute('buildDate'));
    }
    else
    {
      define('DIAGS_VERSION', '');
      define('DIAGS_BUILD_DATE', '');
    }
    
    define('DIAGS_COPYRIGHT', (translate('MSG_COPYRIGHT') . ' &copy; 2002 - 2010 Hewlett-Packard Development Company, L.P.'));

    $runMeNowTests = @ xpath_eval($xpath, '/diagOutput/category/device/test[@runMeNow="1"]');
    $numberOfTests = count($runMeNowTests->nodeset);
    if ($numberOfTests > 0)
    {
      $testsArray = array();
      foreach ($runMeNowTests->nodeset as $test)
      {
        $testArray = array();
        $parent = $test->parent_node();
        $testArray['test'] = $test->get_attribute('name');
        $testArray['device'] = $parent->get_attribute('name');
        $testArray['component'] = $parent->get_attribute('component');
        $testsArray[] = $testArray;
      }
      require_once 'aibridge.class.php';
      $stdout = AIBridge::startCustomTests('', '', '', '', $testsArray, true);
      $xml = new XMLDocument($stdout);
      if ($xml)
      {
        $root = $xml->document_element();
        if ($root->tagname() != 'error')
        {
          define('SCRIPT_TESTING', true);
          define('SCRIPT_TESTING_PID', $root->get_attribute('processID'));
        }
        else
        {
          define('SCRIPT_TESTING', false);
          define('SCRIPT_TESTING_ERROR', $root->get_content());
        }
      }
      else
      {
        define('SCRIPT_TESTING', false);
        define('SCRIPT_TESTING_ERROR', ('XMLDOC Error: ' . $stdout));
      }
    }
    
    if (!defined('SCRIPT_TESTING') &&      // Make sure we aren't running script testing already (runMeNow tests)
        MANUAL_OVERRIDE != true &&         // Make sure manual override has not been declared
        checkDiagConfig('/src') == true && // Make sure we have /src files defined in diagconfig.xml
        IS_FACTORY == true)                // Make sure we are in factory mode
    {
      $diagconfig = new XMLDocument(file_get_contents(DIAGCONFIG_PATH));
      $xpath = xpath_new_context($diagconfig->document_element());
      $srcs = @ xpath_eval($xpath, '/src');
      $src = $srcs->nodeset[0];
      $srcFilename = $src->get_attribute('name');
      $srcDirectory = $src->get_attribute('path');
      if ($srcDirectory == '')
        $srcDirectory = WRITE_DIRECTORY;

      if (strstr($srcFilename, 'factory.xml'))
      {
        $forceRetranslate = checkDiagConfig('/factory/forceTestScriptRetranslate');
        // Create factory.xml if it is missing
        if (!file_exists($srcDirectory . 'factory.xml') ||
            $forceRetranslate === true)
        {
          chdir($srcDirectory);
          $files = glob('*.src.xml');

          // if we don't find any source files, we will exit with an error message
          if (count($files) <= 0)
            exit('<b>There are no *.src.xml files located in ' . $srcDirectory . ' - factory.xml could not be created.</b>');

          $srcXML = $files[0];
          require_once 'aibridge.class.php';
          if ($forceRetranslate === false ||
              (!file_exists($srcDirectory . 'factory.xml')))
            AIBridge::createFactoryXML($srcXML, false);
          else
            AIBridge::createFactoryXML($srcXML, true);
        }
        $factoryXML = new XMLDocument(file_get_contents($srcDirectory . $srcFilename));
        $factoryRoot = $factoryXML->document_element();
        $xpath = xpath_new_context($factoryRoot);
        $station = $factoryRoot->get_attribute('station');
        $srcFileNodeset = @ xpath_eval($xpath, ('/src[@station="' . $station . '"]'));
        $srcFile = $srcFileNodeset->nodeset[0];
        $status = $srcFile->get_attribute('status');
        // if we've passed this station, move to the next one
        if (strtolower($status) == 'passed')
        {
          $station++;
          $srcFileNodeset = @ xpath_eval($xpath, ('/src[@station="' . $station . '"]'));
          $srcFile = $srcFileNodeset->nodeset[0];
          // update station number in factory.xml and save changes
          $factoryRoot->set_attribute('station', $station);
          $factoryXML->dump_file(($srcDirectory . $srcFilename), false, true);
        }
        $scriptFilepath = ($srcDirectory . $srcFile->get_attribute('name'));
      }
      else
      {
        $scriptFilepath = ($srcDirectory . $srcFilename);
      }
      // Check for errors
      if (!checkDiagConfig('/factory/ignoreErrorLog'))
      {
        require_once 'aibridge.class.php';
        $errorLog = new XMLDocument(AIBridge::getErrorLog());
        $xpath = xpath_new_context($errorLog->document_element());
        $errorLogRecords = @ xpath_eval($xpath, '/errorLogRecord');
        if (count($errorLogRecords->nodeset) > 0)
        {
          define('FACTORY_ERRORS_FOUND', 1);
        }
      }
      if (!defined('FACTORY_ERRORS_FOUND'))
      {
        if (!file_exists($scriptFilepath))
        {
          define('SCRIPT_FILE_NOT_FOUND', 1);
        }
        else
        {
          require_once 'aibridge.class.php';
          $stdout = AIBridge::startTestScript($scriptFilepath);
          $xml = new XMLDocument($stdout);
          if ($xml)
          {
            $root = $xml->document_element();
            if ($root->tagname() != 'error')
            {
              define('SCRIPT_TESTING', true);
              define('SCRIPT_TESTING_PID', $root->get_attribute('processID'));
              if (checkDiagConfig('/factory/autoCloseOnFinish'))
                define('SCRIPT_TESTING_AUTO_CLOSE', true);
            }
            else
            {
              define('SCRIPT_TESTING', false);
              define('SCRIPT_TESTING_ERROR', $root->get_content());
            }
          }
          else
          {
            define('SCRIPT_TESTING', false);
            define('SCRIPT_TESTING_ERROR', ('XMLDOC Error: ' . $stdout));
          }
        }
        define('SCRIPT_TESTING', false);
      }
    }

    if (DEBUG_MODE == true)
    {
      $constants = getUserConstants();
      $debugFile = fopen(FRONTEND_DEBUG_FILE, 'a');
      fwrite($debugFile, (date('Y-m-d H:i:s') . "\nFrontend has started ...\nConstants:\n" . print_r($constants, true) . "\n\n"));
      fclose($debugFile);
    }
  }

  function getUserConstants()
  {
    global $systemConstants;
    $countOfSystemConstants = count($systemConstants);
    $constants = get_defined_constants();
    $userConstants = array_slice($constants, $countOfSystemConstants);
    return $userConstants;
  }

  function isImlSupported()
  {
    $returnVal = false;
    $xml = new XMLDocument(file_get_contents(IDRESULT_PATH));
    $xpath = xpath_new_context($xml->document_element());
    $imlLogEntry = @ xpath_eval($xpath, '/diagOutput/category[@name="miscellaneous"]/device[@name="IML0"]');
    if (count($imlLogEntry->nodeset) > 0)
    {
      $caption = $imlLogEntry->nodeset[0]->get_attribute('caption');
      if (strstr($caption, 'Not available') === false)
        $returnVal = true;
    }
    return $returnVal;
  }
  
  function isDiagnosisSupported()
  {
    if (IS_FACTORY)
    {
      return false; // factory does not need diagnosis
    }
    $xml = new XMLDocument(file_get_contents(IDRESULT_PATH));
    $root = $xml->document_element();
    $diagOutputs = $root->get_elements_by_tagname("diagOutput");
    $diagOutput = $diagOutputs[0];
    if ($diagOutput->has_attribute("enableDiagnosisTab"))
    {
      $enable = $diagOutput->get_attribute("enableDiagnosisTab");
      return ($enable == "1") ? true : false;
    }
    else
    {
      return true; // backwards compatible: if attribute is missing, we will show diagnosis tab
    }
  }

  function isSurveyOnly()
  {
    $returnVal = false;
    if (IS_FACTORY == false && ADVANCED_MODE == false)
    {
      if (checkDiagConfig('/mode', 'surveyOnly', '1'))
      {
        if (checkDiagConfig('/mode', 'envior', 'online') && IS_ONLINE)
          $returnVal = true;
        else if (checkDiagConfig('/mode', 'envior', 'offline') && IS_PHOENIX)
          $returnVal = true;
      }
    }
    return $returnVal;
  }
  
  function shouldDisplayErrorSlots()
  {
    return checkDiagConfig('/factory/ErrorScreenSlots');
  }

  // Check the $_REQUEST global for the given list of parameters, accepts multiple strings
  function requiredParameters()
  {
    // We default to a true response
    $returnVal = true;
    // Get the passed arguments, must be done this way to accomadate variable length argument list
    $arguments = func_get_args();
    foreach ($arguments as $parameter)
    {
      // If any parameter is not found, returnVal becomes false
      if (!isset($_REQUEST[$parameter]))
        $returnVal = false;
    }
    return $returnVal;
  }

  function getComputerName()
  {
    $computerName = '';
    if (file_exists(IDRESULT_PATH))
    {
      $xml = new XMLDocument(file_get_contents(IDRESULT_PATH));
      $xpath = xpath_new_context($xml->document_element());
      $hostNameNodes = @ xpath_eval($xpath, '/diagOutput/category[@name="miscellaneous"]/structure[@name="systemSummary"]/property[@name="hostName"]');
      if (count($hostNameNodes->nodeset) > 0)
        $computerName = $hostNameNodes->nodeset[0]->get_attribute('value');
    }
    return $computerName;
  }

  function getSerialNumber()
  {
    $serialNumber = '';
    if (file_exists(IDRESULT_PATH))
    {
      $xml = new XMLDocument(file_get_contents(IDRESULT_PATH));
      $xpath = xpath_new_context($xml->document_element());
      $serialNumberNode = extractFirstNode($xpath, '/diagOutput/category[@name="assetControl"]/structure[@name="productIdentification"]/property[@name="serialNumber"]');
      if ($serialNumberNode !== false)
      {
        $validCharacters = array_merge(range(0, 9), range('a', 'z'), range('A', 'Z'));
        $validCharacterString = implode('', $validCharacters);
        $serialNumberValue = trim($serialNumberNode->get_attribute('value'));
        $numberOfCharacters = strlen($serialNumberValue);
        if (strspn($serialNumberValue, $validCharacterString) == $numberOfCharacters)
          $serialNumber = $serialNumberValue;
      }
    }
    return $serialNumber;
  }
  
  function getBuildVersion()
  {
    $buildVersion = '';
    if (file_exists(IDRESULT_PATH))
    {
      $xml = new XMLDocument(file_get_contents(IDRESULT_PATH));
      $xpath = xpath_new_context($xml->document_element());
      $diagOutputNodes = @ xpath_eval($xpath, '/diagOutput');
      if (count($diagOutputNodes->nodeset) > 0)
        $buildVersion = $diagOutputNodes->nodeset[0]->get_attribute('buildVersion');
    }
    return $buildVersion;
  }

  function extractFirstNode(&$target, $xpath)
  {
    $nodes = @ xpath_eval($target, $xpath);
    if (count($nodes->nodeset) > 0)
      return $nodes->nodeset[0];
    else
      return false;
  }

  function extractTags()
  {
    $arguments = func_get_args();
    $returnVal = array();
    $xmlString = $arguments[0];
    $xml = new XMLDocument($xmlString);
    $xpath = xpath_new_context($xml->document_element());
    for ($i=1; $i<count($arguments); $i++)
    {
      $tagname = $arguments[$i];
      $elements = @ xpath_eval($xpath, '/'.$tagname);
      $tag = $elements->nodeset[0];
      if ($tag)
        $returnVal[$tagname] = $tag->get_content();
      else
        $returnVal[$tagname] = '';
    }
    return $returnVal;
  }

  function echoln($msg)
  {
    echo ($msg . "\n");
  }

  function writeArguments()
  {
    if (file_exists(FRONTEND_DEBUG_FILE))
    {
      $size = filesize(FRONTEND_DEBUG_FILE);
      // if debug file is greater than 1/2 megabyte in size, clear and refresh
      if ($size > 524288)
      {
        $constants = getUserConstants();
        $debugFile = fopen(FRONTEND_DEBUG_FILE, 'w');
        fwrite($debugFile, (date('Y-m-d H:i:s') . "\nDebug File Cleared\nConstants:\n" . print_r($constants, true) . "\n"));
      }
    }
    if (count($_GET) > 0)
      $GET = ("GET:\n" . print_r($_GET, true));
    else
      $GET = "GET: empty\n";
    if (count($_POST) > 0)
      $POST = ("POST:\n" . print_r($_POST, true));
    else
      $POST = "POST: empty\n";
    $debugFile = fopen(FRONTEND_DEBUG_FILE, 'a');
    fwrite($debugFile, (date('Y-m-d H:i:s') . "\n" . $_SERVER['PHP_SELF'] . ": arguments:\n" . $GET . $POST . "\n"));
    fclose($debugFile);
  }
  
  function appendViewHeader(&$output)
  {
    $output[] = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"';
    $output[] = '"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
    $output[] = '<html xmlns="http://www.w3.org/1999/xhtml">';
    $output[] = '<head>';
    $output[] = '<title>view</title>';
    $output[] = '<link type="text/css" rel="stylesheet" media="all" href="../css/views.css"></link>';
  }

  function outputViewHeader()
  {
    $output = array();
    appendViewHeader($output);
    echo implode('', $output);
  }
  
  function appendViewFooter(&$output)
  {
    $output[] = '</body>';
    $output[] = '</html>';
  }
  
  function outputViewFooter()
  {
    $output = array();
    appendViewFooter($output);
    echo implode('', $output);
  }

  function buildJsConfig()
  {
    require_once 'rosetta.class.php';
    $CONFIG = array();

    $CONFIG['DEBUG_MODE'] = (DEBUG_MODE === true) ? true : false;
    $CONFIG['DEBUG_ACTIVE'] = false;
    $CONFIG['ADVANCED_MODE'] = (ADVANCED_MODE === true) ? true : false;
    $CONFIG['SURVEY_ONLY'] = (SURVEY_ONLY === true) ? true : false;
    $CONFIG['IS_WINDOWS'] = (IS_WINDOWS === true) ? true : false;
    $CONFIG['IS_LINUX'] = (IS_LINUX === true) ? true : false;
    $CONFIG['IS_SOLARIS'] = (IS_SOLARIS === true) ? true : false; 
    $CONFIG['IS_OFFLINE'] = (IS_OFFLINE === true) ? true : false;
    $CONFIG['IS_ONLINE'] = (IS_ONLINE === true) ? true : false;
    $CONFIG['IS_SMH'] = (IS_SMH === true) ? true : false;
    $CONFIG['IS_FACTORY'] = (IS_FACTORY === true) ? true : false;
    $CONFIG['IML_SUPPORT'] = (IML_SUPPORT === true) ? true : false;
    $CONFIG['DIAGNOSIS_SUPPORT'] = (DIAGNOSIS_SUPPORT === true) ? true : false;
    $CONFIG['BASE_URI'] = FRONTEND_DIRECTORY;

    if (defined('OVERRIDE_LANG'))
      $CONFIG['OVERRIDE_LANG'] = OVERRIDE_LANG;

    if (isset($_GET['overrideIdResult']))
      $CONFIG['OVERRIDE_IDRESULT'] = $_GET['overrideIdResult'];

    if (defined('SCRIPT_TESTING') && SCRIPT_TESTING === true)
      $CONFIG['SCRIPT_TESTING_PID'] = SCRIPT_TESTING_PID;

    $CONFIG['SCRIPT_TESTING_AUTO_CLOSE'] = (defined('SCRIPT_TESTING_AUTO_CLOSE') && SCRIPT_TESTING_AUTO_CLOSE === true)? true : false;

    $CONFIG['FACTORY_ERRORS_FOUND'] = (defined('FACTORY_ERRORS_FOUND') && FACTORY_ERRORS_FOUND === true) ? true : false;
    
    $CONFIG['HELP_SRC'] = 'help/hpdiagshelp.php';
    $CONFIG['DISPLAY_ERROR_SLOTS'] = DISPLAY_ERROR_SLOTS;
    
    return Rosetta::arrayToJSON($CONFIG);
  }

  function includeStyleSheet($filename)
  {
    $returnVal = '';
    $filepath = (DOCUMENT_DIRECTORY . 'css/' . $filename);
    if (file_exists($filepath))
    {
      $fileContents = file_get_contents($filepath);
      $stripped = str_replace(array("\r", "\n"), '', $fileContents);
      $returnVal = ('<style type="text/css">' . $stripped . '</style>');
    }
    else
    {
      $returnVal = ('<link type="text/css" rel="stylesheet" media="all" href="' . $filepath . '"></link>');
    }
    return $returnVal;
  }

  // DEBUG OUTPUT - if we are in debug mode, output all arguments to debug file
  if (DEBUG_MODE == true)
    writeArguments();
?>
